/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.exec.AbstractScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptSourceInput;

public class ScriptSourceInputAggregate
implements ScriptSourceInput {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaCreatorImpl.class);
    private final AbstractScriptSourceInput[] inputs;

    public ScriptSourceInputAggregate(AbstractScriptSourceInput[] inputs) {
        this.inputs = inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> extract(Function<Reader, List<String>> extractor) {
        List[] lists = new List[this.inputs.length];
        int size = 0;
        for (int i = 0; i < this.inputs.length; ++i) {
            AbstractScriptSourceInput scriptSourceInput = this.inputs[i];
            Reader reader = scriptSourceInput.prepareReader();
            try {
                log.executingScript(scriptSourceInput.getScriptDescription());
                lists[i] = extractor.apply(reader);
                size += lists[i].size();
                continue;
            }
            finally {
                scriptSourceInput.releaseReader(reader);
            }
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (List strings : lists) {
            list.addAll(strings);
        }
        return list;
    }

    @Override
    public boolean containsScript(URL url) {
        for (int i = 0; i < this.inputs.length; ++i) {
            if (!this.inputs[i].containsScript(url)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ScriptSourceInputAggregate(" + Arrays.toString(this.inputs) + ")";
    }
}

