/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest;

import ai.digital.deploy.permissions.MessageHandler;
import ai.digital.deploy.permissions.api.error.FieldErrorDto;
import ai.digital.deploy.permissions.api.error.FieldErrorDto$;
import ai.digital.deploy.permissions.api.error.PaginationParseError;
import ai.digital.deploy.permissions.api.error.ResourceAlreadyExistsError;
import ai.digital.deploy.permissions.api.error.ResourceNotFoundError;
import ai.digital.deploy.permissions.api.error.ValidationError;
import ai.digital.deploy.permissions.exception.PaginationParseException;
import ai.digital.deploy.permissions.exception.PrincipalNotFoundException;
import ai.digital.deploy.permissions.exception.ResourceAlreadyExistsException;
import ai.digital.deploy.permissions.exception.ResourceNotFoundException;
import ai.digital.deploy.permissions.exception.RoleIdNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNameAlreadyExistsException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.io.Serializable;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@RestControllerAdvice
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\u0005\n\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006E\u0001!\ta\t\u0005\bO\u0001\u0011\r\u0011\"\u0003)\u0011\u0019!\u0004\u0001)A\u0005S!)Q\u0007\u0001C\u0001m!)A\u000f\u0001C\u0001k\"9\u0011q\u0002\u0001\u0005\u0002\u0005E!aF#se>\u0014\b*\u00198eY&twmQ8oiJ|G\u000e\\3s\u0015\tQ1\"\u0001\u0003sKN$(B\u0001\u0007\u000e\u0003\r\t\u0007/\u001b\u0006\u0003\u001d=\t1\u0002]3s[&\u001c8/[8og*\u0011\u0001#E\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005I\u0019\u0012a\u00023jO&$\u0018\r\u001c\u0006\u0002)\u0005\u0011\u0011-[\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u000f[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\ty\u0002%D\u0001\u000e\u0013\t\tSB\u0001\bNKN\u001c\u0018mZ3IC:$G.\u001a:\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t\u0011\u0002C\u0003\u001e\u0005\u0001\u0007a$A\bwC2LG-\u0019;j_:,%O]8s+\u0005I\u0003C\u0001\u00162\u001d\tYs\u0006\u0005\u0002-35\tQF\u0003\u0002/+\u00051AH]8pizJ!\u0001M\r\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003ae\t\u0001C^1mS\u0012\fG/[8o\u000bJ\u0014xN\u001d\u0011\u0002+!\fg\u000e\u001a7f-\u0006d\u0017\u000eZ1uS>tWI\u001d:peR\u0011qc\u000e\u0005\u0006q\u0015\u0001\r!O\u0001\u0003Kb\u0004\"AO \u000f\u0005mjdB\u0001\u0017=\u0013\u0005Q\u0012B\u0001 \u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0013\u0015C8-\u001a9uS>t'B\u0001 \u001aQ\u0011)1)\u0015*\u0011\u0005\u0011{U\"A#\u000b\u0005\u0019;\u0015AC1o]>$\u0018\r^5p]*\u0011\u0001*S\u0001\u0005E&tGM\u0003\u0002K\u0017\u0006\u0019q/\u001a2\u000b\u00051k\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001VI\u0001\bSKN\u0004xN\\:f'R\fG/^:\u0002\u000bY\fG.^3%\u0003MK!\u0001V+\u0002\u0017\t\u000bEi\u0018*F#V+5\u000b\u0016\u0006\u0003-^\u000b!\u0002\u0013;uaN#\u0018\r^;t\u0015\tA6*\u0001\u0003iiR\u0004\b\u0006B\u0003[#v\u0003\"\u0001R.\n\u0005q+%\u0001E#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\3sY\rqV\r\\\u0012\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!mS\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017B\u00013b\u00055\u0011\u0015N\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\na\r\u0005\u0002hU6\t\u0001N\u0003\u0002j\u001b\u0005IQ\r_2faRLwN\\\u0005\u0003W\"\u0014\u0001\u0004U1hS:\fG/[8o!\u0006\u00148/Z#yG\u0016\u0004H/[8oG\u0005i\u0007C\u00018s\u001b\u0005y'B\u00012q\u0015\u0005\t\u0018a\u00026bW\u0006\u0014H/Y\u0005\u0003g>\u0014AdQ8ogR\u0014\u0018-\u001b8u-&|G.\u0019;j_:,\u0005pY3qi&|g.\u0001\biC:$G.\u001a(pi\u001a{WO\u001c3\u0015\u0005Yd\bCA<{\u001b\u0005A(BA=\f\u0003\u0015)'O]8s\u0013\tY\bPA\u000bSKN|WO]2f\u001d>$hi\\;oI\u0016\u0013(o\u001c:\t\u000ba2\u0001\u0019A?\u0011\u0005\u001dt\u0018BA@i\u0005e\u0011Vm]8ve\u000e,gj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8)\u000b\u0019\u0019\u0015+a\u0001%\u0005\u0005\u0015\u0011bAA\u0004+\u0006Iaj\u0014+`\r>+f\n\u0012\u0015\u0006\ri\u000b\u00161\u0002\u0017\u0003\u0003\u001b\u0019\u0013!`\u0001\u0014Q\u0006tG\r\\3BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u000b\u0005\u0003'\tI\u0002E\u0002x\u0003+I1!a\u0006y\u0005i\u0011Vm]8ve\u000e,\u0017\t\u001c:fC\u0012LX\t_5tiN,%O]8s\u0011\u0019At\u00011\u0001\u0002\u001cA\u0019q-!\b\n\u0007\u0005}\u0001N\u0001\u0010SKN|WO]2f\u00032\u0014X-\u00193z\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]\"\"qaQ)SQ\u00159!,UA\u0013Y\t\t9c\t\u0002\u0002\u001c!\u001a\u0001!a\u000b\u0011\u0007\u0011\u000bi#C\u0002\u00020\u0015\u0013ACU3ti\u000e{g\u000e\u001e:pY2,'/\u00113wS\u000e,\u0007")
public class ErrorHandlingController {
    private final MessageHandler messageHandler;
    private final String validationError;

    private String validationError() {
        return this.validationError;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class, PaginationParseException.class, ConstraintViolationException.class})
    public Object handleValidationError(Exception ex) {
        Exception exception = ex;
        if (exception instanceof BindException) {
            BindException bindException = (BindException)exception;
            return new ValidationError(this.messageHandler.getMessage(this.validationError(), (Seq<Object>)Nil$.MODULE$), FieldErrorDto$.MODULE$.toFieldErrorDto((List<FieldError>)CollectionConverters$.MODULE$.ListHasAsScala(bindException.getBindingResult().getFieldErrors()).asScala().toList()));
        }
        if (exception instanceof PaginationParseException) {
            PaginationParseException paginationParseException = (PaginationParseException)exception;
            return new PaginationParseError(paginationParseException.getMessage());
        }
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)exception;
            return new ValidationError(this.messageHandler.getMessage(this.validationError(), (Seq<Object>)Nil$.MODULE$), (List<FieldErrorDto>)CollectionConverters$.MODULE$.SetHasAsScala(constraintViolationException.getConstraintViolations()).asScala().toList().map((Function1 & Serializable)cv -> FieldErrorDto$.MODULE$.toFieldErrorDto(new FieldError(((Path.Node)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)cv.getPropertyPath()).asScala().toList().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ErrorHandlingController.$anonfun$handleValidationError$2(x$1))).getOrElse((Function0 & Serializable)() -> {
                throw constraintViolationException;
            })).getName(), ((Path.Node)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)cv.getPropertyPath()).asScala().toList().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ErrorHandlingController.$anonfun$handleValidationError$4(x$2))).getOrElse((Function0 & Serializable)() -> {
                throw constraintViolationException;
            })).getName(), cv.getMessage()))));
        }
        throw new MatchError((Object)exception);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResourceNotFoundError handleNotFound(ResourceNotFoundException ex) {
        ResourceNotFoundException resourceNotFoundException = ex;
        if (resourceNotFoundException instanceof PrincipalNotFoundException) {
            PrincipalNotFoundException principalNotFoundException = (PrincipalNotFoundException)resourceNotFoundException;
            return new ResourceNotFoundError(this.messageHandler.getMessage("principal.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{principalNotFoundException.name()})));
        }
        if (resourceNotFoundException instanceof RoleNameNotFoundException) {
            RoleNameNotFoundException roleNameNotFoundException = (RoleNameNotFoundException)resourceNotFoundException;
            return new ResourceNotFoundError(this.messageHandler.getMessage("role.name.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleNameNotFoundException.name()})));
        }
        if (resourceNotFoundException instanceof RoleIdNotFoundException) {
            RoleIdNotFoundException roleIdNotFoundException = (RoleIdNotFoundException)resourceNotFoundException;
            return new ResourceNotFoundError(this.messageHandler.getMessage("role.id.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleIdNotFoundException.id()})));
        }
        if (resourceNotFoundException != null) {
            ResourceNotFoundException resourceNotFoundException2 = resourceNotFoundException;
            return new ResourceNotFoundError(resourceNotFoundException2.message());
        }
        throw new MatchError((Object)resourceNotFoundException);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ResourceAlreadyExistsException.class})
    public ResourceAlreadyExistsError handleAlreadyExists(ResourceAlreadyExistsException ex) {
        ResourceAlreadyExistsException resourceAlreadyExistsException = ex;
        if (resourceAlreadyExistsException instanceof RoleNameAlreadyExistsException) {
            RoleNameAlreadyExistsException roleNameAlreadyExistsException = (RoleNameAlreadyExistsException)resourceAlreadyExistsException;
            return new ResourceAlreadyExistsError(this.messageHandler.getMessage("role.name.already.exists", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleNameAlreadyExistsException.name()})));
        }
        if (resourceAlreadyExistsException != null) {
            ResourceAlreadyExistsException resourceAlreadyExistsException2 = resourceAlreadyExistsException;
            return new ResourceAlreadyExistsError(resourceAlreadyExistsException2.message());
        }
        throw new MatchError((Object)resourceAlreadyExistsException);
    }

    public static final /* synthetic */ boolean $anonfun$handleValidationError$2(Path.Node x$1) {
        ElementKind elementKind = x$1.getKind();
        ElementKind elementKind2 = ElementKind.METHOD;
        return !(elementKind != null ? !elementKind.equals(elementKind2) : elementKind2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleValidationError$4(Path.Node x$2) {
        ElementKind elementKind = x$2.getKind();
        ElementKind elementKind2 = ElementKind.PARAMETER;
        return !(elementKind != null ? !elementKind.equals(elementKind2) : elementKind2 != null);
    }

    public ErrorHandlingController(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.validationError = "error.validation";
    }
}

