/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.engine.api.security.UserProfile;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="security")
@ClassHelp(description="Access to the security settings of XL Deploy.")
public class SecurityClient
extends DocumentedObject {
    private ProxiesInstance proxies;
    private DeployitCommunicator communicator;
    private static final Logger logger = LoggerFactory.getLogger(SecurityClient.class);

    public SecurityClient() {
    }

    public SecurityClient(ProxiesInstance proxies) {
        this.communicator = proxies.getCommunicator();
        this.proxies = proxies;
    }

    @MethodHelp(description="Logout the currently logged in user, can only perform further actions after a login")
    public void logout() {
        block2: {
            try {
                this.proxies.getServer().logout();
            }
            catch (WebApplicationException e) {
                int status = e.getResponse().getStatus();
                if (status == 401 || status == 403) break block2;
                throw e;
            }
        }
        this.communicator.getHttpClientHolder().logout();
    }

    @MethodHelp(description="Login a user", parameters={@ParameterHelp(name="username", description="The username"), @ParameterHelp(name="password", description="The password")})
    public void login(String username, String password) {
        logger.info("Logging in as {}", (Object)username);
        this.communicator.getHttpClientHolder().loginAs(username, password);
        try {
            ServerInfo serverInfo = this.proxies.getServer().getInfo();
        }
        catch (Exception e) {
            this.communicator.getHttpClientHolder().logout();
            throw new IllegalStateException("You're not authorized with these credentials. (" + username + ")", e);
        }
    }

    @MethodHelp(description="Create a user with the specified name and password", parameters={@ParameterHelp(name="username", description="The username"), @ParameterHelp(name="password", description="The password")}, returns="The created user")
    public User createUser(String username, String password) {
        return this.createUser(username, password, false);
    }

    public User createUser(String username, String password, boolean admin) {
        User user = new User(username, admin);
        user.setPassword(password);
        return this.proxies.getUser().create(username, user);
    }

    @MethodHelp(description="Create a user with the specified username, password, fullname and email", parameters={@ParameterHelp(name="username", description="The username"), @ParameterHelp(name="password", description="The password"), @ParameterHelp(name="fullName", description="The full name of the user"), @ParameterHelp(name="email", description="The email of the user")}, returns="The created user")
    public User createUser(String username, String password, String fullName, String email) {
        User user = new User(username, false);
        user.setPassword(password);
        UserProfile userProfile = new UserProfile();
        userProfile.setEmail(email);
        userProfile.setFullName(fullName);
        user.setUserProfile(userProfile);
        return this.proxies.getUser().create(username, user);
    }

    @MethodHelp(description="Read a user so that he/she can be modified.", parameters={@ParameterHelp(name="username", description="The username of the user to read")}, returns="The read user")
    public User readUser(String username) {
        return this.proxies.getUser().read(username);
    }

    @MethodHelp(description="Modify the (password of) the user.", parameters={@ParameterHelp(name="user", description="The updated user object.")})
    public void modifyUser(User user) {
        this.proxies.getUser().updateUser(user.getUsername(), user);
    }

    @MethodHelp(description="Delete a user.", parameters={@ParameterHelp(name="username", description="the username of the user to be deleted")})
    public void deleteUser(String username) {
        this.proxies.getUser().delete(username);
    }

    @MethodHelp(description="Grant a permission to a role", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role")})
    public void grant(String permission, String roleName) {
        this.doGrant(permission, roleName, "global");
    }

    @MethodHelp(description="Grant a permission to a role on a group of configuration items", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role"), @ParameterHelp(name="configurationItems", description="A list of configuration items to which the permission should apply")})
    public void grant(String permission, String roleName, List<String> configurationItems) {
        List<String> ids = SecurityClient.removeTrailingSlashes(configurationItems);
        for (String id : ids) {
            this.doGrant(permission, roleName, id);
        }
    }

    @MethodHelp(description="Revoke a permission from a role", parameters={@ParameterHelp(name="permission", description="The permission to revoke"), @ParameterHelp(name="roleName", description="The role")})
    public void revoke(String permission, String roleName) {
        this.doRevoke(permission, roleName, "global");
    }

    @MethodHelp(description="Revoke a permission from a role on a group of configuration items", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role"), @ParameterHelp(name="configurationItems", description="A list of configuration items from which the permission should be removed")})
    public void revoke(String permission, String roleName, List<String> configurationItems) {
        List<String> ids = SecurityClient.removeTrailingSlashes(configurationItems);
        for (String id : ids) {
            this.doRevoke(permission, roleName, id);
        }
    }

    private void doGrant(String permission, String role, String id) {
        this.proxies.getPermissions().grant(permission, id, role);
    }

    private void doRevoke(String permission, String role, String id) {
        this.proxies.getPermissions().revoke(permission, id, role);
    }

    @MethodHelp(description="Check whether a permission is granted to the logged in user on an id.", parameters={@ParameterHelp(name="permission", description="The permission to check"), @ParameterHelp(name="id", description="The path of the CI to check the permission on.")}, returns="true if the logged in user is granted the permission on the node.")
    public boolean hasPermission(String permission, String id) {
        return this.proxies.getPermissions().isGrantedToMe(permission, id);
    }

    @MethodHelp(description="Check whether a permission is granted to a role on an id.", parameters={@ParameterHelp(name="role", description="The role to check for"), @ParameterHelp(name="permission", description="The permission to check"), @ParameterHelp(name="id", description="The path of the CI to check the permission on.")}, returns="true if the role has the permission on the node.")
    public boolean isGranted(String role, String permission, String id) {
        return this.proxies.getPermissions().isGranted(permission, id, role);
    }

    @MethodHelp(description="Check whether a global permission is granted to a role.", parameters={@ParameterHelp(name="role", description="The role to check for"), @ParameterHelp(name="permission", description="The permission to check")}, returns="true if the role has the global permission granted.")
    public boolean isGranted(String role, String permission) {
        return this.proxies.getPermissions().isGranted(permission, "global", role);
    }

    @MethodHelp(description="Get permissions granted to a role", parameters={@ParameterHelp(name="role", description="The role whose permissions are to be retrieved")}, returns="A Map containing the nodes that the role has permissions on with the associated granted permissions")
    public Map<String, Collection<String>> getPermissions(String role) {
        return this.proxies.getPermissions().getGrantedPermissions(role);
    }

    @MethodHelp(description="Get permissions granted to the currently logged in user", parameters={}, returns="A Map containing the nodes that the logged in user has permissions on with the associated granted permissions")
    public Map<String, Collection<String>> getPermissions() {
        return this.proxies.getPermissions().getMyGrantedPermissions();
    }

    @MethodHelp(description="List all the permissions available in XL Deploy")
    public void printPermissions() {
        System.out.println("Available permissions are:");
        for (Permission permission : this.proxies.getReferenceData().listPermissions()) {
            System.out.println(permission.getPermissionName());
        }
    }

    @MethodHelp(description="Create or update a role with assigned principals.", parameters={@ParameterHelp(name="roleName", description="The role name"), @ParameterHelp(name="principals", description="The assigned principals")})
    public void assignRole(String roleName, List<String> principals) {
        if (principals == null || principals.isEmpty()) {
            this.proxies.getRoleService().create(roleName);
        } else {
            this.proxies.getRoleService().updatePrincipals(roleName, new ArrayList<String>(principals));
        }
    }

    @MethodHelp(description="Remove a role.", parameters={@ParameterHelp(name="roleName", description="The role name")})
    public void removeRole(String roleName) {
        this.proxies.getRoleService().delete(roleName);
    }

    @MethodHelp(description="Get all existing roles in XL Deploy.", returns="The list of role names")
    public List<String> getRoleNames() {
        return this.proxies.getRoleService().list();
    }

    @MethodHelp(description="Rename an existing role.", parameters={@ParameterHelp(name="oldName", description="The current role name"), @ParameterHelp(name="newName", description="The new role name")})
    public void renameRole(String oldName, String newName) {
        this.proxies.getRoleService().rename(oldName, newName);
    }

    @MethodHelp(description="Get the principals assigned to a specific role.", parameters={@ParameterHelp(name="roleName", description="The role name")}, returns="A list of principals assigned to the role")
    public List<String> getRoleAssignments(String roleName) {
        List assignments = this.proxies.getRoleService().readRolePrincipals();
        for (RolePrincipals assignment : assignments) {
            if (!assignment.getRole().getName().equals(roleName)) continue;
            return assignment.getPrincipals();
        }
        return new ArrayList<String>();
    }

    private static List<String> removeTrailingSlashes(List<String> repositoryEntityIds) {
        ArrayList<String> cleanRepositoryEntityIds = new ArrayList<String>();
        for (String repositoryEntityId : repositoryEntityIds) {
            cleanRepositoryEntityIds.add(repositoryEntityId.replaceFirst("/*$", ""));
        }
        return cleanRepositoryEntityIds;
    }
}

