/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.AssociationErrorEvent;
import org.apache.pekko.remote.AssociationEvent;
import org.apache.pekko.remote.DisassociatedEvent;
import org.apache.pekko.remote.EventPublisher;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.Transport;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%aA\u0002\n\u0014\u0003\u0003\u00192\u0004\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001.\u0011!\t\u0004A!A!\u0002\u0013q\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011M\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000bE\u0003a\u0011\u0001*\t\u000fY\u0003!\u0019!C\u0001/\"11\f\u0001Q\u0001\naCQ\u0001\u0018\u0001\u0005\u0002uCQa\u001f\u0001\u0005\u0002qDQ! \u0001\u0005\ny\u0014Q\"\u00128ea>Lg\u000e^!di>\u0014(B\u0001\u000b\u0016\u0003\u0019\u0011X-\\8uK*\u0011acF\u0001\u0006a\u0016\\7n\u001c\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0005\u0003\u00019\tB\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$M5\tAE\u0003\u0002&+\u0005)\u0011m\u0019;pe&\u0011q\u0005\n\u0002\u0006\u0003\u000e$xN\u001d\t\u0003G%J!A\u000b\u0013\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0002\u00191|7-\u00197BI\u0012\u0014Xm]:\u0004\u0001U\ta\u0006\u0005\u0002$_%\u0011\u0001\u0007\n\u0002\b\u0003\u0012$'/Z:t\u00035awnY1m\u0003\u0012$'/Z:tA\u0005i!/Z7pi\u0016\fE\r\u001a:fgN\faB]3n_R,\u0017\t\u001a3sKN\u001c\b%A\u0005ue\u0006t7\u000f]8siV\ta\u0007\u0005\u00028s5\t\u0001H\u0003\u00025'%\u0011!\b\u000f\u0002\n)J\fgn\u001d9peR\f!\u0002\u001e:b]N\u0004xN\u001d;!\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001 \u0011\u0005}\u0002U\"A\n\n\u0005\u0005\u001b\"A\u0004*f[>$XmU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\nQaY8eK\u000e,\u0012!\u0012\t\u0003o\u0019K!a\u0012\u001d\u0003\u001bA+7n[8QIV\u001cu\u000eZ3d\u0003\u0019\u0019w\u000eZ3dA\u00051A(\u001b8jiz\"ba\u0013'N\u001d>\u0003\u0006CA \u0001\u0011\u0015Y3\u00021\u0001/\u0011\u0015\u00114\u00021\u0001/\u0011\u0015!4\u00021\u00017\u0011\u0015a4\u00021\u0001?\u0011\u0015\u00195\u00021\u0001F\u0003\u001dIgNY8v]\u0012,\u0012a\u0015\t\u0003;QK!!\u0016\u0010\u0003\u000f\t{w\u000e\\3b]\u0006qQM^3oiB+(\r\\5tQ\u0016\u0014X#\u0001-\u0011\u0005}J\u0016B\u0001.\u0014\u00059)e/\u001a8u!V\u0014G.[:iKJ\fq\"\u001a<f]R\u0004VO\u00197jg\",'\u000fI\u0001\raV\u0014G.[:i\u000bJ\u0014xN\u001d\u000b\u0004=\u0006|\u0007CA\u000f`\u0013\t\u0001gD\u0001\u0003V]&$\b\"\u00022\u0010\u0001\u0004\u0019\u0017A\u0002:fCN|g\u000e\u0005\u0002eY:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q2\na\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005-t\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005-t\u0002\"\u00029\u0010\u0001\u0004\t\u0018\u0001\u00037pO2+g/\u001a7\u0011\u0005IDhBA:w\u001b\u0005!(BA;\u0016\u0003\u0015)g/\u001a8u\u0013\t9H/A\u0004M_\u001e<\u0017N\\4\n\u0005eT(\u0001\u0003'pO2+g/\u001a7\u000b\u0005]$\u0018\u0001\u00069vE2L7\u000f\u001b#jg\u0006\u001c8o\\2jCR,G\rF\u0001_\u0003)!(/\u001f)vE2L7\u000f\u001b\u000b\u0003=~Dq!!\u0001\u0012\u0001\u0004\t\u0019!\u0001\u0002fmB\u0019q(!\u0002\n\u0007\u0005\u001d1C\u0001\tBgN|7-[1uS>tWI^3oi\u0002")
public abstract class EndpointActor
implements Actor,
ActorLogging {
    private final Address localAddress;
    private final Address remoteAddress;
    private final Transport transport;
    private final RemoteSettings settings;
    private final PekkoPduCodec codec;
    private final EventPublisher eventPublisher;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Address localAddress() {
        return this.localAddress;
    }

    public Address remoteAddress() {
        return this.remoteAddress;
    }

    public Transport transport() {
        return this.transport;
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public PekkoPduCodec codec() {
        return this.codec;
    }

    public abstract boolean inbound();

    public EventPublisher eventPublisher() {
        return this.eventPublisher;
    }

    public void publishError(Throwable reason, int logLevel) {
        this.tryPublish(new AssociationErrorEvent(reason, this.localAddress(), this.remoteAddress(), this.inbound(), logLevel));
    }

    public void publishDisassociated() {
        this.tryPublish(new DisassociatedEvent(this.localAddress(), this.remoteAddress(), this.inbound()));
    }

    private void tryPublish(AssociationEvent ev) {
        try {
            this.eventPublisher().notifyListeners(ev);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.log().error(throwable2, "Unable to publish error event to EventStream.");
            }
            throw throwable;
        }
    }

    public EndpointActor(Address localAddress, Address remoteAddress, Transport transport, RemoteSettings settings, PekkoPduCodec codec) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.settings = settings;
        this.codec = codec;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.eventPublisher = new EventPublisher(this.context().system(), this.log(), settings.RemoteLifecycleEventsLogLevel());
        Statics.releaseFence();
    }
}

