/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import jakarta.persistence.spi.TransformerException;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContextWrapper;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ClassTransformer;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private final EnhancementContext enhancementContext;
    private final BytecodeProvider bytecodeProvider;

    public EnhancingClassTransformerImpl(EnhancementContext enhancementContext) {
        Objects.requireNonNull(enhancementContext);
        this.enhancementContext = enhancementContext;
        this.bytecodeProvider = BytecodeProviderInitiator.buildDefaultBytecodeProvider();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws TransformerException {
        try {
            Enhancer enhancer = this.bytecodeProvider.getEnhancer(new EnhancementContextWrapper(this.enhancementContext, loader));
            byte[] byArray = enhancer.enhance(className, classfileBuffer);
            return byArray;
        }
        catch (Exception e) {
            throw new TransformerException("Error performing enhancement of " + className, (Throwable)e);
        }
        finally {
            this.bytecodeProvider.resetCaches();
        }
    }
}

