/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class HANASqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inLateral;

    public HANASqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean isCorrelated(CteStatement cteStatement) {
        return false;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        if (tableReference.isLateral() && !this.inLateral) {
            this.inLateral = true;
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
            this.inLateral = false;
        } else {
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
        }
    }

    @Override
    protected SqlAstNodeRenderingMode getParameterRenderingMode() {
        return this.inLateral ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : super.getParameterRenderingMode();
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        tableReference.getFunctionExpression().accept(this);
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("grouping sets (())");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorGtLtSyntax() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from sys.dummy";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    @Override
    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", tableInsert.getMutatingTable().getTableId(), this.getDialect()));
    }
}

