/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaVersion$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class FlightRecorderLoader$ {
    public static final FlightRecorderLoader$ MODULE$ = new FlightRecorderLoader$();

    public <T> T load(ClassicActorSystemProvider casp, String fqcn, T fallback, ClassTag<T> evidence$1) {
        ExtendedActorSystem system = (ExtendedActorSystem)casp.classicSystem();
        if (JavaVersion$.MODULE$.majorVersion() >= 11 && system.settings().config().getBoolean("pekko.java-flight-recorder.enabled")) {
            Try<T> try_ = system.dynamicAccess().createInstanceFor(fqcn, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, evidence$1);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object jfr = success.value();
                return (T)jfr;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                system.log().warning("Failed to load JFR flight recorder, falling back to noop. Exception: {}", (Object)ex.toString());
                return fallback;
            }
            throw new MatchError(try_);
        }
        return fallback;
    }

    private FlightRecorderLoader$() {
    }
}

