/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.client.GlobalPermissionsServiceClient;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.util.SortOrder;
import ai.digital.deploy.permissions.client.util.SortOrder$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Service
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0007\u000e\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0001\t\u0001C\u0001\u0003\")\u0001\n\u0001C!\u0013\")1\u000e\u0001C!Y\")q\u000e\u0001C!a\")q\u000e\u0001C!s\"9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\tI\u0005\u0001C!\u0003\u0017\u00121\u0005T8dC2<En\u001c2bYB+'/\\5tg&|gn]*feZL7-Z\"mS\u0016tGO\u0003\u0002\u000f\u001f\u0005)An\\2bY*\u0011\u0001#E\u0001\u0007G2LWM\u001c;\u000b\u0005I\u0019\u0012a\u00039fe6L7o]5p]NT!\u0001F\u000b\u0002\r\u0011,\u0007\u000f\\8z\u0015\t1r#A\u0004eS\u001eLG/\u00197\u000b\u0003a\t!!Y5\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\u0010\u0013\t!sB\u0001\u0010HY>\u0014\u0017\r\u001c)fe6L7o]5p]N\u001cVM\u001d<jG\u0016\u001cE.[3oi\u00069r\r\\8cC2\u0004VM]7jgNLwN\\*feZL7-\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SE\tqa]3sm&\u001cW-\u0003\u0002,Q\t9r\t\\8cC2\u0004VM]7jgNLwN\\*feZL7-\u001a\u0015\u0003\u00035\u0002\"AL\u001d\u000e\u0003=R!\u0001M\u0019\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00023g\u00059a-Y2u_JL(B\u0001\u001b6\u0003\u0015\u0011W-\u00198t\u0015\t1t'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0014aA8sO&\u0011!h\f\u0002\n\u0003V$xn^5sK\u0012\f1B]8mKN+'O^5dKB\u0011q%P\u0005\u0003}!\u00121BU8mKN+'O^5dK\"\u0012!!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t#e\t\u0005\u0002D\u00015\tQ\u0002C\u0003&\u0007\u0001\u0007a\u0005\u000b\u0002E[!)1h\u0001a\u0001y!\u0012a)L\u0001\u000fC\u0012$\u0007+\u001a:nSN\u001c\u0018n\u001c8t)\rQE+\u0019\t\u0003\u0017Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b1\u0001\u001a;p\u0015\ty\u0005+\u0001\u0003sKN$(BA)\u0012\u0003\r\t\u0007/[\u0005\u0003'2\u0013ADU8mK^KG\u000f[$m_\n\fG\u000eU3s[&\u001c8/[8og\u0012#x\u000eC\u0003V\t\u0001\u0007a+\u0001\u0005s_2,g*Y7f!\t9fL\u0004\u0002Y9B\u0011\u0011,H\u0007\u00025*\u00111,G\u0001\u0007yI|w\u000e\u001e \n\u0005uk\u0012A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u000f\t\u000bI!\u0001\u0019\u00012\u0011\u0007\rDgK\u0004\u0002eM:\u0011\u0011,Z\u0005\u0002=%\u0011q-H\u0001\ba\u0006\u001c7.Y4f\u0013\tI'N\u0001\u0003MSN$(BA4\u001e\u0003E\u0011X-\\8wKB+'/\\5tg&|gn\u001d\u000b\u0004\u00156t\u0007\"B+\u0006\u0001\u00041\u0006\"\u0002\n\u0006\u0001\u0004\u0011\u0017\u0001\u0002:fC\u0012$\"AY9\t\u000bU3\u0001\u0019\u0001,)\u0005\u0019\u0019\bC\u0001;x\u001b\u0005)(B\u0001<\u0012\u0003\rQ\u0007/Y\u0005\u0003qV\u0014aEU3bI>sG.\u001f+sC:\u001c\u0018m\u0019;j_:\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f)%QXp`A\u0005\u0003\u001b\ti\u0002E\u0002#w*K!\u0001`\b\u0003#A\u000bw-\u001b8bi\u0016$'+Z:q_:\u001cX\rC\u0003\u007f\u000f\u0001\u0007a+A\u0006s_2,\u0007+\u0019;uKJt\u0007bBA\u0001\u000f\u0001\u0007\u00111A\u0001\u0005a\u0006<W\rE\u0002\u001d\u0003\u000bI1!a\u0002\u001e\u0005\rIe\u000e\u001e\u0005\b\u0003\u00179\u0001\u0019AA\u0002\u0003\u0011\u0019\u0018N_3\t\u000f\u0005=q\u00011\u0001\u0002\u0012\u0005)qN\u001d3feB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018=\tA!\u001e;jY&!\u00111DA\u000b\u0005%\u0019vN\u001d;Pe\u0012,'\u000f\u0003\u0004\u0002 \u001d\u0001\rAV\u0001\u0006M&,G\u000e\u001a\u0015\u0003\u000fM\fQdZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:S_2,\u0017\n\u001a\u000b\u0004E\u0006\u001d\u0002BBA\u0015\u0011\u0001\u0007a+\u0001\u0004s_2,\u0017\n\u001a\u0015\u0003\u0011M\f\u0001eZ3u\u000f2|'-\u00197QKJl\u0017n]:j_:\u001chi\u001c:Qe&t7-\u001b9bYR!\u0011\u0011GA\u001c!\u00119\u00161\u0007,\n\u0007\u0005U\u0002MA\u0002TKRDa!!\u000f\n\u0001\u00041\u0016!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW\r\u000b\u0002\ng\u0006ar-\u001a;HY>\u0014\u0017\r\u001c)fe6L7o]5p]N4uN\u001d*pY\u0016\u001cH\u0003BA!\u0003\u0007\u00022a\u00195K\u0011\u0019\t)E\u0003a\u0001E\u0006I!o\u001c7f\u001d\u0006lWm\u001d\u0015\u0003\u0015M\f\u0011C]3bI\nK(k\u001c7f!\u0006$H/\u001a:o)\u0011\t\t%!\u0014\t\u000by\\\u0001\u0019\u0001,)\u0005-\u0019\bf\u0004\u0001\u0002T\u0005\u001d\u0014\u0011NA8\u0003c\n)(a\u001e\u0011\t\u0005U\u00131M\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005I1m\u001c8eSRLwN\u001c\u0006\u0005\u0003;\ny&A\u0007bkR|7m\u001c8gS\u001e,(/\u001a\u0006\u0004\u0003C*\u0014\u0001\u00022p_RLA!!\u001a\u0002X\t)2i\u001c8eSRLwN\\1m\u001f:\u0004&o\u001c9feRL\u0018\u0001\u00028b[\u0016d#!a\u001b\"\u0005\u00055\u0014!\b=m]A,'/\\5tg&|g.L:feZL7-\u001a\u0018f]\u0006\u0014G.\u001a3\u0002\u0017!\fg/\u001b8h-\u0006dW/Z\u0011\u0003\u0003g\nA\u0001\u001e:vK\u0006qQ.\u0019;dQ&3W*[:tS:<\u0017$A\u0001)\u0007\u0001\tY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t)N\u0001\u000bgR,'/Z8usB,\u0017\u0002BAC\u0003\u007f\u0012qaU3sm&\u001cW\rK\u0004\u0001\u0003\u0013\u000b9*!'\u0011\t\u0005-\u00151S\u0007\u0003\u0003\u001bS1\u0001MAH\u0015\r\t\t*N\u0001\bG>tG/\u001a=u\u0013\u0011\t)*!$\u0003\u000fA\u0013xNZ5mK\u0006)a/\u00197vK2\u0012\u00111T\u0011\u0003\u0003;\u000b!\u0003]3s[&\u001c8/[8o[M,'O^5dK\"\u001a\u0001!!)\u0011\u0007Q\f\u0019+C\u0002\u0002&V\u0014a\u0004\u0016:b]N\f7\r^5p]\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3")
public class LocalGlobalPermissionsServiceClient
implements GlobalPermissionsServiceClient {
    @Autowired
    private final GlobalPermissionService globalPermissionService;
    @Autowired
    private final RoleService roleService;

    @Override
    public RoleWithGlobalPermissionsDto addPermissions(String roleName, List<String> permissions) {
        Right right;
        Tuple2 tuple2;
        Either either = this.globalPermissionService.add(roleName, permissions);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List gp = (List)tuple2._2();
            return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(gp));
        }
        throw new MatchError((Object)either);
    }

    @Override
    public RoleWithGlobalPermissionsDto removePermissions(String roleName, List<String> permissions) {
        Right right;
        Tuple2 tuple2;
        Either either = this.globalPermissionService.remove(roleName, permissions);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List gp = (List)tuple2._2();
            return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(gp));
        }
        throw new MatchError((Object)either);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<String> read(String roleName) {
        return RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(this.globalPermissionService.read(roleName));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public PaginatedResponse<RoleWithGlobalPermissionsDto> read(String rolePattern, int page, int size, SortOrder order, String field) {
        Page rolePage = this.roleService.read(rolePattern, (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)SortOrder$.MODULE$.getSort(order, field)));
        return new PaginatedResponse<RoleWithGlobalPermissionsDto>(CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList().map((Function1 & Serializable)role -> new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(CollectionConverters$.MODULE$.ListHasAsScala(role.globalPermissions()).asScala().toList()))), rolePage.getTotalElements(), page, size, rolePage.hasNext());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<String> getGlobalPermissionsForRoleId(String roleId) {
        return this.globalPermissionService.getGlobalPermissionsForRoleId(UUID.fromString(roleId));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<String> getGlobalPermissionsForPrincipal(String principalName) {
        return this.globalPermissionService.getGlobalPermissionsForPrincipal(principalName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleWithGlobalPermissionsDto> getGlobalPermissionsForRoles(List<String> roleNames) {
        return ((IterableOnceOps)this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$1 -> x$1.role()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Role role = (Role)tuple2._1();
                List permissions = (List)tuple2._2();
                return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), permissions.map((Function1 & Serializable)x$2 -> x$2.permissionName()));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleWithGlobalPermissionsDto> readByRolePattern(String rolePattern) {
        return ((IterableOnceOps)((IterableOps)Option$.MODULE$.apply((Object)rolePattern).map((Function1 & Serializable)rp -> $this.globalPermissionService.readByRolePattern(rp)).getOrElse((Function0 & Serializable)() -> $this.globalPermissionService.read())).groupBy((Function1 & Serializable)x$3 -> x$3.role()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Role role = (Role)tuple2._1();
                List permissions = (List)tuple2._2();
                return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), permissions.map((Function1 & Serializable)x$4 -> x$4.permissionName()));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    public LocalGlobalPermissionsServiceClient(@Autowired GlobalPermissionService globalPermissionService, @Autowired RoleService roleService) {
        this.globalPermissionService = globalPermissionService;
        this.roleService = roleService;
    }
}

