/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelRegistration {
    @Nullable
    private TaskExecutorRegistration registration;
    @Nullable
    private TaskExecutor executor;
    private final List<ChannelInterceptor> interceptors = new ArrayList<ChannelInterceptor>();

    public TaskExecutorRegistration taskExecutor() {
        return this.taskExecutor(null);
    }

    public TaskExecutorRegistration taskExecutor(@Nullable ThreadPoolTaskExecutor taskExecutor) {
        if (this.registration == null) {
            this.registration = taskExecutor != null ? new TaskExecutorRegistration(taskExecutor) : new TaskExecutorRegistration();
        }
        return this.registration;
    }

    public ChannelRegistration executor(TaskExecutor taskExecutor) {
        this.executor = taskExecutor;
        return this;
    }

    public ChannelRegistration interceptors(ChannelInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    protected boolean hasTaskExecutor() {
        return this.registration != null || this.executor != null;
    }

    protected boolean hasInterceptors() {
        return !this.interceptors.isEmpty();
    }

    protected TaskExecutor getTaskExecutor(Supplier<TaskExecutor> fallback, Consumer<TaskExecutor> customizer) {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.registration != null) {
            ThreadPoolTaskExecutor registeredTaskExecutor = this.registration.getTaskExecutor();
            customizer.accept((TaskExecutor)registeredTaskExecutor);
            return registeredTaskExecutor;
        }
        TaskExecutor taskExecutor = fallback.get();
        customizer.accept(taskExecutor);
        return taskExecutor;
    }

    protected List<ChannelInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

