/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.AfterConnectInternalListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyManager;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionBridge;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionMetrics;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.group.impl.Proposal;
import org.apache.activemq.artemis.core.server.group.impl.Response;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterConnectionImpl
implements ClusterConnection,
AfterConnectInternalListener,
TopologyManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SN_PREFIX = "sf.";
    private static final String TRANSPORT_CONFIG_NAME = "topology-member";
    private final ExecutorFactory executorFactory;
    private final Executor executor;
    private final ActiveMQServer server;
    private final PostOffice postOffice;
    private final ManagementService managementService;
    private final SimpleString name;
    private final SimpleString address;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final long retryInterval;
    private final long callTimeout;
    private final long callFailoverTimeout;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private final int initialConnectAttempts;
    private final int reconnectAttempts;
    private final boolean useDuplicateDetection;
    private final MessageLoadBalancingType messageLoadBalancingType;
    private final int confirmationWindowSize;
    private final int producerWindowSize;
    private final Object recordsGuard = new Object();
    private final Map<String, MessageFlowRecord> records = new ConcurrentHashMap<String, MessageFlowRecord>();
    private final ScheduledExecutorService scheduledExecutor;
    private final int maxHops;
    private final NodeManager nodeManager;
    private volatile boolean started;
    private final String clusterUser;
    private final String clusterPassword;
    private final ClusterConnector clusterConnector;
    private ServerLocatorInternal serverLocator;
    private final TransportConfiguration connector;
    private final boolean allowDirectConnectionsOnly;
    final Set<TransportConfiguration> allowableConnections = new HashSet<TransportConfiguration>();
    private final ClusterManager manager;
    private final int minLargeMessageSize;
    private final Topology topology;
    private volatile boolean stopping = false;
    private LiveNotifier liveNotifier = null;
    private final long clusterNotificationInterval;
    private final int clusterNotificationAttempts;
    private final String storeAndForwardPrefix;
    private boolean splitBrainDetection;

    public ServerLocatorInternal getServerLocator() {
        return this.serverLocator;
    }

    public ClusterConnectionImpl(ClusterManager manager, TransportConfiguration[] staticTranspConfigs, TransportConfiguration connector, SimpleString name, SimpleString address, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int initialConnectAttempts, int reconnectAttempts, long callTimeout, long callFailoverTimeout, boolean useDuplicateDetection, MessageLoadBalancingType messageLoadBalancingType, int confirmationWindowSize, int producerWindowSize, ExecutorFactory executorFactory, ActiveMQServer server, PostOffice postOffice, ManagementService managementService, ScheduledExecutorService scheduledExecutor, int maxHops, NodeManager nodeManager, String clusterUser, String clusterPassword, boolean allowDirectConnectionsOnly, long clusterNotificationInterval, int clusterNotificationAttempts) throws Exception {
        this.nodeManager = nodeManager;
        this.connector = connector;
        this.name = name;
        this.address = address;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.initialConnectAttempts = initialConnectAttempts;
        this.reconnectAttempts = reconnectAttempts;
        this.useDuplicateDetection = useDuplicateDetection;
        this.messageLoadBalancingType = messageLoadBalancingType;
        this.confirmationWindowSize = confirmationWindowSize;
        this.producerWindowSize = producerWindowSize;
        this.executorFactory = executorFactory;
        this.clusterNotificationInterval = clusterNotificationInterval;
        this.clusterNotificationAttempts = clusterNotificationAttempts;
        this.executor = executorFactory.getExecutor();
        this.topology = new Topology((Object)this, this.executor);
        this.server = server;
        this.postOffice = postOffice;
        this.managementService = managementService;
        this.scheduledExecutor = scheduledExecutor;
        this.maxHops = maxHops;
        this.clusterUser = clusterUser;
        this.clusterPassword = clusterPassword;
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
        this.manager = manager;
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        this.minLargeMessageSize = minLargeMessageSize;
        this.clusterConnector = new StaticClusterConnector(staticTranspConfigs);
        if (staticTranspConfigs != null && staticTranspConfigs.length > 0 && allowDirectConnectionsOnly) {
            for (TransportConfiguration configuration : staticTranspConfigs) {
                TransportConfiguration transportConfiguration = configuration.newTransportConfig(TRANSPORT_CONFIG_NAME);
                transportConfiguration.getParams().remove("localAddress");
                transportConfiguration.getParams().remove("localPort");
                this.allowableConnections.add(transportConfiguration);
            }
        }
        this.storeAndForwardPrefix = server.getInternalNamingPrefix() + SN_PREFIX;
    }

    public ClusterConnectionImpl(ClusterManager manager, DiscoveryGroupConfiguration dg, TransportConfiguration connector, SimpleString name, SimpleString address, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int initialConnectAttempts, int reconnectAttempts, long callTimeout, long callFailoverTimeout, boolean useDuplicateDetection, MessageLoadBalancingType messageLoadBalancingType, int confirmationWindowSize, int producerWindowSize, ExecutorFactory executorFactory, ActiveMQServer server, PostOffice postOffice, ManagementService managementService, ScheduledExecutorService scheduledExecutor, int maxHops, NodeManager nodeManager, String clusterUser, String clusterPassword, boolean allowDirectConnectionsOnly, long clusterNotificationInterval, int clusterNotificationAttempts) throws Exception {
        this.nodeManager = nodeManager;
        this.connector = connector;
        this.name = name;
        this.address = address;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.minLargeMessageSize = minLargeMessageSize;
        this.initialConnectAttempts = initialConnectAttempts;
        this.reconnectAttempts = reconnectAttempts;
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        this.useDuplicateDetection = useDuplicateDetection;
        this.messageLoadBalancingType = messageLoadBalancingType;
        this.confirmationWindowSize = confirmationWindowSize;
        this.producerWindowSize = producerWindowSize;
        this.executorFactory = executorFactory;
        this.clusterNotificationInterval = clusterNotificationInterval;
        this.clusterNotificationAttempts = clusterNotificationAttempts;
        this.executor = executorFactory.getExecutor();
        this.topology = new Topology((Object)this, this.executor);
        this.server = server;
        this.postOffice = postOffice;
        this.managementService = managementService;
        this.scheduledExecutor = scheduledExecutor;
        this.maxHops = maxHops;
        this.clusterUser = clusterUser;
        this.clusterPassword = clusterPassword;
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
        this.clusterConnector = new DiscoveryClusterConnector(dg);
        this.manager = manager;
        this.storeAndForwardPrefix = server.getInternalNamingPrefix() + SN_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            if (this.started) {
                return;
            }
            this.stopping = false;
            this.started = true;
            this.activate();
        }
    }

    @Override
    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        if (!future.await(10000L)) {
            ActiveMQServerLogger.LOGGER.couldNotFinishExecutor(this.toString());
            this.server.threadDump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.stopping = true;
        logger.debug("{}::stopping ClusterConnection", (Object)this);
        if (this.serverLocator != null) {
            this.serverLocator.removeClusterTopologyListener((ClusterTopologyListener)this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cluster connection being stopped for node{}, server = {} serverLocator = {}", new Object[]{this.nodeManager.getNodeId(), this.server, this.serverLocator});
        }
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            for (MessageFlowRecord record : this.records.values()) {
                try {
                    record.close();
                }
                catch (Exception exception) {}
            }
            this.records.clear();
        }
        if (this.managementService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            SimpleString nodeId = this.nodeManager.getNodeId();
            Notification notification = new Notification(nodeId == null ? null : nodeId.toString(), (NotificationType)CoreNotificationType.CLUSTER_CONNECTION_STOPPED, props);
            this.managementService.sendNotification(notification);
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClusterConnectionImpl clusterConnectionImpl = ClusterConnectionImpl.this;
                synchronized (clusterConnectionImpl) {
                    ClusterConnectionImpl.this.closeLocator(ClusterConnectionImpl.this.serverLocator);
                    ClusterConnectionImpl.this.serverLocator = null;
                }
            }
        });
        this.started = false;
    }

    private void closeLocator(ServerLocatorInternal locator) {
        if (locator != null) {
            locator.close();
        }
    }

    private TopologyMember getLocalMember() {
        return this.topology.getMember(this.manager.getNodeId());
    }

    @Override
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.addClusterTopologyListener(listener);
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.removeClusterTopologyListener(listener);
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void nodeAnnounced(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean backup) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}::NodeAnnounced, backup={}{}{}", new Object[]{this, backup, nodeID, connectorPair});
        }
        TransportConfiguration live = (TransportConfiguration)connectorPair.getA();
        TransportConfiguration backupTC = (TransportConfiguration)connectorPair.getB();
        TopologyMemberImpl newMember = new TopologyMemberImpl(nodeID, backupGroupName, scaleDownGroupName, live, backupTC);
        newMember.setUniqueEventID(uniqueEventID);
        if (backup) {
            this.topology.updateBackup(new TopologyMemberImpl(nodeID, backupGroupName, scaleDownGroupName, live, backupTC));
        } else {
            this.topology.updateMember(uniqueEventID, nodeID, newMember);
        }
    }

    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMemberImpl memberInput) {
        if (this.splitBrainDetection && nodeId.equals(this.nodeManager.getNodeId().toString())) {
            if (memberInput.getLive() != null) {
                if (!memberInput.getLive().isSameParams(this.connector)) {
                    ActiveMQServerLogger.LOGGER.possibleSplitBrain(nodeId, memberInput.toString());
                    return false;
                }
            } else {
                memberInput.setLive(this.connector);
            }
        }
        return true;
    }

    public boolean removeMember(long uniqueEventID, String nodeId) {
        if (nodeId.equals(this.nodeManager.getNodeId().toString())) {
            ActiveMQServerLogger.LOGGER.possibleSplitBrain(nodeId);
            return false;
        }
        return true;
    }

    @Override
    public void setSplitBrainDetection(boolean splitBrainDetection) {
        this.splitBrainDetection = splitBrainDetection;
    }

    @Override
    public boolean isSplitBrainDetection() {
        return this.splitBrainDetection;
    }

    public void onConnection(ClientSessionFactoryInternal sf) {
        TopologyMember localMember = this.getLocalMember();
        if (localMember != null) {
            ClusterControl clusterControl = this.manager.getClusterController().connectToNodeInCluster(sf);
            try {
                clusterControl.authorize();
                clusterControl.sendNodeAnnounce(localMember.getUniqueEventID(), this.manager.getNodeId(), this.manager.getBackupGroupName(), this.manager.getScaleDownGroupName(), false, localMember.getLive(), localMember.getBackup());
            }
            catch (ActiveMQException e) {
                ActiveMQServerLogger.LOGGER.clusterControlAuthfailure(e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
            }
        } else {
            ActiveMQServerLogger.LOGGER.noLocalMemborOnClusterConnection(this);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public String getNodeID() {
        return this.nodeManager == null ? null : (this.nodeManager.getNodeId() == null ? null : this.nodeManager.getNodeId().toString());
    }

    @Override
    public ActiveMQServer getServer() {
        return this.server;
    }

    @Override
    public boolean isNodeActive(String nodeId) {
        MessageFlowRecord rec = this.records.get(nodeId);
        if (rec == null) {
            return false;
        }
        return rec.getBridge().isConnected();
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bridge[] getBridges() {
        Object object = this.recordsGuard;
        synchronized (object) {
            return (Bridge[])this.records.values().stream().map(MessageFlowRecord::getBridge).toArray(Bridge[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getNodes() {
        Object object = this.recordsGuard;
        synchronized (object) {
            HashMap<String, String> nodes = new HashMap<String, String>();
            for (Map.Entry<String, MessageFlowRecord> entry : this.records.entrySet()) {
                RemotingConnection fwdConnection = entry.getValue().getBridge().getForwardingConnection();
                if (fwdConnection == null) continue;
                nodes.put(entry.getKey(), fwdConnection.getRemoteAddress());
            }
            return nodes;
        }
    }

    private synchronized void activate() throws Exception {
        if (!this.started) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Activating cluster connection nodeID={} for server={}", (Object)this.nodeManager.getNodeId(), (Object)this.server);
        }
        this.liveNotifier = new LiveNotifier();
        this.liveNotifier.updateAsLive();
        this.liveNotifier.schedule();
        this.serverLocator = this.clusterConnector.createServerLocator();
        if (this.serverLocator != null) {
            TopologyMemberImpl currentMember;
            if (!this.useDuplicateDetection) {
                logger.debug("DuplicateDetection is disabled, sending clustered messages blocked");
            }
            if ((currentMember = this.topology.getMember(this.manager.getNodeId())) == null) {
                throw new IllegalStateException("InternalError! The ClusterConnection doesn't know about its own node = " + this);
            }
            this.serverLocator.setNodeID(this.nodeManager.getNodeId().toString());
            this.serverLocator.setIdentity("(main-ClusterConnection::" + this.server.toString() + ")");
            this.serverLocator.setReconnectAttempts(0);
            this.serverLocator.setClusterConnection(true);
            this.serverLocator.setClusterTransportConfiguration(this.connector);
            this.serverLocator.setInitialConnectAttempts(-1);
            this.serverLocator.setClientFailureCheckPeriod(this.clientFailureCheckPeriod);
            this.serverLocator.setConnectionTTL(this.connectionTTL);
            this.serverLocator.setConfirmationWindowSize(this.confirmationWindowSize);
            this.serverLocator.setBlockOnDurableSend(!this.useDuplicateDetection);
            this.serverLocator.setBlockOnNonDurableSend(!this.useDuplicateDetection);
            this.serverLocator.setCallTimeout(this.callTimeout);
            this.serverLocator.setCallFailoverTimeout(this.callFailoverTimeout);
            this.serverLocator.setProducerWindowSize(this.producerWindowSize);
            if (this.retryInterval > 0L) {
                this.serverLocator.setRetryInterval(this.retryInterval);
            }
            this.serverLocator.setAfterConnectionInternalListener((AfterConnectInternalListener)this);
            this.serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.serverLocator, this.server.getStorageManager()));
            this.serverLocator.start((Executor)this.server.getExecutorFactory().getExecutor());
        }
        if (this.managementService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeManager.getNodeId().toString(), (NotificationType)CoreNotificationType.CLUSTER_CONNECTION_STARTED, props);
            logger.debug("sending notification: {}", (Object)notification);
            this.managementService.sendNotification(notification);
        }
        this.addClusterTopologyListener(this);
    }

    @Override
    public TransportConfiguration getConnector() {
        return this.connector;
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        if (this.stopping) {
            return;
        }
        String nodeID = topologyMember.getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug("{}receiving nodeUP for nodeID={} connectionPair={}", new Object[]{this, nodeID, topologyMember});
        }
        if (nodeID.equals(this.nodeManager.getNodeId().toString())) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::informing about backup to itself, nodeUUID={}, connectorPair={}, this = {}", new Object[]{this, this.nodeManager.getNodeId(), topologyMember, this});
            }
            return;
        }
        if (this.allowDirectConnectionsOnly && !this.allowableConnections.contains(topologyMember.getLive().newTransportConfig(TRANSPORT_CONFIG_NAME))) {
            return;
        }
        if (this.serverLocator == null) {
            return;
        }
        if (topologyMember.getLive() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} ignoring call with nodeID={}, topologyMember={}, last={}", new Object[]{this, nodeID, topologyMember, last});
            }
            return;
        }
        Object object = this.recordsGuard;
        synchronized (object) {
            try {
                MessageFlowRecord record = this.records.get(nodeID);
                if (record == null) {
                    SimpleString queueName;
                    Binding queueBinding;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}::Creating record for nodeID={}, topologyMember={}", new Object[]{this, nodeID, topologyMember});
                    }
                    Queue queue = (queueBinding = this.postOffice.getBinding(queueName = this.getSfQueueName(nodeID))) != null ? (Queue)queueBinding.getBindable() : this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.MULTICAST).setAutoCreateAddress(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setInternal(Boolean.valueOf(true)));
                    queue.setInternalQueue(true);
                    this.createNewRecord(topologyMember.getUniqueEventID(), nodeID, topologyMember.getLive(), queueName, queue, true);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("{} ignored nodeUp record for {} on nodeID={} as the record already existed", new Object[]{this, topologyMember, nodeID});
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorUpdatingTopology(e);
            }
        }
    }

    public SimpleString getSfQueueName(String nodeID) {
        return new SimpleString(this.storeAndForwardPrefix + this.name + "." + nodeID);
    }

    @Override
    public synchronized void informClusterOfBackup() {
        String nodeID = this.server.getNodeID().toString();
        TopologyMemberImpl localMember = new TopologyMemberImpl(nodeID, null, null, null, this.connector);
        this.topology.updateAsLive(nodeID, localMember);
    }

    @Override
    public ClusterConnectionMetrics getMetrics() {
        long messagesPendingAcknowledgement = 0L;
        long messagesAcknowledged = 0L;
        for (MessageFlowRecord record : this.records.values()) {
            BridgeMetrics metrics = record.getBridge() != null ? record.getBridge().getMetrics() : null;
            messagesPendingAcknowledgement += metrics != null ? metrics.getMessagesPendingAcknowledgement() : 0L;
            messagesAcknowledged += metrics != null ? metrics.getMessagesAcknowledged() : 0L;
        }
        return new ClusterConnectionMetrics(messagesPendingAcknowledgement, messagesAcknowledged);
    }

    @Override
    public BridgeMetrics getBridgeMetrics(String nodeId) {
        MessageFlowRecord record = this.records.get(nodeId);
        return record != null && record.getBridge() != null ? record.getBridge().getMetrics() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewRecord(long eventUID, String targetNodeID, TransportConfiguration connector, SimpleString queueName, Queue queue, boolean start) throws Exception {
        String nodeId;
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            if (!this.started) {
                return;
            }
            if (this.serverLocator == null) {
                return;
            }
            nodeId = this.serverLocator.getNodeID();
        }
        ServerLocatorImpl targetLocator = new ServerLocatorImpl(this.topology, true, new TransportConfiguration[]{connector});
        targetLocator.setReconnectAttempts(0);
        targetLocator.setInitialConnectAttempts(0);
        targetLocator.setClientFailureCheckPeriod(this.clientFailureCheckPeriod);
        targetLocator.setConnectionTTL(this.connectionTTL);
        targetLocator.setConfirmationWindowSize(this.confirmationWindowSize);
        targetLocator.setBlockOnDurableSend(!this.useDuplicateDetection);
        targetLocator.setBlockOnNonDurableSend(!this.useDuplicateDetection);
        targetLocator.setRetryInterval(this.retryInterval);
        targetLocator.setMaxRetryInterval(this.maxRetryInterval);
        targetLocator.setRetryIntervalMultiplier(this.retryIntervalMultiplier);
        targetLocator.setMinLargeMessageSize(this.minLargeMessageSize);
        targetLocator.setCallTimeout(this.serverLocator.getCallTimeout());
        targetLocator.setCallFailoverTimeout(this.serverLocator.getCallFailoverTimeout());
        targetLocator.setProducerWindowSize(this.producerWindowSize);
        targetLocator.setAfterConnectionInternalListener((AfterConnectInternalListener)this);
        this.serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.serverLocator, this.server.getStorageManager()));
        targetLocator.setNodeID(nodeId);
        targetLocator.setClusterTransportConfiguration(this.serverLocator.getClusterTransportConfiguration());
        if (this.retryInterval > 0L) {
            targetLocator.setRetryInterval(this.retryInterval);
        }
        targetLocator.addIncomingInterceptor((Interceptor)new ClusterManager.IncomingInterceptorLookingForExceptionMessage(this.manager, (Executor)this.executorFactory.getExecutor()));
        MessageFlowRecordImpl record = new MessageFlowRecordImpl((ServerLocatorInternal)targetLocator, eventUID, targetNodeID, connector, queueName, queue);
        ClusterConnectionBridge bridge = new ClusterConnectionBridge(this, this.manager, (ServerLocatorInternal)targetLocator, this.serverLocator, this.initialConnectAttempts, this.reconnectAttempts, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.nodeManager.getUUID(), record.getEventUID(), record.getTargetNodeID(), record.getQueueName(), record.getQueue(), (Executor)this.executorFactory.getExecutor(), null, null, this.scheduledExecutor, null, this.useDuplicateDetection, this.clusterUser, this.clusterPassword, this.server, this.managementService.getManagementAddress(), this.managementService.getManagementNotificationAddress(), record, record.getConnector(), this.storeAndForwardPrefix, this.server.getStorageManager());
        targetLocator.setIdentity("(Cluster-connection-bridge::" + bridge.toString() + "::" + this.toString() + ")");
        if (logger.isDebugEnabled()) {
            logger.debug("creating record between {} and {}{}", new Object[]{this.connector, connector, bridge});
        }
        record.setBridge(bridge);
        this.records.put(targetNodeID, record);
        if (start) {
            bridge.start();
        }
        if (!ConfigurationImpl.checkoutDupCacheSize(this.serverLocator.getConfirmationWindowSize(), this.server.getConfiguration().getIDCacheSize())) {
            ActiveMQServerLogger.LOGGER.duplicateCacheSizeWarning(this.server.getConfiguration().getIDCacheSize(), this.serverLocator.getConfirmationWindowSize());
        }
    }

    public Map<String, MessageFlowRecord> getRecords() {
        return this.records;
    }

    public String toString() {
        return "ClusterConnectionImpl@" + System.identityHashCode(this) + "[nodeUUID=" + this.nodeManager.getNodeId() + ", connector=" + this.connector + ", address=" + this.address + ", server=" + this.server + "]";
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(this);
        out.println("***************************************");
        out.println(this.name + " connected to");
        for (MessageFlowRecord messageFlow : this.records.values()) {
            out.println("\t Bridge = " + messageFlow.getBridge());
            out.println("\t Flow Record = " + messageFlow);
        }
        out.println("***************************************");
        return str.toString();
    }

    @Override
    public boolean verify(String clusterUser0, String clusterPassword0) {
        return this.clusterUser.equals(clusterUser0) && this.clusterPassword.equals(clusterPassword0);
    }

    @Override
    public void removeRecord(String targetNodeID) {
        logger.debug("Removing record for: {}", (Object)targetNodeID);
        MessageFlowRecord record = this.records.remove(targetNodeID);
        try {
            if (record != null) {
                record.close();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToRemoveRecord(e);
        }
    }

    @Override
    public void disconnectRecord(String targetNodeID) {
        logger.debug("Disconnecting record for: {}", (Object)targetNodeID);
        MessageFlowRecord record = this.records.get(targetNodeID);
        try {
            if (record != null) {
                record.disconnectBindings();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToDisconnectBindings(e);
        }
    }

    private final class LiveNotifier
    implements Runnable {
        int notificationsSent = 0;

        private LiveNotifier() {
        }

        @Override
        public void run() {
            this.resendLive();
            this.schedule();
        }

        public void schedule() {
            if (ClusterConnectionImpl.this.started && !ClusterConnectionImpl.this.stopping && this.notificationsSent++ < ClusterConnectionImpl.this.clusterNotificationAttempts) {
                ClusterConnectionImpl.this.scheduledExecutor.schedule(this, ClusterConnectionImpl.this.clusterNotificationInterval, TimeUnit.MILLISECONDS);
            }
        }

        public void updateAsLive() {
            if (!ClusterConnectionImpl.this.stopping && ClusterConnectionImpl.this.started) {
                ClusterConnectionImpl.this.topology.updateAsLive(ClusterConnectionImpl.this.manager.getNodeId(), new TopologyMemberImpl(ClusterConnectionImpl.this.manager.getNodeId(), ClusterConnectionImpl.this.manager.getBackupGroupName(), ClusterConnectionImpl.this.manager.getScaleDownGroupName(), ClusterConnectionImpl.this.connector, null));
            }
        }

        public void resendLive() {
            if (!ClusterConnectionImpl.this.stopping && ClusterConnectionImpl.this.started) {
                ClusterConnectionImpl.this.topology.resendNode(ClusterConnectionImpl.this.manager.getNodeId());
            }
        }
    }

    private final class DiscoveryClusterConnector
    implements ClusterConnector {
        private final DiscoveryGroupConfiguration dg;

        private DiscoveryClusterConnector(DiscoveryGroupConfiguration dg) {
            this.dg = dg;
        }

        @Override
        public ServerLocatorInternal createServerLocator() {
            return new ServerLocatorImpl(ClusterConnectionImpl.this.topology, true, this.dg);
        }
    }

    private final class StaticClusterConnector
    implements ClusterConnector {
        private final TransportConfiguration[] tcConfigs;

        private StaticClusterConnector(TransportConfiguration[] tcConfigs) {
            this.tcConfigs = tcConfigs;
        }

        @Override
        public ServerLocatorInternal createServerLocator() {
            if (this.tcConfigs != null && this.tcConfigs.length > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Creating a serverLocator for {}", (Object)ClusterConnectionImpl.this, (Object)Arrays.toString(this.tcConfigs));
                }
                ServerLocatorImpl locator = new ServerLocatorImpl(ClusterConnectionImpl.this.topology, true, this.tcConfigs);
                locator.setClusterConnection(true);
                locator.setClusterTransportConfiguration(ClusterConnectionImpl.this.connector);
                return locator;
            }
            return null;
        }

        public String toString() {
            return "StaticClusterConnector [tcConfigs=" + Arrays.toString(this.tcConfigs) + "]";
        }
    }

    private static interface ClusterConnector {
        public ServerLocatorInternal createServerLocator();
    }

    private class MessageFlowRecordImpl
    implements MessageFlowRecord {
        private BridgeImpl bridge;
        private final long eventUID;
        private final String targetNodeID;
        private final TransportConfiguration connector;
        private final ServerLocatorInternal targetLocator;
        private final SimpleString queueName;
        private boolean disconnected = false;
        private final Queue queue;
        private final Map<SimpleString, RemoteQueueBinding> bindings = new HashMap<SimpleString, RemoteQueueBinding>();
        private volatile boolean isClosed = false;
        private volatile boolean reset = false;

        private MessageFlowRecordImpl(ServerLocatorInternal targetLocator, long eventUID, String targetNodeID, TransportConfiguration connector, SimpleString queueName, Queue queue) {
            this.targetLocator = targetLocator;
            this.queue = queue;
            this.targetNodeID = targetNodeID;
            this.connector = connector;
            this.queueName = queueName;
            this.eventUID = eventUID;
        }

        public String toString() {
            return "MessageFlowRecordImpl [nodeID=" + this.targetNodeID + ", connector=" + this.connector + ", queueName=" + this.queueName + ", queue=" + this.queue + ", isClosed=" + this.isClosed + ", reset=" + this.reset + "]";
        }

        @Override
        public void serverDisconnected() {
            this.disconnected = true;
        }

        @Override
        public String getAddress() {
            return ClusterConnectionImpl.this.address != null ? ClusterConnectionImpl.this.address.toString() : "";
        }

        public long getEventUID() {
            return this.eventUID;
        }

        public String getTargetNodeID() {
            return this.targetNodeID;
        }

        public TransportConfiguration getConnector() {
            return this.connector;
        }

        public SimpleString getQueueName() {
            return this.queueName;
        }

        public Queue getQueue() {
            return this.queue;
        }

        @Override
        public int getMaxHops() {
            return ClusterConnectionImpl.this.maxHops;
        }

        @Override
        public void close() throws Exception {
            logger.trace("Stopping bridge {}", (Object)this.bridge);
            this.isClosed = true;
            this.clearBindings();
            if (this.disconnected) {
                this.bridge.disconnect();
            }
            this.bridge.stop();
            this.bridge.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (MessageFlowRecordImpl.this.disconnected) {
                            MessageFlowRecordImpl.this.targetLocator.cleanup();
                        } else {
                            MessageFlowRecordImpl.this.targetLocator.close();
                        }
                    }
                    catch (Exception ignored) {
                        logger.debug(ignored.getMessage(), (Throwable)ignored);
                    }
                }
            });
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public void reset() throws Exception {
            this.resetBindings();
        }

        public void setBridge(BridgeImpl bridge) {
            this.bridge = bridge;
        }

        @Override
        public Bridge getBridge() {
            return this.bridge;
        }

        public synchronized void onMessage(ClientMessage message) {
            logger.debug("ClusterCommunication::Flow record on {} Receiving message {}", (Object)ClusterConnectionImpl.this.clusterConnector, (Object)message);
            try {
                if (message.containsProperty(PostOfficeImpl.HDR_RESET_QUEUE_DATA)) {
                    this.reset = true;
                    return;
                }
                if (message.containsProperty(PostOfficeImpl.HDR_RESET_QUEUE_DATA_COMPLETE)) {
                    this.clearDisconnectedBindings();
                    return;
                }
                if (!this.reset) {
                    logger.debug("Notification being ignored since first reset wasn't received yet: {}", (Object)message);
                    return;
                }
                this.handleNotificationMessage(message);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorHandlingMessage(e);
            }
        }

        private void handleNotificationMessage(ClientMessage message) throws Exception {
            SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE);
            CoreNotificationType ntype = CoreNotificationType.valueOf((String)type.toString());
            switch (ntype) {
                case BINDING_ADDED: {
                    this.doBindingAdded(message);
                    break;
                }
                case BINDING_REMOVED: {
                    this.doBindingRemoved(message);
                    break;
                }
                case CONSUMER_CREATED: {
                    this.doConsumerCreated(message);
                    break;
                }
                case CONSUMER_CLOSED: {
                    this.doConsumerClosed(message);
                    break;
                }
                case PROPOSAL: {
                    this.doProposalReceived(message);
                    break;
                }
                case PROPOSAL_RESPONSE: {
                    this.doProposalResponseReceived(message);
                    break;
                }
                case UNPROPOSAL: {
                    this.doUnProposalReceived(message);
                    break;
                }
                case SESSION_CREATED: {
                    this.doSessionCreated(message);
                    break;
                }
                default: {
                    throw ActiveMQMessageBundle.BUNDLE.invalidType(ntype);
                }
            }
        }

        private synchronized void doProposalReceived(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID)) {
                throw new IllegalStateException("proposal type is null");
            }
            SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID);
            SimpleString val = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE);
            Integer hops = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            if (ClusterConnectionImpl.this.server.getGroupingHandler() == null) {
                throw new IllegalStateException("grouping handler is null");
            }
            Response response = ClusterConnectionImpl.this.server.getGroupingHandler().receive(new Proposal(type, val), hops + 1);
            if (response != null) {
                ClusterConnectionImpl.this.server.getGroupingHandler().sendProposalResponse(response, 0);
            }
        }

        private synchronized void doUnProposalReceived(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID)) {
                throw new IllegalStateException("proposal type is null");
            }
            SimpleString groupId = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE);
            Integer hops = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            if (ClusterConnectionImpl.this.server.getGroupingHandler() == null) {
                throw new IllegalStateException("grouping handler is null");
            }
            ClusterConnectionImpl.this.server.getGroupingHandler().remove(groupId, clusterName, hops + 1);
        }

        private synchronized void doProposalResponseReceived(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID)) {
                throw new IllegalStateException("proposal type is null");
            }
            SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID);
            SimpleString val = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE);
            SimpleString alt = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_ALT_VALUE);
            Integer hops = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            Response response = new Response(type, val, alt);
            if (ClusterConnectionImpl.this.server.getGroupingHandler() == null) {
                throw new IllegalStateException("grouping handler is null while sending response " + response);
            }
            ClusterConnectionImpl.this.server.getGroupingHandler().proposed(response);
            ClusterConnectionImpl.this.server.getGroupingHandler().sendProposalResponse(response, hops + 1);
        }

        private synchronized void clearBindings() throws Exception {
            logger.debug("{} clearing bindings", (Object)ClusterConnectionImpl.this);
            for (RemoteQueueBinding binding : new HashSet<RemoteQueueBinding>(this.bindings.values())) {
                this.removeBinding(binding.getClusterName());
            }
        }

        private synchronized void resetBindings() throws Exception {
            logger.debug("{} reset bindings", (Object)ClusterConnectionImpl.this);
            for (RemoteQueueBinding binding : new HashSet<RemoteQueueBinding>(this.bindings.values())) {
                this.resetBinding(binding.getClusterName());
            }
        }

        private synchronized void clearDisconnectedBindings() throws Exception {
            logger.debug("{} reset bindings", (Object)ClusterConnectionImpl.this);
            for (RemoteQueueBinding binding : new HashSet<RemoteQueueBinding>(this.bindings.values())) {
                if (binding.isConnected()) continue;
                this.removeBinding(binding.getClusterName());
            }
        }

        @Override
        public synchronized void disconnectBindings() throws Exception {
            logger.debug("{} disconnect bindings", (Object)ClusterConnectionImpl.this);
            this.reset = false;
            for (RemoteQueueBinding binding : new HashSet<RemoteQueueBinding>(this.bindings.values())) {
                this.disconnectBinding(binding.getClusterName());
            }
        }

        private synchronized void doBindingAdded(ClientMessage message) throws Exception {
            logger.trace("{} Adding binding {}", (Object)ClusterConnectionImpl.this, (Object)message);
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_ADDRESS)) {
                throw new IllegalStateException("queueAddress is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_ROUTING_NAME)) {
                throw new IllegalStateException("routingName is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_BINDING_ID)) {
                throw new IllegalStateException("queueID is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString queueAddress = message.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            SimpleString routingName = message.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            Long queueID = message.getLongProperty(ManagementHelper.HDR_BINDING_ID);
            RemoteQueueBinding existingBinding = (RemoteQueueBinding)ClusterConnectionImpl.this.postOffice.getBinding(clusterName);
            if (existingBinding != null) {
                if (queueID.equals(existingBinding.getRemoteQueueID())) {
                    if (!existingBinding.isConnected()) {
                        existingBinding.connect();
                        return;
                    }
                    ActiveMQServerLogger.LOGGER.remoteQueueAlreadyBoundOnClusterConnection(this, clusterName);
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing binding because qid changed {} old: {}", (Object)queueID, (Object)existingBinding.getRemoteQueueID());
                }
                this.removeBinding(clusterName);
            }
            RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(ClusterConnectionImpl.this.server.getStorageManager().generateID(), queueAddress, clusterName, routingName, queueID, filterString, this.queue, this.bridge.getName(), distance + 1, ClusterConnectionImpl.this.messageLoadBalancingType);
            logger.trace("Adding binding {} into {}", (Object)clusterName, (Object)ClusterConnectionImpl.this);
            this.bindings.put(clusterName, binding);
            try {
                ClusterConnectionImpl.this.postOffice.addBinding(binding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void doBindingRemoved(ClientMessage message) throws Exception {
            logger.trace("{} Removing binding {}", (Object)ClusterConnectionImpl.this, (Object)message);
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            this.removeBinding(clusterName);
        }

        private synchronized void removeBinding(SimpleString clusterName) throws Exception {
            RemoteQueueBinding binding = this.bindings.remove(clusterName);
            if (binding == null) {
                logger.warn("Cannot remove binding, because cannot find binding for queue {}", (Object)clusterName);
                return;
            }
            ClusterConnectionImpl.this.postOffice.removeBinding(binding.getUniqueName(), null, true);
        }

        private synchronized void resetBinding(SimpleString clusterName) throws Exception {
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue " + clusterName);
            }
            binding.reset();
        }

        private synchronized void disconnectBinding(SimpleString clusterName) throws Exception {
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue " + clusterName);
            }
            binding.disconnect();
        }

        private synchronized void doSessionCreated(ClientMessage message) throws Exception {
            logger.trace("{} session created {}", (Object)ClusterConnectionImpl.this, (Object)message);
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, message.getSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, message.getSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS));
            props.putSimpleStringProperty(ManagementHelper.HDR_CLIENT_ID, message.getSimpleStringProperty(ManagementHelper.HDR_CLIENT_ID));
            props.putSimpleStringProperty(ManagementHelper.HDR_PROTOCOL_NAME, message.getSimpleStringProperty(ManagementHelper.HDR_PROTOCOL_NAME));
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, message.getIntProperty(ManagementHelper.HDR_DISTANCE) + 1);
            ClusterConnectionImpl.this.managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.SESSION_CREATED, props));
        }

        private synchronized void doConsumerCreated(ClientMessage message) throws Exception {
            logger.trace("{} Consumer created {}", (Object)ClusterConnectionImpl.this, (Object)message);
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            message.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for " + clusterName + " on " + ClusterConnectionImpl.this);
            }
            binding.addConsumer(filterString);
            TypedProperties props = new TypedProperties();
            SimpleString addressName = message.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, CompositeAddress.isFullyQualified((SimpleString)addressName) ? addressName : binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, clusterName);
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CREATED, props);
            ClusterConnectionImpl.this.managementService.sendNotification(notification);
        }

        private synchronized void doConsumerClosed(ClientMessage message) throws Exception {
            logger.trace("{} Consumer closed {}", (Object)ClusterConnectionImpl.this, (Object)message);
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            message.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for " + clusterName);
            }
            binding.removeConsumer(filterString);
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, clusterName);
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CLOSED, props);
            ClusterConnectionImpl.this.managementService.sendNotification(notification);
        }
    }
}

