/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyDescriptorUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class<?> beanClass;
    @Nullable
    private final Method readMethod;
    @Nullable
    private final Method writeMethod;
    @Nullable
    private Set<Method> ambiguousWriteMethods;
    private volatile boolean ambiguousWriteMethodsLogged;
    @Nullable
    private MethodParameter writeMethodParameter;
    @Nullable
    private volatile ResolvableType writeMethodType;
    @Nullable
    private ResolvableType readMethodType;
    @Nullable
    private volatile TypeDescriptor typeDescriptor;
    @Nullable
    private Class<?> propertyType;
    @Nullable
    private final Class<?> propertyEditorClass;

    public GenericTypeAwarePropertyDescriptor(Class<?> beanClass, String propertyName, @Nullable Method readMethod, @Nullable Method writeMethod, @Nullable Class<?> propertyEditorClass) throws IntrospectionException {
        super(propertyName, null, null);
        Method candidate;
        Method writeMethodToUse;
        this.beanClass = beanClass;
        Method readMethodToUse = readMethod != null ? BridgeMethodResolver.findBridgedMethod((Method)readMethod) : null;
        Method method = writeMethodToUse = writeMethod != null ? BridgeMethodResolver.findBridgedMethod((Method)writeMethod) : null;
        if (writeMethodToUse == null && readMethodToUse != null && (candidate = ClassUtils.getMethodIfAvailable(this.beanClass, (String)("set" + StringUtils.capitalize((String)this.getName())), (Class[])null)) != null && candidate.getParameterCount() == 1) {
            writeMethodToUse = candidate;
        }
        this.readMethod = readMethodToUse;
        this.writeMethod = writeMethodToUse;
        if (this.writeMethod != null) {
            if (this.readMethod == null) {
                HashSet<Method> ambiguousCandidates = new HashSet<Method>();
                for (Method method2 : beanClass.getMethods()) {
                    if (!method2.getName().equals(writeMethodToUse.getName()) || method2.equals(writeMethodToUse) || method2.isBridge() || method2.getParameterCount() != writeMethodToUse.getParameterCount()) continue;
                    ambiguousCandidates.add(method2);
                }
                if (!ambiguousCandidates.isEmpty()) {
                    this.ambiguousWriteMethods = ambiguousCandidates;
                }
            }
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0).withContainingClass(this.beanClass);
        }
        if (this.readMethod != null) {
            this.readMethodType = ResolvableType.forMethodReturnType((Method)this.readMethod, this.beanClass);
            this.propertyType = this.readMethodType.resolve(this.readMethod.getReturnType());
        } else if (this.writeMethodParameter != null) {
            this.propertyType = this.writeMethodParameter.getParameterType();
        }
        this.propertyEditorClass = propertyEditorClass;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    @Nullable
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    @Nullable
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Method getWriteMethodForActualAccess() {
        Assert.state((this.writeMethod != null ? 1 : 0) != 0, (String)"No write method available");
        if (this.ambiguousWriteMethods != null && !this.ambiguousWriteMethodsLogged) {
            this.ambiguousWriteMethodsLogged = true;
            LogFactory.getLog(GenericTypeAwarePropertyDescriptor.class).debug((Object)("Non-unique JavaBean property '" + this.getName() + "' being accessed! Ambiguous write methods found next to actually used [" + this.writeMethod + "]: " + this.ambiguousWriteMethods));
        }
        return this.writeMethod;
    }

    @Nullable
    public Method getWriteMethodFallback(@Nullable Class<?> valueType) {
        if (this.ambiguousWriteMethods != null) {
            for (Method method : this.ambiguousWriteMethods) {
                Class<?> paramType = method.getParameterTypes()[0];
                if (!(valueType != null ? paramType.isAssignableFrom(valueType) : !paramType.isPrimitive())) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public Method getUniqueWriteMethodFallback() {
        if (this.ambiguousWriteMethods != null && this.ambiguousWriteMethods.size() == 1) {
            return this.ambiguousWriteMethods.iterator().next();
        }
        return null;
    }

    public boolean hasUniqueWriteMethod() {
        return this.writeMethod != null && this.ambiguousWriteMethods == null;
    }

    public MethodParameter getWriteMethodParameter() {
        Assert.state((this.writeMethodParameter != null ? 1 : 0) != 0, (String)"No write method available");
        return this.writeMethodParameter;
    }

    public ResolvableType getWriteMethodType() {
        ResolvableType writeMethodType = this.writeMethodType;
        if (writeMethodType == null) {
            this.writeMethodType = writeMethodType = ResolvableType.forMethodParameter((MethodParameter)this.getWriteMethodParameter());
        }
        return writeMethodType;
    }

    public ResolvableType getReadMethodType() {
        Assert.state((this.readMethodType != null ? 1 : 0) != 0, (String)"No read method available");
        return this.readMethodType;
    }

    public TypeDescriptor getTypeDescriptor() {
        TypeDescriptor typeDescriptor = this.typeDescriptor;
        if (typeDescriptor == null) {
            Property property = new Property(this.getBeanClass(), this.getReadMethod(), this.getWriteMethod(), this.getName());
            this.typeDescriptor = typeDescriptor = new TypeDescriptor(property);
        }
        return typeDescriptor;
    }

    @Override
    @Nullable
    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    @Nullable
    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof GenericTypeAwarePropertyDescriptor)) return false;
        GenericTypeAwarePropertyDescriptor that = (GenericTypeAwarePropertyDescriptor)other;
        if (!this.getBeanClass().equals(that.getBeanClass())) return false;
        if (!PropertyDescriptorUtils.equals(this, that)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getBeanClass(), this.getReadMethod(), this.getWriteMethod());
    }
}

