/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;

public class SqlAliasStemHelper {
    public static final SqlAliasStemHelper INSTANCE = new SqlAliasStemHelper();

    public String generateStemFromEntityName(String entityName) {
        String simpleName = this.toSimpleEntityName(entityName);
        return Character.toString(Character.toLowerCase(simpleName.charAt(0)));
    }

    private String toSimpleEntityName(String entityName) {
        String simpleName = StringHelper.unqualify(entityName);
        if (simpleName.contains("$")) {
            simpleName = simpleName.substring(simpleName.lastIndexOf(36) + 1);
        }
        if (StringHelper.isEmpty(simpleName)) {
            throw new AssertionFailure("Could not determine simple name as base for alias [" + entityName + "]");
        }
        return simpleName;
    }

    public String generateStemFromAttributeName(String attributeName) {
        return Character.toString(Character.toLowerCase(attributeName.charAt(0)));
    }
}

