/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.AwsParameterStoreRepositoryConfiguration;
import org.springframework.cloud.config.server.config.AwsS3RepositoryConfiguration;
import org.springframework.cloud.config.server.config.AwsSecretsManagerRepositoryConfiguration;
import org.springframework.cloud.config.server.config.CompositeRepositoryConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.CredhubConfiguration;
import org.springframework.cloud.config.server.config.CredhubRepositoryConfiguration;
import org.springframework.cloud.config.server.config.DefaultRepositoryConfiguration;
import org.springframework.cloud.config.server.config.GitRepositoryConfiguration;
import org.springframework.cloud.config.server.config.GoogleCloudSourceConfiguration;
import org.springframework.cloud.config.server.config.GoogleSecretManagerRepositoryConfiguration;
import org.springframework.cloud.config.server.config.JdbcRepositoryConfiguration;
import org.springframework.cloud.config.server.config.NativeRepositoryConfiguration;
import org.springframework.cloud.config.server.config.RedisRepositoryConfiguration;
import org.springframework.cloud.config.server.config.SpringVaultRepositoryConfiguration;
import org.springframework.cloud.config.server.config.SvnRepositoryConfiguration;
import org.springframework.cloud.config.server.config.VaultConfiguration;
import org.springframework.cloud.config.server.config.VaultRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.ConsulEnvironmentWatch;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentProperties;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.GoogleSecretManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.GoogleSecretManagerEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.HttpClient4BuilderCustomizer;
import org.springframework.cloud.config.server.environment.HttpClientConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.HttpClientVaultRestTemplateFactory;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepository;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.RedisEnvironmentProperties;
import org.springframework.cloud.config.server.environment.RedisEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SvnEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.vault.SpringVaultTemplateBuilder;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.cloud.config.server.support.GoogleCloudSourceSupport;
import org.springframework.cloud.config.server.support.TransportConfigCallbackFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.vault.core.VaultTemplate;
import org.tmatesoft.svn.core.SVNException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.ssm.SsmClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SvnKitEnvironmentProperties.class, CredhubEnvironmentProperties.class, JdbcEnvironmentProperties.class, NativeEnvironmentProperties.class, VaultEnvironmentProperties.class, RedisEnvironmentProperties.class, AwsS3EnvironmentProperties.class, AwsSecretsManagerEnvironmentProperties.class, AwsParameterStoreEnvironmentProperties.class, GoogleSecretManagerEnvironmentProperties.class})
@Import(value={CompositeRepositoryConfiguration.class, JdbcRepositoryConfiguration.class, VaultConfiguration.class, VaultRepositoryConfiguration.class, SpringVaultRepositoryConfiguration.class, CredhubConfiguration.class, CredhubRepositoryConfiguration.class, SvnRepositoryConfiguration.class, NativeRepositoryConfiguration.class, GitRepositoryConfiguration.class, RedisRepositoryConfiguration.class, GoogleCloudSourceConfiguration.class, AwsS3RepositoryConfiguration.class, AwsSecretsManagerRepositoryConfiguration.class, AwsParameterStoreRepositoryConfiguration.class, GoogleSecretManagerRepositoryConfiguration.class, DefaultRepositoryConfiguration.class})
public class EnvironmentRepositoryConfiguration {
    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public MultipleJGitEnvironmentProperties multipleJGitEnvironmentProperties() {
        return new MultipleJGitEnvironmentProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigTokenProvider.class})
    public ConfigTokenProvider defaultConfigTokenProvider(ObjectProvider<HttpServletRequest> httpRequest) {
        return new HttpRequestConfigTokenProvider(httpRequest);
    }

    @Configuration(proxyBeanMethods=false)
    static class NativeFactoryConfig {
        NativeFactoryConfig() {
        }

        @Bean
        public NativeEnvironmentRepositoryFactory nativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties properties, ObjectProvider<ObservationRegistry> observationRegistry) {
            return new NativeEnvironmentRepositoryFactory(environment, properties, (ObservationRegistry)observationRegistry.getIfAvailable(() -> ObservationRegistry.NOOP));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CredHubOperations.class})
    static class CredhubFactoryConfig {
        CredhubFactoryConfig() {
        }

        @Bean
        public CredhubEnvironmentRepositoryFactory credhubEnvironmentRepositoryFactory(Optional<CredHubOperations> credHubOperations) {
            return new CredhubEnvironmentRepositoryFactory(credHubOperations.orElse(null));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={StringRedisTemplate.class})
    static class RedisFactoryConfig {
        RedisFactoryConfig() {
        }

        @Bean
        @ConditionalOnBean(value={StringRedisTemplate.class})
        public RedisEnvironmentRepositoryFactory redisEnvironmentRepositoryFactory(StringRedisTemplate redis) {
            return new RedisEnvironmentRepositoryFactory(redis);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcTemplate.class})
    @ConditionalOnProperty(value={"spring.cloud.config.server.jdbc.enabled"}, matchIfMissing=true)
    static class JdbcFactoryConfig {
        JdbcFactoryConfig() {
        }

        @Bean
        @ConditionalOnBean(value={JdbcTemplate.class})
        public JdbcEnvironmentRepositoryFactory jdbcEnvironmentRepositoryFactory(JdbcTemplate jdbc, JdbcEnvironmentRepository.PropertiesResultSetExtractor propertiesResultSetExtractor) {
            return new JdbcEnvironmentRepositoryFactory(jdbc, propertiesResultSetExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(value={JdbcEnvironmentRepository.PropertiesResultSetExtractor.class})
        public JdbcEnvironmentRepository.PropertiesResultSetExtractor propertiesResultSetExtractor() {
            return new JdbcEnvironmentRepository.PropertiesResultSetExtractor();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={VaultTemplate.class})
    @Import(value={SpringVaultClientConfiguration.class})
    static class SpringVaultFactoryConfig {
        SpringVaultFactoryConfig() {
        }

        @Bean
        public SpringVaultTemplateBuilder springVaultTemplateBuilder(ConfigTokenProvider configTokenProvider, List<SpringVaultClientAuthenticationProvider> authProviders, ApplicationContext applicationContext) {
            return new SpringVaultTemplateBuilder(configTokenProvider, authProviders, applicationContext);
        }

        @Bean
        public SpringVaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, SpringVaultTemplateBuilder springVaultTemplateBuilder) {
            return new SpringVaultEnvironmentRepositoryFactory(request, watch, springVaultTemplateBuilder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.vault.core.VaultTemplate"})
    static class VaultHttpClientConfig {
        VaultHttpClientConfig() {
        }

        @Bean
        public VaultEnvironmentRepositoryFactory.VaultRestTemplateFactory vaultRestTemplateFactory() {
            return new HttpClientVaultRestTemplateFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecretManagerServiceClient.class})
    static class GoogleSecretManagerFactoryConfig {
        GoogleSecretManagerFactoryConfig() {
        }

        @Bean
        public GoogleSecretManagerEnvironmentRepositoryFactory googleSecretManagerEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request) {
            return new GoogleSecretManagerEnvironmentRepositoryFactory(request);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.vault.core.VaultTemplate"})
    static class VaultFactoryConfig {
        VaultFactoryConfig() {
        }

        @Bean
        public VaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, Optional<VaultEnvironmentRepositoryFactory.VaultRestTemplateFactory> vaultRestTemplateFactory, ConfigTokenProvider tokenProvider) {
            return new VaultEnvironmentRepositoryFactory(request, watch, vaultRestTemplateFactory, tokenProvider);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SVNException.class})
    static class SvnFactoryConfig {
        SvnFactoryConfig() {
        }

        @Bean
        public SvnEnvironmentRepositoryFactory svnEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, ObjectProvider<ObservationRegistry> observationRegistry) {
            return new SvnEnvironmentRepositoryFactory(environment, server, (ObservationRegistry)observationRegistry.getIfAvailable(() -> ObservationRegistry.NOOP));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SsmClient.class})
    static class AwsParameterStoreFactoryConfig {
        AwsParameterStoreFactoryConfig() {
        }

        @Bean(name={"awsparamstoreenvironmentrepositoryfactory"})
        public AwsParameterStoreEnvironmentRepositoryFactory awsParameterStoreEnvironmentRepositoryFactory(ConfigServerProperties server) {
            return new AwsParameterStoreEnvironmentRepositoryFactory(server);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecretsManagerClient.class})
    static class AwsSecretsManagerFactoryConfig {
        AwsSecretsManagerFactoryConfig() {
        }

        @Bean
        public AwsSecretsManagerEnvironmentRepositoryFactory awsSecretsManagerEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
            return new AwsSecretsManagerEnvironmentRepositoryFactory(configServerProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={S3Client.class})
    static class AwsS3FactoryConfig {
        AwsS3FactoryConfig() {
        }

        @Bean
        public AwsS3EnvironmentRepositoryFactory awsS3EnvironmentRepositoryFactory(ConfigServerProperties server) {
            return new AwsS3EnvironmentRepositoryFactory(server);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class, TransportConfigCallback.class})
    static class JGitHttpClientConfig {
        JGitHttpClientConfig() {
        }

        @Bean
        public ConfigurableHttpConnectionFactory httpClientConnectionFactory() {
            return new HttpClientConfigurableHttpConnectionFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={TransportConfigCallback.class})
    static class JGitFactoryConfig {
        JGitFactoryConfig() {
        }

        @Bean
        public MultipleJGitEnvironmentRepositoryFactory gitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<ConfigurableHttpConnectionFactory> jgitHttpConnectionFactory, Optional<TransportConfigCallback> customTransportConfigCallback, Optional<GoogleCloudSourceSupport> googleCloudSourceSupport, GitCredentialsProviderFactory gitCredentialsProviderFactory, List<HttpClient4BuilderCustomizer> customizers) {
            TransportConfigCallbackFactory transportConfigCallbackFactory = new TransportConfigCallbackFactory(customTransportConfigCallback.orElse(null), googleCloudSourceSupport.orElse(null));
            return new MultipleJGitEnvironmentRepositoryFactory(environment, server, jgitHttpConnectionFactory, transportConfigCallbackFactory, gitCredentialsProviderFactory, customizers);
        }

        @Bean
        @ConditionalOnMissingBean
        public GitCredentialsProviderFactory gitCredentialsProviderFactory() {
            return new GitCredentialsProviderFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={EnvironmentWatch.class})
    protected static class DefaultEnvironmentWatch {
        protected DefaultEnvironmentWatch() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new EnvironmentWatch.Default();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.config.server.consul.watch.enabled"})
    protected static class ConsulEnvironmentWatchConfiguration {
        protected ConsulEnvironmentWatchConfiguration() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new ConsulEnvironmentWatch();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AbstractHealthIndicator.class})
    @ConditionalOnProperty(value={"spring.cloud.config.server.health.enabled"}, matchIfMissing=true)
    protected static class ConfigServerActuatorConfiguration {
        protected ConfigServerActuatorConfiguration() {
        }

        @Bean
        public ConfigServerHealthIndicator configServerHealthIndicator(EnvironmentRepository repository) {
            return new ConfigServerHealthIndicator(repository);
        }
    }
}

