/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLOidDataType
extends BytesDataType {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLOidDataType.class);

    public PostgreSQLOidDataType() {
        super("OID", -5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        Statement statement = resultSet.getStatement();
        Connection connection = statement.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        try {
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            LargeObjectManager lobj = pgConnection.getLargeObjectAPI();
            long oid = resultSet.getLong(column);
            if (oid == 0L) {
                logger.debug("'oid' is zero, the data is NULL.");
                Object var10_9 = null;
                return var10_9;
            }
            LargeObject obj = lobj.open(oid, 262144);
            byte[] buf = new byte[obj.size()];
            obj.read(buf, 0, obj.size());
            obj.close();
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        Connection connection = statement.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        try {
            LargeObjectManager lobj = ((PGConnection)statement.getConnection()).getLargeObjectAPI();
            long oid = lobj.createLO(393216);
            LargeObject obj = lobj.open(oid, 131072);
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])super.typeCast(value));
            byte[] buf = new byte[2048];
            int s = 0;
            while ((s = bis.read(buf, 0, 2048)) > 0) {
                obj.write(buf, 0, s);
            }
            obj.close();
            statement.setLong(column, oid);
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }
}

