/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.scaladsl.marshalling.ContentTypeOverrider$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.model.DateTime$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.server.directives.DirectoryListing;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class DirectoryListing$
implements Serializable {
    public static final DirectoryListing$ MODULE$ = new DirectoryListing$();
    private static final String[] html = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(EnhancedString$.MODULE$.stripMarginWithNewline$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("<html>\n      |<head><title>Index of $</title></head>\n      |<body>\n      |<h1>Index of $</h1>\n      |<hr>\n      |<pre>\n      |$</pre>\n      |<hr>$\n      |<div style=\"width:100%;text-align:right;color:gray\">\n      |<small>rendered by <a href=\"https://pekko.apache.org\">Pekko Http</a> on $</small>\n      |</div>$\n      |</body>\n      |</html>\n      |"), "\n")), '$');

    private String[] html() {
        return html;
    }

    public Marshaller<DirectoryListing, RequestEntity> directoryMarshaller(boolean renderVanityFooter) {
        return Marshaller$.MODULE$.StringMarshaller().wrap((MediaType)MediaTypes$.MODULE$.text$divhtml(), (Function1 & Serializable)listing -> {
            Object object;
            DirectoryListing directoryListing = listing;
            if (directoryListing == null) {
                throw new MatchError((Object)directoryListing);
            }
            String path = directoryListing.path();
            boolean isRoot = directoryListing.isRoot();
            Seq<File> files = directoryListing.files();
            Tuple3 tuple3 = new Tuple3((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)isRoot), files);
            String path2 = (String)tuple3._1();
            boolean isRoot2 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            Seq files2 = (Seq)tuple3._3();
            Seq filesAndNames = (Seq)((SeqOps)files2.map((Function1 & Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), (Object)file.getName()))).sortBy((Function1 & Serializable)x$6 -> (String)x$6._2(), (Ordering)Ordering.String$.MODULE$);
            Seq deduped = (Seq)((IterableOps)filesAndNames.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                block2: {
                    block4: {
                        Tuple2 fan;
                        block3: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            fan = (Tuple2)tuple2._1();
                            int ix = tuple2._2$mcI$sp();
                            if (fan == null) break block2;
                            String name = (String)fan._2();
                            if (ix == 0) break block3;
                            Object object = ((Tuple2)filesAndNames.apply(ix - 1))._2();
                            String string = name;
                            if (!(object == null ? string != null : !object.equals(string))) break block4;
                        }
                        return new Some((Object)fan);
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)tuple2);
            });
            Tuple2 tuple2 = deduped.partition((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$7(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq directoryFilesAndNames = (Seq)tuple2._1();
            Seq fileFilesAndNames = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)directoryFilesAndNames, (Object)fileFilesAndNames);
            Seq directoryFilesAndNames2 = (Seq)tuple22._1();
            Seq fileFilesAndNames2 = (Seq)tuple22._2();
            int maxNameLen = package$.MODULE$.max(DirectoryListing$.maxNameLength$1(directoryFilesAndNames2) + 1, DirectoryListing$.maxNameLength$1(fileFilesAndNames2));
            StringBuilder sb = new StringBuilder();
            sb.append(MODULE$.html()[0]).append(path2).append(MODULE$.html()[1]).append(path2).append(MODULE$.html()[2]);
            if (!isRoot2) {
                int secondToLastSlash = path2.lastIndexOf(47, path2.lastIndexOf(47, path2.length() - 1) - 1);
                object = sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<a href=\"%s/\">../</a>\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{path2.substring(0, secondToLastSlash)})));
            } else {
                object = BoxedUnit.UNIT;
            }
            directoryFilesAndNames2.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$9(check$ifrefutable$1))).foreach((Function1 & Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return DirectoryListing$.renderDirectory$1(file, name, sb, path2, maxNameLen);
                }
                throw new MatchError((Object)tuple2);
            });
            fileFilesAndNames2.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$11(check$ifrefutable$2))).foreach((Function1 & Serializable)x$11 -> {
                Tuple2 tuple2 = x$11;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return DirectoryListing$.renderFile$1(file, name, sb, path2, maxNameLen);
                }
                throw new MatchError((Object)tuple2);
            });
            Object object2 = isRoot2 && files2.isEmpty() ? sb.append("(no files)\n") : BoxedUnit.UNIT;
            sb.append(MODULE$.html()[3]);
            Object object3 = renderVanityFooter ? sb.append(MODULE$.html()[4]).append(DateTime$.MODULE$.now().toIsoLikeDateTimeString()).append(MODULE$.html()[5]) : BoxedUnit.UNIT;
            return sb.append(MODULE$.html()[6]).toString();
        }, ContentTypeOverrider$.MODULE$.forEntity());
    }

    public DirectoryListing apply(String path, boolean isRoot, Seq<File> files) {
        return new DirectoryListing(path, isRoot, files);
    }

    public Option<Tuple3<String, Object, Seq<File>>> unapply(DirectoryListing x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.path(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isRoot()), x$0.files()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DirectoryListing$.class);
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$7(Tuple2 x$7) {
        return ((File)x$7._1()).isDirectory();
    }

    public static final /* synthetic */ int $anonfun$directoryMarshaller$8(Tuple2 x$9) {
        return ((String)x$9._2()).length();
    }

    private static final int maxNameLength$1(Seq seq) {
        if (seq.isEmpty()) {
            return 0;
        }
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)DirectoryListing$.$anonfun$directoryMarshaller$8(x$9)))).max((Ordering)Ordering.Int$.MODULE$));
    }

    private static final String lastModified$2(File file) {
        return DateTime$.MODULE$.apply(file.lastModified()).toIsoLikeDateTimeString();
    }

    private static final StringBuilder start$1(String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        return sb$1.append("<a href=\"").append(new StringBuilder(0).append(path$3).append(name).toString()).append("\">").append(name).append("</a>").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxNameLen$1 - name.length()));
    }

    private static final StringBuilder renderDirectory$1(File file, String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        return DirectoryListing$.start$1(new StringBuilder(11).append(name).append('/').toString(), sb$1, path$3, maxNameLen$1).append("        ").append(DirectoryListing$.lastModified$2(file)).append('\n');
    }

    private static final StringBuilder renderFile$1(File file, String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        String size = org.apache.pekko.http.impl.util.package$.MODULE$.humanReadableByteCount(file.length(), true);
        DirectoryListing$.start$1(name, sb$1, path$3, maxNameLen$1).append("        ").append(DirectoryListing$.lastModified$2(file));
        return sb$1.append("                ".substring(size.length())).append(size).append('\n');
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$11(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private DirectoryListing$() {
    }
}

