/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.net.URI;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

class UpgradeRequestDelegate
implements UpgradeRequest {
    private final ServerUpgradeRequest request;

    UpgradeRequestDelegate(ServerUpgradeRequest request) {
        this.request = request;
    }

    public List<java.net.HttpCookie> getCookies() {
        return Request.getCookies((Request)this.request).stream().map(HttpCookie::asJavaNetHttpCookie).toList();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.request.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.request.getHeaders().get(name);
    }

    public int getHeaderInt(String name) {
        return (int)this.request.getHeaders().getLongField(name);
    }

    public Map<String, List<String>> getHeaders() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        HttpFields headers = this.request.getHeaders();
        for (HttpField header : headers) {
            String name = header.getName();
            result.put(name, headers.getValuesList(name));
        }
        return result;
    }

    public List<String> getHeaders(String name) {
        return this.request.getHeaders().getValuesList(name);
    }

    public String getHost() {
        return this.request.getHttpURI().getHost();
    }

    public String getHttpVersion() {
        return this.request.getConnectionMetaData().getHttpVersion().asString();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getOrigin() {
        return this.request.getHeaders().get(HttpHeader.ORIGIN);
    }

    public Map<String, List<String>> getParameterMap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        Fields fields = Request.extractQueryParameters((Request)this.request);
        for (Fields.Field field : fields) {
            result.put(field.getName(), field.getValues());
        }
        return result;
    }

    public String getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public String getQueryString() {
        return this.request.getHttpURI().getQuery();
    }

    public URI getRequestURI() {
        HttpURI httpURI = this.request.getHttpURI();
        HttpURI.Mutable wsURI = HttpURI.build((HttpURI)httpURI);
        wsURI.scheme(HttpScheme.isSecure((String)httpURI.getScheme()) ? HttpScheme.WSS : HttpScheme.WS);
        return wsURI.toURI();
    }

    public List<String> getSubProtocols() {
        return this.request.getSubProtocols();
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean hasSubProtocol(String subProtocol) {
        return this.request.hasSubProtocol(subProtocol);
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }
}

