/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.plus.webapp;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.ee10.plus.jndi.Transaction;
import org.eclipse.jetty.ee10.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee10.plus.webapp.PlusDecorator;
import org.eclipse.jetty.ee10.plus.webapp.PlusDescriptorProcessor;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.DescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.NanoTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(PlusConfiguration.class);
    private static final String LOCK_JNDI_KEY = "org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration.jndiKey";

    public PlusConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(new Class[]{EnvConfiguration.class, WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class}).addDependents(new Class[]{JettyWebXmlConfiguration.class}));
    }

    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator((Decorator)new PlusDecorator(context));
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        context.setAttribute("org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindTransactionToENC((String)ServletContextHandler.__environment.getName());
        }
        catch (NameNotFoundException e) {
            try {
                org.eclipse.jetty.plus.jndi.Transaction.bindTransactionToENC((String)ServletContextHandler.__environment.getName());
            }
            catch (NameNotFoundException x) {
                LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Integer key = (int)((long)((Object)((Object)this)).hashCode() ^ NanoTime.now());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            wac.setAttribute(LOCK_JNDI_KEY, (Object)key);
            compCtx.addToEnvironment("org.eclipse.jetty.jndi.lock", key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        Object o = wac.removeAttribute(LOCK_JNDI_KEY);
        if (o instanceof Integer) {
            Integer key = (Integer)o;
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.eclipse.jetty.jndi.unlock", key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

