/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import javax.persistence.EntityManager;
import org.hibernate.SessionFactory;
import org.hibernate.TypeHelper;
import org.hibernate.jpa.TypedParameterValue;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.lang.Nullable;

class HibernateJpaParametersParameterAccessor
extends JpaParametersParameterAccessor {
    private final TypeHelper typeHelper;

    HibernateJpaParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values, EntityManager em) {
        super(parameters, values);
        this.typeHelper = ((SessionFactory)em.getEntityManagerFactory().unwrap(SessionFactory.class)).getTypeHelper();
    }

    public Object getValue(Parameter parameter) {
        Object value = super.getValue(parameter.getIndex());
        if (value != null) {
            return value;
        }
        BasicType type = this.typeHelper.basic(parameter.getType());
        if (type == null) {
            return null;
        }
        return new TypedParameterValue((Type)type, null);
    }

    @Override
    @Nullable
    public Object potentiallyUnwrap(Object extractedValue) {
        if (extractedValue instanceof TypedParameterValue) {
            return ((TypedParameterValue)extractedValue).getValue();
        }
        return extractedValue;
    }
}

