/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index;

import com.xebialabs.deployit.plugin.stitch.dao.ContentRepository;
import com.xebialabs.deployit.plugin.stitch.dao.MacroParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.NamespaceRepository;
import com.xebialabs.deployit.plugin.stitch.dao.RuleConditionRepository;
import com.xebialabs.deployit.plugin.stitch.dao.StitchDefinitionRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.MacroRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.RuleRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.parameters.MacroProcessorParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.parameters.RuleProcessorParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.MacroProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.RuleProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.model.Namespace;
import com.xebialabs.deployit.plugin.stitch.model.StitchDefinition;
import com.xebialabs.deployit.plugin.stitch.model.processor.MacroProcessor;
import com.xebialabs.deployit.plugin.stitch.model.specification.Macro;
import com.xebialabs.deployit.plugin.stitch.service.CacheService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.IndexCleaner;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u000e\u001d\u00015B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!I\bA!A!\u0002\u0013Q\b\"B?\u0001\t\u0003q\bbCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037A1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00020!Y\u00111\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000f\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a;\u0001\t\u0003\ni\u000fC\u0004\u0002t\u0002!\t%!>\u0003'\u0011+g-Y;mi&sG-\u001a=DY\u0016\fg.\u001a:\u000b\u0005uq\u0012!B5oI\u0016D(BA\u0010!\u0003\u0019)gnZ5oK*\u0011\u0011EI\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019C%\u0001\u0004ti&$8\r\u001b\u0006\u0003K\u0019\na\u0001\u001d7vO&t'BA\u0014)\u0003!!W\r\u001d7ps&$(BA\u0015+\u0003%AXMY5bY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0006\u000e\u001d\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001\u001d\u0013\t9DD\u0001\u0007J]\u0012,\u0007p\u00117fC:,'\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)1\u000f\u001c45U*\tQ(\u0001\u0005he&T(\u0010\\3e\u0013\ty$HA\u0004M_\u001e<\u0017N\\4\u00025M$\u0018\u000e^2i\t\u00164\u0017N\\5uS>t'+\u001a9pg&$xN]=\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u0013\u0013a\u00013b_&\u0011ai\u0011\u0002\u001b'RLGo\u00195EK\u001aLg.\u001b;j_:\u0014V\r]8tSR|'/_\u0001\u000feVdWMU3q_NLGo\u001c:z!\tIE*D\u0001K\u0015\tY5)A\u0002ka\u0006L!!\u0014&\u0003\u001dI+H.\u001a*fa>\u001c\u0018\u000e^8ss\u00069\"/\u001e7f\u0007>tG-\u001b;j_:\u0014V\r]8tSR|'/\u001f\t\u0003\u0005BK!!U\"\u0003/I+H.Z\"p]\u0012LG/[8o%\u0016\u0004xn]5u_JL\u0018aD7bGJ|'+\u001a9pg&$xN]=\u0011\u0005%#\u0016BA+K\u0005=i\u0015m\u0019:p%\u0016\u0004xn]5u_JL\u0018\u0001G7bGJ|\u0007+\u0019:b[\u0016$XM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011!\tW\u0005\u00033\u000e\u0013\u0001$T1de>\u0004\u0016M]1nKR,'OU3q_NLGo\u001c:z\u0003]\u0011X\u000f\\3Qe>\u001cWm]:peJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002]?6\tQL\u0003\u0002_\u0015\u0006I\u0001O]8dKN\u001cxN]\u0005\u0003Av\u0013qCU;mKB\u0013xnY3tg>\u0014(+\u001a9pg&$xN]=\u0002AI,H.\u001a)s_\u000e,7o]8s!\u0006\u0014\u0018-\\3uKJ\u0014V\r]8tSR|'/\u001f\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K*\u000b!\u0002]1sC6,G/\u001a:t\u0013\t9GM\u0001\u0011Sk2,\u0007K]8dKN\u001cxN\u001d)be\u0006lW\r^3s%\u0016\u0004xn]5u_JL\u0018\u0001G7bGJ|\u0007K]8dKN\u001cxN\u001d*fa>\u001c\u0018\u000e^8ssB\u0011AL[\u0005\u0003Wv\u0013\u0001$T1de>\u0004&o\\2fgN|'OU3q_NLGo\u001c:z\u0003\u0005j\u0017m\u0019:p!J|7-Z:t_J\u0004\u0016M]1nKR,'OU3q_NLGo\u001c:z!\t\u0019g.\u0003\u0002pI\n\tS*Y2s_B\u0013xnY3tg>\u0014\b+\u0019:b[\u0016$XM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\tR.Y2s_\u000e\u000b7\r[3TKJ4\u0018nY3\u0011\u0005I\u001cX\"\u0001\u0011\n\u0005Q\u0004#\u0001D\"bG\",7+\u001a:wS\u000e,\u0017a\u00058b[\u0016\u001c\b/Y2f%\u0016\u0004xn]5u_JL\bC\u0001\"x\u0013\tA8IA\nOC6,7\u000f]1dKJ+\u0007o\\:ji>\u0014\u00180A\td_:$XM\u001c;SKB|7/\u001b;pef\u0004\"AQ>\n\u0005q\u001c%!E\"p]R,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"\u0012d`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018A\u0011Q\u0007\u0001\u0005\u0006\u00016\u0001\r!\u0011\u0005\u0006\u000f6\u0001\r\u0001\u0013\u0005\u0006\u001d6\u0001\ra\u0014\u0005\u0006%6\u0001\ra\u0015\u0005\u0006-6\u0001\ra\u0016\u0005\u000656\u0001\ra\u0017\u0005\u0006C6\u0001\rA\u0019\u0005\u0006Q6\u0001\r!\u001b\u0005\u0006Y6\u0001\r!\u001c\u0005\u0006a6\u0001\r!\u001d\u0005\u0006k6\u0001\rA\u001e\u0005\u0006s6\u0001\rA_\u0001\u000eK:$\u0018\u000e^=NC:\fw-\u001a:\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0002(\u0005)!.\u0019<bq&!\u00111FA\u0011\u00055)e\u000e^5us6\u000bg.Y4fe\u0006\tRM\u001c;jifl\u0015M\\1hKJ|F%Z9\u0015\t\u0005E\u0012q\u0007\t\u0004_\u0005M\u0012bAA\u001ba\t!QK\\5u\u0011%\tIdDA\u0001\u0002\u0004\ti\"A\u0002yIE\na\"\u001a8uSRLX*\u00198bO\u0016\u0014\b\u0005K\u0002\u0011\u0003\u007f\u0001B!a\b\u0002B%!\u00111IA\u0011\u0005I\u0001VM]:jgR,gnY3D_:$X\r\u001f;\u0002'\u0011,G.\u001a;f'RLGo\u00195D_:$XM\u001c;\u0015\r\u0005E\u0012\u0011JA*\u0011\u001d\tY%\u0005a\u0001\u0003\u001b\n\u0001b]8ve\u000e,\u0017\n\u001a\t\u0004_\u0005=\u0013bAA)a\t\u0019\u0011J\u001c;\t\u000f\u0005U\u0013\u00031\u0001\u0002X\u0005Q!M]1oG\"t\u0015-\\3\u0011\t\u0005e\u0013q\r\b\u0005\u00037\n\u0019\u0007E\u0002\u0002^Aj!!a\u0018\u000b\u0007\u0005\u0005D&\u0001\u0004=e>|GOP\u0005\u0004\u0003K\u0002\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002fA\na\u0003Z3mKR,7\u000b^5uG\"$UMZ5oSRLwN\u001c\u000b\u0007\u0003c\t\t(a\u001d\t\u000f\u0005-#\u00031\u0001\u0002N!9\u0011Q\u000b\nA\u0002\u0005]\u0013a\u00033fY\u0016$XMU;mKN$b!!\r\u0002z\u0005m\u0004bBA&'\u0001\u0007\u0011Q\n\u0005\b\u0003+\u001a\u0002\u0019AA,\u00031!W\r\\3uK6\u000b7M]8t)\u0019\t\t$!!\u0002\u0004\"9\u00111\n\u000bA\u0002\u00055\u0003bBA+)\u0001\u0007\u0011qK\u0001\u0011I\u0016dW\r^3Qe>\u001cWm]:peN$b!!\r\u0002\n\u0006-\u0005bBA&+\u0001\u0007\u0011Q\n\u0005\b\u0003+*\u0002\u0019AA,\u0003=\u0019G.Z1o\u001d\u0006lWm\u001d9bG\u0016\u001cH\u0003BA\u0019\u0003#Cq!a%\u0017\u0001\u0004\t)*\u0001\u0006oC6,7\u000f]1dKN\u0004b!!\u0017\u0002\u0018\u0006m\u0015\u0002BAM\u0003W\u00121aU3u!\u0011\ti*a)\u000e\u0005\u0005}%bAAQE\u0005)Qn\u001c3fY&!\u0011QUAP\u0005%q\u0015-\\3ta\u0006\u001cW-\u0001\u0006dY\u0016\fgnQ1dQ\u0016$b!!\r\u0002,\u00065\u0007bBAW/\u0001\u0007\u0011qV\u0001\u0007[\u0006\u001c'o\\:\u0011\r\u0005E\u00161XAa\u001d\u0011\t\u0019,a.\u000f\t\u0005u\u0013QW\u0005\u0002c%\u0019\u0011\u0011\u0018\u0019\u0002\u000fA\f7m[1hK&!\u0011QXA`\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005e\u0006\u0007\u0005\u0003\u0002D\u0006%WBAAc\u0015\u0011\t9-a(\u0002\u001bM\u0004XmY5gS\u000e\fG/[8o\u0013\u0011\tY-!2\u0003\u000b5\u000b7M]8\t\u000f\u0005=w\u00031\u0001\u0002R\u0006yQ.Y2s_B\u0013xnY3tg>\u00148\u000f\u0005\u0004\u00022\u0006m\u00161\u001b\t\u0005\u0003+\fI.\u0004\u0002\u0002X*\u0019a,a(\n\t\u0005m\u0017q\u001b\u0002\u000f\u001b\u0006\u001c'o\u001c)s_\u000e,7o]8s\u0003\u0015\u0019G.Z1o)\u0019\t\t$!9\u0002d\"9\u00111\n\rA\u0002\u00055\u0003bBA+1\u0001\u0007\u0011Q\u001d\t\u0006_\u0005\u001d\u0018qK\u0005\u0004\u0003S\u0004$AB(qi&|g.\u0001\bdY\u0016\fgNR8s'>,(oY3\u0015\r\u0005E\u0012q^Ay\u0011\u001d\tY%\u0007a\u0001\u0003\u001bBq!!\u0016\u001a\u0001\u0004\t)/A\bsK6|g/\u001a$peN{WO]2f)\u0011\t\t$a>\t\u000f\u0005-#\u00041\u0001\u0002N!\u001a\u0001!a?\u0011\t\u0005u(1C\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\t\u0015!qA\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0011IAa\u0003\u0002\u000b\t,\u0017M\\:\u000b\t\t5!qB\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011!\u0011C\u0001\u0004_J<\u0017\u0002\u0002B\u000b\u0003\u007f\u0014\u0011\"Q;u_^L'/\u001a3)\u0007\u0001\u0011I\u0002\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\u0011\u0011yBa\u0003\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003$\tu!aB*feZL7-\u001a")
public class DefaultIndexCleaner
implements IndexCleaner,
Logging {
    private final StitchDefinitionRepository stitchDefinitionRepository;
    private final RuleRepository ruleRepository;
    private final RuleConditionRepository ruleConditionRepository;
    private final MacroRepository macroRepository;
    private final MacroParameterRepository macroParameterRepository;
    private final RuleProcessorRepository ruleProcessorRepository;
    private final RuleProcessorParameterRepository ruleProcessorParameterRepository;
    private final MacroProcessorRepository macroProcessorRepository;
    private final MacroProcessorParameterRepository macroProcessorParameterRepository;
    private final CacheService macroCacheService;
    private final NamespaceRepository namespaceRepository;
    private final ContentRepository contentRepository;
    @PersistenceContext
    private EntityManager entityManager;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultIndexCleaner defaultIndexCleaner = this;
        synchronized (defaultIndexCleaner) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public EntityManager entityManager() {
        return this.entityManager;
    }

    public void entityManager_$eq(EntityManager x$1) {
        this.entityManager = x$1;
    }

    private void deleteStitchContent(int sourceId, String branchName) {
        this.contentRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteStitchDefinition(int sourceId, String branchName) {
        this.stitchDefinitionRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteRules(int sourceId, String branchName) {
        this.ruleConditionRepository.deleteByRule_BranchNameAndSourceId(branchName, sourceId);
        this.ruleRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteMacros(int sourceId, String branchName) {
        this.macroParameterRepository.deleteByMacro_BranchNameAndSourceId(branchName, sourceId);
        this.macroRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteProcessors(int sourceId, String branchName) {
        this.ruleProcessorParameterRepository.deleteByProcessor_Rule_BranchNameAndSourceId(branchName, sourceId);
        this.ruleProcessorRepository.deleteByRule_BranchNameAndSourceId(branchName, sourceId);
        this.macroProcessorParameterRepository.deleteByProcessor_Macro_BranchNameAndSourceId(branchName, sourceId);
        this.macroProcessorRepository.deleteByMacro_BranchNameAndSourceId(branchName, sourceId);
    }

    private void cleanNamespaces(Set<Namespace> namespaces) {
        ((IterableOnceOps)namespaces.filterNot((Function1 & Serializable)namespace -> BoxesRunTime.boxToBoolean((boolean)this.stitchDefinitionRepository.existsByNamespace(namespace)))).foreach((Function1 & Serializable)namespace -> {
            this.namespaceRepository.remove(namespace);
            return BoxedUnit.UNIT;
        });
    }

    public void cleanCache(List<Macro> macros, List<MacroProcessor> macroProcessors) {
        macros.foreach((Function1 & Serializable)m -> {
            this.macroCacheService.removeMacro((Tuple2<String, String>)new Tuple2((Object)m.namespace().name(), (Object)m.name()));
            return BoxedUnit.UNIT;
        });
        macroProcessors.foreach((Function1 & Serializable)p -> {
            this.macroCacheService.removeMacroProcessors(p.id());
            return BoxedUnit.UNIT;
        });
    }

    private void clean(int sourceId, Option<String> branchName) {
        List affectedMacros = CollectionConverters$.MODULE$.ListHasAsScala(this.macroRepository.findAllBySourceIdAndBranchName(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))).asScala().toList();
        List<StitchDefinition> definitions = this.stitchDefinitionRepository.getBySourceIdAndBranchName(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Set affectedNamespaces = definitions.map((Function1 & Serializable)x$2 -> x$2.namespace()).toSet();
        List affectedMacroProcessors = CollectionConverters$.MODULE$.ListHasAsScala(this.macroProcessorRepository.findByMacro_BranchNameAndSourceId((String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), sourceId)).asScala().toList();
        this.deleteProcessors(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteRules(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteMacros(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteStitchDefinition(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteStitchContent(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.cleanNamespaces((Set<Namespace>)affectedNamespaces);
        this.cleanCache((List<Macro>)affectedMacros, (List<MacroProcessor>)affectedMacroProcessors);
    }

    @Override
    public void cleanForSource(int sourceId, Option<String> branchName) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Trying to clean data for source: " + sourceId);
        this.clean(sourceId, branchName);
        this.entityManager().flush();
    }

    @Override
    public void removeForSource(int sourceId) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Trying to clean data for source: " + sourceId);
        this.stitchDefinitionRepository.getDistinctBranchNamesForSourceId(sourceId).foreach((Function1 & Serializable)branchName -> {
            this.clean(sourceId, (Option<String>)Option$.MODULE$.apply((Object)branchName));
            return BoxedUnit.UNIT;
        });
        this.entityManager().flush();
    }

    public DefaultIndexCleaner(StitchDefinitionRepository stitchDefinitionRepository, RuleRepository ruleRepository, RuleConditionRepository ruleConditionRepository, MacroRepository macroRepository, MacroParameterRepository macroParameterRepository, RuleProcessorRepository ruleProcessorRepository, RuleProcessorParameterRepository ruleProcessorParameterRepository, MacroProcessorRepository macroProcessorRepository, MacroProcessorParameterRepository macroProcessorParameterRepository, CacheService macroCacheService, NamespaceRepository namespaceRepository, ContentRepository contentRepository) {
        this.stitchDefinitionRepository = stitchDefinitionRepository;
        this.ruleRepository = ruleRepository;
        this.ruleConditionRepository = ruleConditionRepository;
        this.macroRepository = macroRepository;
        this.macroParameterRepository = macroParameterRepository;
        this.ruleProcessorRepository = ruleProcessorRepository;
        this.ruleProcessorParameterRepository = ruleProcessorParameterRepository;
        this.macroProcessorRepository = macroProcessorRepository;
        this.macroProcessorParameterRepository = macroProcessorParameterRepository;
        this.macroCacheService = macroCacheService;
        this.namespaceRepository = namespaceRepository;
        this.contentRepository = contentRepository;
        Logging.$init$((Logging)this);
    }
}

