/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mckoi;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MckoiDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(MckoiDataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("Mckoi");

    @Override
    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    @Override
    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        DataType retValue = super.createDataType(sqlType, sqlTypeName);
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        retValue = sqlTypeName.equals("BOOLEAN") ? DataType.BOOLEAN : retValue;
        retValue = sqlTypeName.equals("CHAR") ? DataType.CHAR : retValue;
        retValue = sqlTypeName.equals("CHARACTER") ? DataType.CHAR : retValue;
        retValue = sqlTypeName.equals("VARCHAR") ? DataType.VARCHAR : retValue;
        retValue = sqlTypeName.equals("LONGVARCHAR") ? DataType.LONGVARCHAR : retValue;
        retValue = sqlTypeName.equals("CHARACTER VARYING") ? DataType.VARCHAR : retValue;
        retValue = sqlTypeName.equals("LONG CHARACTER VARYING") ? DataType.VARCHAR : retValue;
        retValue = sqlTypeName.equals("TEXT") ? DataType.VARCHAR : retValue;
        retValue = sqlTypeName.equals("STRING") ? DataType.VARCHAR : retValue;
        retValue = sqlTypeName.equals("CLOB") ? DataType.CLOB : retValue;
        retValue = sqlTypeName.equals("TINYINT") ? DataType.TINYINT : retValue;
        retValue = sqlTypeName.equals("SMALLINT") ? DataType.SMALLINT : retValue;
        retValue = sqlTypeName.equals("INTEGER") ? DataType.INTEGER : retValue;
        retValue = sqlTypeName.equals("INT") ? DataType.INTEGER : retValue;
        retValue = sqlTypeName.equals("BIGINT") ? DataType.BIGINT : retValue;
        retValue = sqlTypeName.equals("FLOAT") ? DataType.FLOAT : retValue;
        retValue = sqlTypeName.equals("DOUBLE") ? DataType.DOUBLE : retValue;
        retValue = sqlTypeName.equals("REAL") ? DataType.REAL : retValue;
        retValue = sqlTypeName.equals("NUMERIC") ? DataType.NUMERIC : retValue;
        retValue = sqlTypeName.equals("DECIMAL") ? DataType.DECIMAL : retValue;
        retValue = sqlTypeName.equals("DATE") ? DataType.DATE : retValue;
        retValue = sqlTypeName.equals("TIME") ? DataType.TIME : retValue;
        retValue = sqlTypeName.equals("TIMESTAMP") ? DataType.TIMESTAMP : retValue;
        retValue = sqlTypeName.equals("BINARY") ? DataType.BINARY : retValue;
        retValue = sqlTypeName.equals("VARBINARY") ? DataType.VARBINARY : retValue;
        retValue = sqlTypeName.equals("LONGVARBINARY") ? DataType.LONGVARBINARY : retValue;
        retValue = sqlTypeName.equals("BLOB") ? DataType.BLOB : retValue;
        retValue = sqlTypeName.equals("JAVA_OBJECT") ? DataType.forSqlType(2000) : retValue;
        return retValue;
    }
}

