/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.common.handlers;

import org.dbunit.dataset.common.handlers.Helper;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.Pipeline;
import org.dbunit.dataset.common.handlers.PipelineComponent;
import org.dbunit.dataset.common.handlers.PipelineConfig;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineComponent
implements PipelineComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPipelineComponent.class);
    private PipelineComponent successor;
    private Pipeline pipeline;
    private Helper helper;

    protected PipelineComponent getSuccessor() {
        return this.successor;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void setPipeline(Pipeline pipeline) {
        logger.debug("setPipeline(pipeline={}) - start", (Object)pipeline);
        this.pipeline = pipeline;
    }

    protected PipelineConfig getPipelineConfig() {
        if (this.getPipeline() != null) {
            return this.getPipeline().getPipelineConfig();
        }
        throw new IllegalStateException("The pipeline is not set for this component. Cannot proceed");
    }

    @Override
    public void setSuccessor(PipelineComponent successor) {
        logger.debug("setSuccessor(successor={}) - start", (Object)successor);
        this.successor = successor;
    }

    private StringBuffer getThePiece() {
        return this.getPipeline().getCurrentProduct();
    }

    @Override
    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        if (logger.isDebugEnabled()) {
            logger.debug("handle(c={}) - start", (Object)String.valueOf(c));
        }
        if (!this.canHandle(c)) {
            this.getSuccessor().handle(c);
        } else {
            this.getHelper().helpWith(c);
        }
    }

    @Override
    public void noMoreInput() {
        logger.debug("noMoreInput() - start");
        if (this.allowForNoMoreInput() && this.getSuccessor() != null) {
            this.getSuccessor().noMoreInput();
        }
    }

    @Override
    public boolean allowForNoMoreInput() {
        logger.debug("allowForNoMoreInput() - start");
        return this.getHelper().allowForNoMoreInput();
    }

    protected static PipelineComponent createPipelineComponent(AbstractPipelineComponent handler, Helper helper) {
        logger.debug("createPipelineComponent(handler={}, helper={}) - start", (Object)handler, (Object)helper);
        helper.setHandler(handler);
        handler.setHelper(helper);
        return handler;
    }

    @Override
    public void accept(char c) {
        this.getThePiece().append(c);
    }

    protected Helper getHelper() {
        return this.helper;
    }

    private void setHelper(Helper helper) {
        logger.debug("setHelper(helper={}) - start", (Object)helper);
        this.helper = helper;
    }

    protected static class ACCEPT
    extends Helper {
        protected ACCEPT() {
        }

        @Override
        public void helpWith(char c) {
            if (logger.isDebugEnabled()) {
                logger.debug("helpWith(c={}) - start", (Object)String.valueOf(c));
            }
            this.getHandler().accept(c);
        }
    }

    protected static class IGNORE
    extends Helper {
        protected IGNORE() {
        }

        @Override
        public void helpWith(char c) {
        }
    }
}

