/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.deployit.plugin.api.services.ArtifactTransformerException;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.configuration.TransactionalStitchService;
import com.xebialabs.deployit.plugin.stitch.model.Processor;
import com.xebialabs.deployit.plugin.stitch.model.processor.MacroProcessor;
import com.xebialabs.deployit.plugin.stitch.model.processor.RuleProcessor;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSet;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors$;
import com.xebialabs.deployit.plugin.stitch.service.RuleProcessorService;
import com.xebialabs.deployit.plugin.stitch.service.RuleProcessorService$;
import com.xebialabs.deployit.plugin.stitch.service.engine.DefaultStitchEngine$;
import com.xebialabs.deployit.plugin.stitch.service.engine.ProcessorDiffPreview;
import com.xebialabs.deployit.plugin.stitch.service.engine.StitchEngine;
import com.xebialabs.deployit.plugin.stitch.service.engine.StitchEngine$;
import com.xebialabs.deployit.plugin.stitch.service.engine.TransformPreview;
import com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.FormatResolver;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.input.InputAdapterRegistry;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.input.adapter.InputAdapter;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.output.OutputConsumerRegistry;
import com.xebialabs.deployit.plugin.stitch.service.engine.format.output.consumer.OutputConsumer;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.ExecutionOutput;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.PipelineExecutor;
import com.xebialabs.deployit.plugin.stitch.service.engine.pipeline.VerboseExecutionOutput;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.ObjectMapperFactory;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.DeploymentContextBuilder$;
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.InputContextBuilder$;
import com.xebialabs.deployit.plugin.stitch.service.util.InputStreamUtils$;
import com.xebialabs.deployit.plugin.stitch.service.util.PipelineContextUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;

@Service(value="stitchEngine")
@Autowired
@TransactionalStitchService
@ScalaSignature(bytes="\u0006\u0005\r%r!\u0002\u0014(\u0011\u00031d!\u0002\u001d(\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u0019\u0006\u0001\u000b\u0011\u0002#\t\u000f5\u000b!\u0019!C\u0001\u0007\"1a*\u0001Q\u0001\n\u0011CqaT\u0001C\u0002\u0013\u00051\t\u0003\u0004Q\u0003\u0001\u0006I\u0001\u0012\u0005\b#\u0006\u0011\r\u0011\"\u0001D\u0011\u0019\u0011\u0016\u0001)A\u0005\t\"91+\u0001b\u0001\n\u0003\u0019\u0005B\u0002+\u0002A\u0003%A\tC\u0004V\u0003\t\u0007I\u0011A\"\t\rY\u000b\u0001\u0015!\u0003E\u0011\u001d9\u0016A1A\u0005\u0002\rCa\u0001W\u0001!\u0002\u0013!e\u0001\u0002\u001d(\u0001eC\u0001\"Z\t\u0003\u0002\u0003\u0006IA\u001a\u0005\t]F\u0011\t\u0011)A\u0005_\"AQ/\u0005B\u0001B\u0003%a\u000f\u0003\u0005{#\t\u0005\t\u0015!\u0003|\u0011%y\u0018C!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u000eE\u0011\t\u0011)A\u0005\u0003\u001fAa\u0001Q\t\u0005\u0002\u0005m\u0001bBA\u0016#\u0011\u0005\u0013Q\u0006\u0005\n\u0003\u001f\f\u0012\u0013!C\u0001\u0003#Dq!a:\u0012\t\u0013\tI\u000fC\u0004\u0003\u0004E!IA!\u0002\t\u000f\tu\u0011\u0003\"\u0003\u0003 !9!1J\t\u0005\n\t5\u0003\"\u0003BM#E\u0005I\u0011\u0002BN\u0011%\u0011y*EI\u0001\n\u0013\u0011\t\u000bC\u0004\u0003LE!\tE!+\t\u000f\t=\u0016\u0003\"\u0011\u00032\"9!\u0011Y\t\u0005B\t\r\u0007b\u0002Bj#\u0011\u0005#Q\u001b\u0005\b\u00057\fB\u0011\tBo\u0003M!UMZ1vYR\u001cF/\u001b;dQ\u0016sw-\u001b8f\u0015\tA\u0013&\u0001\u0004f]\u001eLg.\u001a\u0006\u0003U-\nqa]3sm&\u001cWM\u0003\u0002-[\u000511\u000f^5uG\"T!AL\u0018\u0002\rAdWoZ5o\u0015\t\u0001\u0014'\u0001\u0005eKBdw._5u\u0015\t\u00114'A\u0005yK\nL\u0017\r\\1cg*\tA'A\u0002d_6\u001c\u0001\u0001\u0005\u00028\u00035\tqEA\nEK\u001a\fW\u000f\u001c;Ti&$8\r[#oO&tWm\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0002GM#\u0018\u000e^2i\u000b:<\u0017N\\3BeRLg-Y2u)J\fgn\u001d4pe6,'OT1nKV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\rM#(/\u001b8h\u0003\u0011\u001aF/\u001b;dQ\u0016sw-\u001b8f\u0003J$\u0018NZ1diR\u0013\u0018M\\:g_JlWM\u001d(b[\u0016\u0004\u0013A\t)sKB\u0013xnY3tg&tw\r\u0016:b]N4wN]7bi&|gN\u00127bO.+\u00170A\u0012Qe\u0016\u0004&o\\2fgNLgn\u001a+sC:\u001chm\u001c:nCRLwN\u001c$mC\u001e\\U-\u001f\u0011\u0002GA{7\u000f\u001e)s_\u000e,7o]5oOR\u0013\u0018M\\:g_Jl\u0017\r^5p]\u001ac\u0017mZ&fs\u0006!\u0003k\\:u!J|7-Z:tS:<GK]1og\u001a|'/\\1uS>tg\t\\1h\u0017\u0016L\b%A\tJ]Z|7-\u0019;j_:t\u0015-\\3LKf\f!#\u00138w_\u000e\fG/[8o\u001d\u0006lWmS3zA\u0005!B)\u001a9m_flWM\u001c;D_:$X\r\u001f;WCJ\fQ\u0003R3qY>LX.\u001a8u\u0007>tG/\u001a=u-\u0006\u0014\b%\u0001\tQe\u0016\u0004&o\\2fgNLgn\u001a,be\u0006\t\u0002K]3Qe>\u001cWm]:j]\u001e4\u0016M\u001d\u0011\u0002#A{7\u000f\u001e)s_\u000e,7o]5oOZ\u000b'/\u0001\nQ_N$\bK]8dKN\u001c\u0018N\\4WCJ\u00043\u0003B\t;5v\u0003\"aN.\n\u0005q;#\u0001D*uSR\u001c\u0007.\u00128hS:,\u0007C\u00010d\u001b\u0005y&B\u00011b\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0017\u0001C4sSjTH.\u001a3\n\u0005\u0011|&a\u0002'pO\u001eLgnZ\u0001\u0015S:\u0004X\u000f^!eCB$XM\u001d*fO&\u001cHO]=\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017!B5oaV$(BA6(\u0003\u00191wN]7bi&\u0011Q\u000e\u001b\u0002\u0015\u0013:\u0004X\u000f^!eCB$XM\u001d*fO&\u001cHO]=\u0002-=,H\u000f];u\u0007>t7/^7feJ+w-[:uef\u0004\"\u0001]:\u000e\u0003ET!A\u001d6\u0002\r=,H\u000f];u\u0013\t!\u0018O\u0001\fPkR\u0004X\u000f^\"p]N,X.\u001a:SK\u001eL7\u000f\u001e:z\u000391wN]7biJ+7o\u001c7wKJ\u0004\"a\u001e=\u000e\u0003)L!!\u001f6\u0003\u001d\u0019{'/\\1u%\u0016\u001cx\u000e\u001c<fe\u0006!\"/\u001e7f!J|7-Z:t_J\u001cVM\u001d<jG\u0016\u0004\"\u0001`?\u000e\u0003%J!A`\u0015\u0003)I+H.\u001a)s_\u000e,7o]8s'\u0016\u0014h/[2f\u0003A\u0001\u0018\u000e]3mS:,W\t_3dkR|'\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9aJ\u0001\ta&\u0004X\r\\5oK&!\u00111BA\u0003\u0005A\u0001\u0016\u000e]3mS:,W\t_3dkR|'/A\u0006nCB\u0004XM]+uS2\u001c\b\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Uq%A\u0005qe>\u001cWm]:pe&!\u0011\u0011DA\n\u0005My%M[3di6\u000b\u0007\u000f]3s\r\u0006\u001cGo\u001c:z)9\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\u0001\"aN\t\t\u000b\u0015D\u0002\u0019\u00014\t\u000b9D\u0002\u0019A8\t\u000bUD\u0002\u0019\u0001<\t\u000biD\u0002\u0019A>\t\r}D\u0002\u0019AA\u0001\u0011\u001d\ti\u0001\u0007a\u0001\u0003\u001f\tA\u0002\u001d:pG\u0016\u001c8OU;mKN$B\"a\f\u0002\u0010\u0006}\u0015\u0011VA[\u0003\u000b$b!!\r\u0002p\u0005}\u0004cB\u001e\u00024\u0005]\u00121L\u0005\u0004\u0003ka$A\u0002+va2,'\u0007\u0005\u0004\u0002:\u0005%\u0013q\n\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%N\u0001\u0007yI|w\u000e\u001e \n\u0003uJ1!a\u0012=\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0013\u0002N\t!A*[:u\u0015\r\t9\u0005\u0010\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK\u0016\u0002\u000b5|G-\u001a7\n\t\u0005e\u00131\u000b\u0002\n!J|7-Z:t_J\u0004\u0002\"!\u0018\u0002f\u0005-\u00141\u000e\b\u0005\u0003?\n\t\u0007E\u0002\u0002>qJ1!a\u0019=\u0003\u0019\u0001&/\u001a3fM&!\u0011qMA5\u0005\ri\u0015\r\u001d\u0006\u0004\u0003Gb\u0004\u0003BA/\u0003[J1aSA5\u0011\u001d\t\t(\u0007a\u0002\u0003g\nA\"\u001b8qkR\fE-\u00199uKJ\u0004B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sB\u0017aB1eCB$XM]\u0005\u0005\u0003{\n9H\u0001\u0007J]B,H/\u00113baR,'\u000fC\u0004\u0002\u0002f\u0001\u001d!a!\u0002\u001d=,H\u000f];u\u0007>t7/^7feB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nF\f\u0001bY8ogVlWM]\u0005\u0005\u0003\u001b\u000b9I\u0001\bPkR\u0004X\u000f^\"p]N,X.\u001a:\t\u000f\u0005E\u0015\u00041\u0001\u0002\u0014\u000611o\\;sG\u0016\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033C\u0015AA5p\u0013\u0011\ti*a&\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003CK\u0002\u0019AAR\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\t\u0005U\u0015QU\u0005\u0005\u0003O\u000b9J\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002,f\u0001\r!!,\u0002\u001fAL\u0007/\u001a7j]\u0016\u001cuN\u001c;fqR\u0004\u0002\"!\u0018\u0002f\u0005-\u0014q\u0016\t\u0004w\u0005E\u0016bAAZy\t\u0019\u0011I\\=\t\u0013\u0005]\u0016\u0004%AA\u0002\u0005e\u0016!C2iC:<WmU3u!\u0015Y\u00141XA`\u0013\r\ti\f\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\f\t-C\u0002\u0002D&\u0012\u0011b\u00115b]\u001e,7+\u001a;\t\u0013\u0005\u001d\u0017\u0004%AA\u0002\u0005%\u0017aD1eI>s\u0007K]8dKN\u001cxN]:\u0011\u0007q\fY-C\u0002\u0002N&\u0012\u0001\u0003\u0012:z%Vt\u0007K]8dKN\u001cxN]:\u0002-A\u0014xnY3tgJ+H.Z:%I\u00164\u0017-\u001e7uIQ*\"!a5+\t\u0005e\u0016Q[\u0016\u0003\u0003/\u0004B!!7\u0002d6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001d\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002f\u0006m'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011s-\u001a;J]B,HoU8ve\u000e,')Y:fI>s\u0007K]3Qe>\u001cWm]:j]\u001e$b!a;\u0002\u0000\n\u0005\u0001\u0003BAw\u0003wl!!a<\u000b\t\u0005E\u00181_\u0001\tI\u0006$\u0018MY5oI*!\u0011Q_A|\u0003\u001dQ\u0017mY6t_:T1!!?4\u0003%1\u0017m\u001d;feblG.\u0003\u0003\u0002~\u0006=(\u0001\u0003&t_:tu\u000eZ3\t\u000f\u0005-6\u00041\u0001\u0002.\"1\u0011n\u0007a\u0001\u0003W\fQcZ3u\r&t\u0017\r\u001c)s_\u000e,7o]8s\u0019&\u001cH\u000f\u0006\u0006\u0003\b\tM!Q\u0003B\f\u00053\u0001b!!\u000f\u0002J\t%\u0001\u0003\u0002B\u0006\u0005\u001fi!A!\u0004\u000b\t\u0005U\u00111K\u0005\u0005\u0005#\u0011iAA\u0007Sk2,\u0007K]8dKN\u001cxN\u001d\u0005\b\u0003Wc\u0002\u0019AAW\u0011\u001d\t9\r\ba\u0001\u0005\u000fAa!\u001b\u000fA\u0002\u0005-\bb\u0002B\u000e9\u0001\u0007!qA\u0001\u0013KbL7\u000f^5oOB\u0013xnY3tg>\u00148/\u0001\u000eqe>\u001cWm]:Sk2,7oV5uQ\n\u0013X-Y6q_&tG\u000f\u0006\b\u0003\"\t5\"q\u0006B\u001a\u0005o\u0011ID!\u0013\u0015\r\t\r\"\u0011\u0006B\u0016!\rY$QE\u0005\u0004\u0005Oa$\u0001B+oSRDq!!\u001d\u001e\u0001\b\t\u0019\bC\u0004\u0002\u0002v\u0001\u001d!a!\t\u000f\u0005EU\u00041\u0001\u0002\u0014\"9!\u0011G\u000fA\u0002\u0005\r\u0016A\u00069sKZLw.^:Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8\t\u000f\tUR\u00041\u0001\u0002$\u0006)2-\u001e:sK:$HK]1og\u001a|'/\\1uS>t\u0007bBAV;\u0001\u0007\u0011Q\u0016\u0005\b\u0005wi\u0002\u0019\u0001B\u001f\u0003M\u0001(o\\2fgN|'O\u0011:fC.\u0004x.\u001b8u!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#b\u0001B\"\u0011\u0006!Q\u000f^5m\u0013\u0011\u00119E!\u0011\u0003\tU+\u0016\n\u0012\u0005\b\u0003ok\u0002\u0019AA]\u0003%!(/\u00198tM>\u0014X.\u0006\u0003\u0003P\tUC\u0003\u0005B)\u0005C\u0012\u0019Ga\u001b\u0003\u0002\n-%Q\u0013BL!\u0011\u0011\u0019F!\u0016\r\u0001\u00119!q\u000b\u0010C\u0002\te#!\u0001+\u0012\t\tm\u0013q\u0016\t\u0004w\tu\u0013b\u0001B0y\t9aj\u001c;iS:<\u0007bBAI=\u0001\u0007\u00111\u0013\u0005\b\u0005Kr\u0002\u0019\u0001B4\u0003U!(/\u00198tM>\u0014X.\u0019;j_:\u001cuN\u001c;fqR\u0004\u0002Ba\u0010\u0003j\u0005-\u0014qV\u0005\u0005\u0003O\u0012\t\u0005C\u0004\u0003ny\u0001\rAa\u001c\u0002\u001bI,G/\u001e:o\u0011\u0006tG\r\\3s!-Y$\u0011\u000fB;\u0003o\tYF!\u0015\n\u0007\tMDHA\u0005Gk:\u001cG/[8ogA)1Ha\u001e\u0003|%\u0019!\u0011\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0007m\u0012i(C\u0002\u0003\u0000q\u0012AAQ=uK\"9!1\u0011\u0010A\u0002\t\u0015\u0015A\u0004:fiV\u0014hn\u0014:jO&t\u0017\r\u001c\t\bw\t\u001d%Q\u000fB)\u0013\r\u0011I\t\u0010\u0002\n\rVt7\r^5p]FBqA!$\u001f\u0001\u0004\u0011y)\u0001\u000beK\u001a\fW\u000f\u001c;SKN,H\u000e\u001e%b]\u0012dWM\u001d\t\u0006w\tE%\u0011K\u0005\u0004\u0005'c$!\u0003$v]\u000e$\u0018n\u001c81\u0011%\t9L\bI\u0001\u0002\u0004\tI\fC\u0005\u0002Hz\u0001\n\u00111\u0001\u0002J\u0006\u0019BO]1og\u001a|'/\u001c\u0013eK\u001a\fW\u000f\u001c;%mU!\u0011\u0011\u001bBO\t\u001d\u00119f\bb\u0001\u00053\n1\u0003\u001e:b]N4wN]7%I\u00164\u0017-\u001e7uI]*BAa)\u0003(V\u0011!Q\u0015\u0016\u0005\u0003\u0013\f)\u000eB\u0004\u0003X\u0001\u0012\rA!\u0017\u0015\r\u0005M%1\u0016BW\u0011\u001d\t\t*\ta\u0001\u0003'CqA!\u001a\"\u0001\u0004\u00119'\u0001\tqe\u00164\u0018.Z<Ue\u0006t7OZ8s[RQ!1\u0017B]\u0005w\u0013iLa0\u0011\u0007]\u0012),C\u0002\u00038\u001e\u0012\u0001\u0003\u0016:b]N4wN]7Qe\u00164\u0018.Z<\t\u000f\u0005E%\u00051\u0001\u0002\u0014\"9!Q\r\u0012A\u0002\t\u001d\u0004\"CA\\EA\u0005\t\u0019AA]\u0011%\t9M\tI\u0001\u0002\u0004\tI-\u0001\u000bqe\u00164\u0018.Z<Qe>\u001cWm]:pe\u0012KgM\u001a\u000b\u000b\u0005\u000b\u0014YM!4\u0003P\nE\u0007cA\u001c\u0003H&\u0019!\u0011Z\u0014\u0003)A\u0013xnY3tg>\u0014H)\u001b4g!J,g/[3x\u0011\u001d\t\tj\ta\u0001\u0003'CqA!\u001a$\u0001\u0004\u00119\u0007C\u0004\u0003<\r\u0002\rA!\u0010\t\u0013\u0005]6\u0005%AA\u0002\u0005e\u0016!\u00069sKZLWm\u001e*vY\u0016\u001cXI^1mk\u0006$xN\u001d\u000b\u0007\u0003o\u00119N!7\t\u000f\u0005EE\u00051\u0001\u0002\u0014\"9!Q\r\u0013A\u0002\t\u001d\u0014\u0001\u0003<bY&$\u0017\r^3\u0015\r\t\r\"q\u001cBq\u0011\u001d\t\t*\na\u0001\u0003'CqA!\u001a&\u0001\u0004\u00119\u0007K\u0004\u0012\u0005K\u0014IPa?\u0011\t\t\u001d(Q_\u0007\u0003\u0005STAAa;\u0003n\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\t=(\u0011_\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011!1_\u0001\u0004_J<\u0017\u0002\u0002B|\u0005S\u0014qaU3sm&\u001cW-A\u0003wC2,X-\t\u0002\u0003~\u0006a1\u000f^5uG\",enZ5oK\"\u001a\u0011c!\u0001\u0011\t\r\r1qB\u0007\u0003\u0007\u000bQA!!9\u0004\b)!1\u0011BB\u0006\u0003\u001d1\u0017m\u0019;pefTAa!\u0004\u0003n\u0006)!-Z1og&!1\u0011CB\u0003\u0005%\tU\u000f^8xSJ,G\rK\u0002\u0012\u0007+\u0001Baa\u0006\u0004&5\u00111\u0011\u0004\u0006\u0005\u00077\u0019i\"A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0005\u0007?\u0019\t#A\u0002ka\u0006T1aa\t,\u0003\r!\u0017m\\\u0005\u0005\u0007O\u0019IB\u0001\u000eUe\u0006t7/Y2uS>t\u0017\r\\*uSR\u001c\u0007nU3sm&\u001cW\r")
public class DefaultStitchEngine
implements StitchEngine,
Logging {
    private final InputAdapterRegistry inputAdapterRegistry;
    private final OutputConsumerRegistry outputConsumerRegistry;
    private final FormatResolver formatResolver;
    private final RuleProcessorService ruleProcessorService;
    private final PipelineExecutor pipelineExecutor;
    private final ObjectMapperFactory mapperUtils;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String PostProcessingVar() {
        return DefaultStitchEngine$.MODULE$.PostProcessingVar();
    }

    public static String PreProcessingVar() {
        return DefaultStitchEngine$.MODULE$.PreProcessingVar();
    }

    public static String DeploymentContextVar() {
        return DefaultStitchEngine$.MODULE$.DeploymentContextVar();
    }

    public static String InvocationNameKey() {
        return DefaultStitchEngine$.MODULE$.InvocationNameKey();
    }

    public static String PostProcessingTransformationFlagKey() {
        return DefaultStitchEngine$.MODULE$.PostProcessingTransformationFlagKey();
    }

    public static String PreProcessingTransformationFlagKey() {
        return DefaultStitchEngine$.MODULE$.PreProcessingTransformationFlagKey();
    }

    public static String StitchEngineArtifactTransformerName() {
        return DefaultStitchEngine$.MODULE$.StitchEngineArtifactTransformerName();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DryRunProcessors processRules$default$5() {
        return StitchEngine.processRules$default$5$(this);
    }

    @Override
    public Option<ChangeSet> previewTransform$default$3() {
        return StitchEngine.previewTransform$default$3$(this);
    }

    @Override
    public DryRunProcessors previewTransform$default$4() {
        return StitchEngine.previewTransform$default$4$(this);
    }

    @Override
    public Option<ChangeSet> previewProcessorDiff$default$4() {
        return StitchEngine.previewProcessorDiff$default$4$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultStitchEngine defaultStitchEngine = this;
        synchronized (defaultStitchEngine) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Tuple2<List<Processor>, scala.collection.immutable.Map<String, String>> processRules(InputStream source, OutputStream destination, scala.collection.immutable.Map<String, Object> pipelineContext, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors, InputAdapter inputAdapter, OutputConsumer outputConsumer) {
        this.logger().trace((Function0 & Serializable)() -> "Searching for stitch processor...");
        Tuple2<InputStream, InputStream> tuple2 = InputStreamUtils$.MODULE$.cloneInputStream(source);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputStream clonedSource = (InputStream)tuple2._1();
        InputStream originalSource = (InputStream)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)clonedSource, (Object)originalSource);
        InputStream clonedSource2 = (InputStream)tuple22._1();
        InputStream originalSource2 = (InputStream)tuple22._2();
        Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            InputStream source = (InputStream)use.apply((Object)clonedSource2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            InputStream managedOriginalSource = (InputStream)use.apply((Object)originalSource2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            JsonNode input = inputAdapter.convert(source);
            Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DeploymentContext deploymentContext = (DeploymentContext)tuple3._1();
            boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean postProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)deploymentContext, (Object)BoxesRunTime.boxToBoolean((boolean)preProcessing), (Object)BoxesRunTime.boxToBoolean((boolean)postProcessing));
            DeploymentContext deploymentContext2 = (DeploymentContext)tuple32._1();
            boolean preProcessing2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
            boolean postProcessing2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            List<RuleProcessor> existingProcessors = $this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(input), pipelineContext, changeSet);
            List<RuleProcessor> processors = this.getFinalProcessorList(pipelineContext, addOnProcessors.ruleProcessors(), input, existingProcessors);
            this.logger().info((Function0 & Serializable)() -> "Total of " + processors.length() + " stitch processors will be applied to the input.");
            this.logger().debug((Function0 & Serializable)() -> "Stitch processors found: " + processors + ". Executing on input:\n" + input.toPrettyString() + ".");
            if (processors.isEmpty()) {
                Integer n;
                if (preProcessing2 || postProcessing2) {
                    this.logger().debug((Function0 & Serializable)() -> "Pre/post processing processors execution wasn't triggered, returning empty array as result.");
                    outputConsumer.write((JsonNode)$this.mapperUtils.mapper().createArrayNode(), destination);
                    n = BoxedUnit.UNIT;
                } else {
                    this.logger().debug((Function0 & Serializable)() -> "Processors execution wasn't triggered, leaving input unchanged");
                    n = BoxesRunTime.boxToInteger((int)IOUtils.copy((InputStream)managedOriginalSource, (OutputStream)destination));
                }
                return new Tuple2(processors, (Object)Predef$.MODULE$.Map().empty());
            }
            JsonNode x$1 = this.getInputSourceBasedOnPreProcessing(pipelineContext, input);
            List<RuleProcessor> x$2 = processors;
            DeploymentContext x$3 = deploymentContext2;
            scala.collection.immutable.Map<String, List<MacroProcessor>> x$4 = addOnProcessors.macroProcessors();
            scala.collection.mutable.Map<String, Object> x$5 = $this.pipelineExecutor.execute$default$4();
            ExecutionOutput executionResult = $this.pipelineExecutor.execute(x$1, x$2, x$3, x$5, x$4);
            this.logger().debug((Function0 & Serializable)() -> "Processors executed, finished with result:\n" + executionResult.result().toPrettyString());
            int errorSize = executionResult.processorErrors().size();
            this.logger().info((Function0 & Serializable)() -> "Total of " + (processors.length() - errorSize) + " stitch processors applied. Total of " + errorSize + " erred stitch processors.");
            outputConsumer.write(executionResult.result(), destination);
            return new Tuple2(processors, executionResult.processorErrors());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 result = (Tuple2)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public Option<ChangeSet> processRules$default$4() {
        return None$.MODULE$;
    }

    private JsonNode getInputSourceBasedOnPreProcessing(scala.collection.immutable.Map<String, Object> pipelineContext, JsonNode input) {
        Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean postProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(preProcessing, postProcessing);
        boolean preProcessing2 = sp2._1$mcZ$sp();
        boolean postProcessing2 = sp2._2$mcZ$sp();
        if (preProcessing2 || postProcessing2) {
            return this.mapperUtils.mapper().createArrayNode();
        }
        return input;
    }

    private List<RuleProcessor> getFinalProcessorList(scala.collection.immutable.Map<String, Object> pipelineContext, List<RuleProcessor> addOnProcessors, JsonNode input, List<RuleProcessor> existingProcessors) {
        List<RuleProcessor> list;
        List<RuleProcessor> list2 = addOnProcessors;
        if (list2 != null && (list = list2).nonEmpty()) {
            List<RuleProcessor> filterProcessor;
            List<RuleProcessor> list3 = filterProcessor = this.ruleProcessorService.getFilteredAddOnProcessors(InputContextBuilder$.MODULE$.build(input), pipelineContext, list);
            List finalProcessorList = existingProcessors.$colon$colon$colon(list3);
            return (List)finalProcessorList.sortBy((Function1 & Serializable)p -> new Tuple4(p.phase().getOrElse((Function0 & Serializable)() -> RuleProcessorService$.MODULE$.DefaultPhase()), p.weight().getOrElse((Function0 & Serializable)() -> RuleProcessorService$.MODULE$.DefaultWeight()), (Object)p.rule().name(), (Object)BoxesRunTime.boxToInteger((int)p.order())), Ordering$.MODULE$.Tuple4(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        }
        return existingProcessors;
    }

    private void processRulesWithBreakpoint(InputStream source, OutputStream previousTransformation, OutputStream currentTransformation, scala.collection.immutable.Map<String, Object> pipelineContext, UUID processorBreakpoint, Option<ChangeSet> changeSet, InputAdapter inputAdapter, OutputConsumer outputConsumer) {
        JsonNode input = inputAdapter.convert(source);
        Tuple3<DeploymentContext, Object, Object> tuple3 = PipelineContextUtils$.MODULE$.extractVariablesFromPipelineContext(pipelineContext);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DeploymentContext deploymentContext = (DeploymentContext)tuple3._1();
        boolean preProcessing = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        Tuple2 tuple2 = new Tuple2((Object)deploymentContext, (Object)BoxesRunTime.boxToBoolean((boolean)preProcessing));
        DeploymentContext deploymentContext2 = (DeploymentContext)tuple2._1();
        boolean preProcessing2 = tuple2._2$mcZ$sp();
        List<RuleProcessor> existingProcessors = this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(input), pipelineContext, changeSet);
        List<RuleProcessor> processors = this.getFinalProcessorList(pipelineContext, (List<RuleProcessor>)package$.MODULE$.List().empty(), input, existingProcessors);
        int breakpointIndex = processors.indexWhere((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DefaultStitchEngine.$anonfun$processRulesWithBreakpoint$1(processorBreakpoint, x$5))) + 1;
        List<RuleProcessor> preBreakpointProcessors = preProcessing2 && ((Object)BoxesRunTime.boxToInteger((int)breakpointIndex)).equals(BoxesRunTime.boxToInteger((int)0)) ? processors : processors.take(breakpointIndex);
        this.logger().info((Function0 & Serializable)() -> "Total of " + preBreakpointProcessors.length() + " out of " + processors.length() + " stitch processors will be applied to the input to generate preview with processor breakpoint.");
        VerboseExecutionOutput executionResult = this.pipelineExecutor.verboseExecute(this.getInputSourceBasedOnPreProcessing(pipelineContext, input), preBreakpointProcessors, deploymentContext2, this.pipelineExecutor.verboseExecute$default$4(), this.pipelineExecutor.verboseExecute$default$5());
        outputConsumer.write(executionResult.input(), previousTransformation);
        outputConsumer.write(executionResult.result(), currentTransformation);
    }

    private <T> T transform(InputStream source, Map<String, Object> transformationContext, Function3<byte[], List<Processor>, scala.collection.immutable.Map<String, String>, T> returnHandler, Function1<byte[], T> returnOriginal, Function0<T> defaultResultHandler, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors) {
        if (source.available() > 0) {
            Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                InputStream origin = (InputStream)use.apply((Object)source, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                return InputStreamUtils$.MODULE$.cloneInputStreamToString(origin);
            });
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Tuple2 result = (Tuple2)success.value();
            Tuple2 tuple2 = result;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream duplicateIS = (InputStream)tuple2._1();
            String originalDocument = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)duplicateIS, (Object)originalDocument);
            InputStream duplicateIS2 = (InputStream)tuple22._1();
            String originalDocument2 = (String)tuple22._2();
            boolean bl = false;
            Failure failure = null;
            Try try_2 = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                InputStream managedSource = (InputStream)use.apply((Object)duplicateIS2, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                String format = $this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                InputAdapter inputAdapter = $this.inputAdapterRegistry.adapterFor(format);
                OutputConsumer outputConsumer = $this.outputConsumerRegistry.consumerFor(format);
                Tuple2<List<Processor>, scala.collection.immutable.Map<String, String>> tuple2 = this.processRules(managedSource, output, PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), changeSet, addOnProcessors, inputAdapter, outputConsumer);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                List processors = (List)tuple2._1();
                scala.collection.immutable.Map exceptions = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)processors, (Object)exceptions);
                List processors2 = (List)tuple22._1();
                scala.collection.immutable.Map exceptions2 = (scala.collection.immutable.Map)tuple22._2();
                return returnHandler.apply((Object)output.toByteArray(), (Object)processors2, (Object)exceptions2);
            });
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                Object result2 = success2.value();
                return (T)result2;
            }
            if (try_2 instanceof Failure) {
                bl = true;
                failure = (Failure)try_2;
                Throwable e = failure.exception();
                if (e instanceof ArtifactTransformerException) {
                    ArtifactTransformerException artifactTransformerException = (ArtifactTransformerException)e;
                    this.warn((Function0<Object>)(Function0 & Serializable)() -> "Transformation context was not valid: " + artifactTransformerException.message() + " - returning original input stream");
                    return (T)returnOriginal.apply((Object)originalDocument2.getBytes());
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                this.warn((Function0<Object>)(Function0 & Serializable)() -> "Exception occurred during the stitch transformation with error message:\n " + e.getMessage() + " - returning non-transformed object", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw (Throwable)Option$.MODULE$.apply((Object)ExceptionUtils.getRootCause((Throwable)e)).getOrElse((Function0 & Serializable)() -> e);
            }
            throw new MatchError((Object)try_2);
        }
        this.warn((Function0<Object>)(Function0 & Serializable)() -> "InputStream is empty, transformation not applied - returning original input stream");
        return (T)defaultResultHandler.apply();
    }

    public InputStream transform(InputStream source, Map<String, Object> transformationContext) {
        return (InputStream)this.transform(source, transformationContext, (Function3 & Serializable)(output, x$8, x$9) -> new ByteArrayInputStream((byte[])output), (Function1 & Serializable)originalDocument -> new ByteArrayInputStream((byte[])originalDocument), (Function0 & Serializable)() -> source, this.transform$default$6(), this.transform$default$7());
    }

    private <T> Option<ChangeSet> transform$default$6() {
        return None$.MODULE$;
    }

    private <T> DryRunProcessors transform$default$7() {
        return new DryRunProcessors(DryRunProcessors$.MODULE$.apply$default$1(), DryRunProcessors$.MODULE$.apply$default$2());
    }

    @Override
    public TransformPreview previewTransform(InputStream source, Map<String, Object> transformationContext, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors) {
        return (TransformPreview)this.transform(source, transformationContext, (Function3 & Serializable)(output, processors, errorProcessors) -> new TransformPreview(new ByteArrayInputStream((byte[])output), (List<Processor>)processors, (scala.collection.immutable.Map<String, String>)errorProcessors), (Function1 & Serializable)originalDocument -> new TransformPreview(new ByteArrayInputStream((byte[])originalDocument), (List<Processor>)Nil$.MODULE$, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), (Function0 & Serializable)() -> new TransformPreview(source, (List<Processor>)Nil$.MODULE$, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), changeSet, addOnProcessors);
    }

    @Override
    public ProcessorDiffPreview previewProcessorDiff(InputStream source, Map<String, Object> transformationContext, UUID processorBreakpoint, Option<ChangeSet> changeSet) {
        Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            ByteArrayOutputStream previousOutput = (ByteArrayOutputStream)use.apply((Object)new ByteArrayOutputStream(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            ByteArrayOutputStream currentOutput = (ByteArrayOutputStream)use.apply((Object)new ByteArrayOutputStream(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            String format = $this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            InputAdapter inputAdapter = $this.inputAdapterRegistry.adapterFor(format);
            OutputConsumer outputConsumer = $this.outputConsumerRegistry.consumerFor(format);
            this.processRulesWithBreakpoint(source, previousOutput, currentOutput, PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), processorBreakpoint, changeSet, inputAdapter, outputConsumer);
            return new ProcessorDiffPreview(new ByteArrayInputStream(previousOutput.toByteArray()), new ByteArrayInputStream(currentOutput.toByteArray()));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ProcessorDiffPreview result = (ProcessorDiffPreview)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Exception occurred during preview processing with error message " + e.getMessage() + " - returning non-transformed object");
            throw (Throwable)Option$.MODULE$.apply((Object)ExceptionUtils.getRootCause((Throwable)e)).getOrElse((Function0 & Serializable)() -> e);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public List<Processor> previewRulesEvaluator(InputStream source, Map<String, Object> transformationContext) {
        String format = this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        InputAdapter inputAdapter = this.inputAdapterRegistry.adapterFor(format);
        return this.ruleProcessorService.getOrderedProcessorsForContext(InputContextBuilder$.MODULE$.build(inputAdapter, source), PipelineContextUtils$.MODULE$.getPipelineContext(transformationContext), this.ruleProcessorService.getOrderedProcessorsForContext$default$3());
    }

    public void validate(InputStream source, Map<String, Object> transformationContext) {
        String format = this.formatResolver.resolve((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(transformationContext).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        InputAdapter inputAdapter = this.inputAdapterRegistry.adapterFor(format);
        this.ruleProcessorService.validateRule(InputContextBuilder$.MODULE$.build(inputAdapter, source), DeploymentContextBuilder$.MODULE$.buildDeploymentContext(StitchEngine$.MODULE$.TransformationContextHelper(transformationContext).getDeploymentContext()));
    }

    public static final /* synthetic */ boolean $anonfun$processRulesWithBreakpoint$1(UUID processorBreakpoint$1, RuleProcessor x$5) {
        UUID uUID = x$5.id();
        UUID uUID2 = processorBreakpoint$1;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public DefaultStitchEngine(InputAdapterRegistry inputAdapterRegistry, OutputConsumerRegistry outputConsumerRegistry, FormatResolver formatResolver, RuleProcessorService ruleProcessorService, PipelineExecutor pipelineExecutor, ObjectMapperFactory mapperUtils) {
        this.inputAdapterRegistry = inputAdapterRegistry;
        this.outputConsumerRegistry = outputConsumerRegistry;
        this.formatResolver = formatResolver;
        this.ruleProcessorService = ruleProcessorService;
        this.pipelineExecutor = pipelineExecutor;
        this.mapperUtils = mapperUtils;
        Logging.$init$((Logging)this);
    }
}

