/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.server;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.engine.parsing.HttpRequestParser;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.rendering.DateHeaderRendering;
import akka.http.impl.engine.rendering.HttpResponseRendererFactory;
import akka.http.impl.engine.rendering.ResponseRenderingContext;
import akka.http.impl.engine.rendering.ResponseRenderingOutput;
import akka.http.impl.engine.server.HttpServerBluePrint;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.One2OneBidiFlow$;
import akka.http.scaladsl.model.AttributeKey;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.Graph;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class HttpServerBluePrint$ {
    public static final HttpServerBluePrint$ MODULE$ = new HttpServerBluePrint$();
    private static final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)TLSProtocol.SendBytes$.MODULE$), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1 instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                return (B1)sessionBytes;
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
            TLSProtocol.SslTlsInbound sslTlsInbound = x1;
            return sslTlsInbound instanceof TLSProtocol.SessionBytes;
        }
    }));

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> apply(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return this.userHandlerGuard(settings.pipeliningLimit()).atop(this.requestTimeoutSupport(settings.timeouts().requestTimeout(), log)).atop(this.requestPreparation(settings)).atop(this.controller(settings, log)).atop(this.parsingRendering(settings, log, isSecureConnection, dateHeaderRendering)).atop(this.websocketSupport(settings, log)).atop(this.tlsSupport()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport() {
        return tlsSupport;
    }

    public BidiFlow<ResponseRenderingOutput, ByteString, TLSProtocol.SessionBytes, TLSProtocol.SessionBytes, NotUsed> websocketSupport(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ProtocolSwitchStage(settings, log));
    }

    public BidiFlow<ResponseRenderingContext, ResponseRenderingOutput, TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsingRendering(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return BidiFlow$.MODULE$.fromFlows(this.rendering(settings, log, dateHeaderRendering), this.parsing(settings, log, isSecureConnection));
    }

    public BidiFlow<HttpResponse, ResponseRenderingContext, ParserOutput.RequestOutput, ParserOutput.RequestOutput, NotUsed> controller(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ControllerStage(settings, log)).reversed();
    }

    public BidiFlow<HttpResponse, HttpResponse, ParserOutput.RequestOutput, HttpRequest, NotUsed> requestPreparation(ServerSettings settings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply(), (Graph)new HttpServerBluePrint.PrepareRequests(settings));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> requestTimeoutSupport(Duration timeout, LoggingAdapter log) {
        Duration duration = timeout;
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        if (!(duration != null ? !duration.equals(finiteDuration) : finiteDuration != null)) {
            return BidiFlow$.MODULE$.identity();
        }
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.RequestTimeoutSupport(timeout, log)).reversed();
    }

    public Flow<TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsing(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        HttpRequestParser rootParser = new HttpRequestParser(settings.parserSettings(), settings.websocketSettings(), settings.rawRequestUriHeader(), HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log));
        return (Flow)Flow$.MODULE$.apply().via((Graph)rootParser).map((Function1 & Serializable)requestOutput -> HttpServerBluePrint$.establishAbsoluteUri$1(requestOutput, isSecureConnection, settings));
    }

    public Flow<ResponseRenderingContext, ResponseRenderingOutput, NotUsed> rendering(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        HttpResponseRendererFactory responseRendererFactory = new HttpResponseRendererFactory(settings.serverHeader(), settings.responseHeaderSizeHint(), log, dateHeaderRendering);
        return Flow$.MODULE$.apply().via((Graph)responseRendererFactory.renderer().named("renderer"));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> userHandlerGuard(int pipeliningLimit) {
        return One2OneBidiFlow$.MODULE$.apply(pipeliningLimit, One2OneBidiFlow$.MODULE$.apply$default$2(), One2OneBidiFlow$.MODULE$.apply$default$3()).reversed();
    }

    private static final ParserOutput.RequestOutput establishAbsoluteUri$1(ParserOutput.RequestOutput requestOutput, boolean isSecureConnection$1, ServerSettings settings$1) {
        boolean bl = false;
        ParserOutput.RequestStart requestStart = null;
        ParserOutput.RequestOutput requestOutput2 = requestOutput;
        if (requestOutput2 instanceof ParserOutput.RequestStart) {
            bl = true;
            requestStart = (ParserOutput.RequestStart)requestOutput2;
            HttpMethod httpMethod = requestStart.method();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.CONNECT();
            if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                return new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("CONNECT requests are not supported", new StringBuilder(31).append("Rejecting CONNECT request to '").append(requestStart.uri()).append("'").toString()));
            }
        }
        if (bl) {
            ParserOutput.MessageStart messageStart;
            try {
                Uri effectiveUri;
                Uri x$1 = effectiveUri = HttpRequest$.MODULE$.effectiveUri(requestStart.uri(), (Seq<HttpHeader>)requestStart.headers(), isSecureConnection$1, settings$1.defaultHostHeader());
                HttpMethod x$2 = requestStart.copy$default$1();
                HttpProtocol x$3 = requestStart.copy$default$3();
                Map<AttributeKey<?>, Object> x$4 = requestStart.copy$default$4();
                List<HttpHeader> x$5 = requestStart.copy$default$5();
                ParserOutput.EntityCreator<ParserOutput.RequestOutput, RequestEntity> x$6 = requestStart.copy$default$6();
                boolean x$7 = requestStart.copy$default$7();
                boolean x$8 = requestStart.copy$default$8();
                messageStart = requestStart.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
            }
            catch (IllegalUriException e) {
                messageStart = new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), e.info());
            }
            return messageStart;
        }
        return requestOutput2;
    }

    private HttpServerBluePrint$() {
    }
}

