/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import java.time.Instant;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;

public abstract class AbstractOAuth2Token
implements OAuth2Token,
Serializable {
    private static final long serialVersionUID = 580L;
    private final String tokenValue;
    private final Instant issuedAt;
    private final Instant expiresAt;

    protected AbstractOAuth2Token(String tokenValue) {
        this(tokenValue, null, null);
    }

    protected AbstractOAuth2Token(String tokenValue, @Nullable Instant issuedAt, @Nullable Instant expiresAt) {
        Assert.hasText((String)tokenValue, (String)"tokenValue cannot be empty");
        if (issuedAt != null && expiresAt != null) {
            Assert.isTrue((boolean)expiresAt.isAfter(issuedAt), (String)"expiresAt must be after issuedAt");
        }
        this.tokenValue = tokenValue;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
    }

    @Override
    public String getTokenValue() {
        return this.tokenValue;
    }

    @Override
    @Nullable
    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    @Nullable
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractOAuth2Token other = (AbstractOAuth2Token)obj;
        if (!this.getTokenValue().equals(other.getTokenValue())) {
            return false;
        }
        if (this.getIssuedAt() != null ? !this.getIssuedAt().equals(other.getIssuedAt()) : other.getIssuedAt() != null) {
            return false;
        }
        return this.getExpiresAt() != null ? this.getExpiresAt().equals(other.getExpiresAt()) : other.getExpiresAt() == null;
    }

    public int hashCode() {
        int result = this.getTokenValue().hashCode();
        result = 31 * result + (this.getIssuedAt() != null ? this.getIssuedAt().hashCode() : 0);
        result = 31 * result + (this.getExpiresAt() != null ? this.getExpiresAt().hashCode() : 0);
        return result;
    }
}

