/*
 * Decompiled with CFR 0.152.
 */
package kamon.jsr166;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.LongBinaryOperator;
import sun.misc.Contended;
import sun.misc.Unsafe;

abstract class Striped64
extends Number {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int cellsBusy;
    private static final Unsafe U;
    private static final long BASE;
    private static final long CELLSBUSY;
    private static final long PROBE;

    Striped64() {
    }

    final long getAndSetBase(long l) {
        return U.getAndSetLong(this, BASE, l);
    }

    final boolean casBase(long l, long l2) {
        return U.compareAndSwapLong(this, BASE, l, l2);
    }

    final boolean casCellsBusy() {
        return U.compareAndSwapInt(this, CELLSBUSY, 0, 1);
    }

    static final int getProbe() {
        return U.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        U.putInt(Thread.currentThread(), PROBE, n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void longAccumulate(long l, LongBinaryOperator longBinaryOperator, boolean bl) {
        int n = Striped64.getProbe();
        if (n == 0) {
            ThreadLocalRandom.current();
            n = Striped64.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        while (true) {
            long l2;
            int n2;
            Cell[] cellArray = this.cells;
            if (this.cells != null && (n2 = cellArray.length) > 0) {
                Cell cell = cellArray[n2 - 1 & n];
                if (cell == null) {
                    if (this.cellsBusy == 0) {
                        Cell cell2 = new Cell(l);
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            try {
                                int n3;
                                int n4;
                                Cell[] cellArray2 = this.cells;
                                if (this.cells == null || (n4 = cellArray2.length) <= 0 || cellArray2[n3 = n4 - 1 & n] != null) continue;
                                cellArray2[n3] = cell2;
                                return;
                            }
                            finally {
                                this.cellsBusy = 0;
                                continue;
                            }
                        }
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    l2 = cell.value;
                    if (cell.cas(l2, longBinaryOperator == null ? l2 + l : longBinaryOperator.applyAsLong(l2, l))) return;
                    if (n2 >= NCPU || this.cells != cellArray) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == cellArray) {
                                this.cells = Arrays.copyOf(cellArray, n2 << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = Striped64.advanceProbe(n);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == cellArray && this.casCellsBusy()) {
                try {
                    if (this.cells != cellArray) continue;
                    Cell[] cellArray3 = new Cell[2];
                    cellArray3[n & 1] = new Cell(l);
                    this.cells = cellArray3;
                    return;
                }
                finally {
                    this.cellsBusy = 0;
                    continue;
                }
            }
            l2 = this.base;
            if (this.casBase(l2, longBinaryOperator == null ? l2 + l : longBinaryOperator.applyAsLong(l2, l))) return;
        }
    }

    private static long apply(DoubleBinaryOperator doubleBinaryOperator, long l, double d) {
        double d2 = Double.longBitsToDouble(l);
        d2 = doubleBinaryOperator == null ? d2 + d : doubleBinaryOperator.applyAsDouble(d2, d);
        return Double.doubleToRawLongBits(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doubleAccumulate(double d, DoubleBinaryOperator doubleBinaryOperator, boolean bl) {
        int n = Striped64.getProbe();
        if (n == 0) {
            ThreadLocalRandom.current();
            n = Striped64.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        while (true) {
            long l;
            int n2;
            Cell[] cellArray = this.cells;
            if (this.cells != null && (n2 = cellArray.length) > 0) {
                Cell cell = cellArray[n2 - 1 & n];
                if (cell == null) {
                    if (this.cellsBusy == 0) {
                        Cell cell2 = new Cell(Double.doubleToRawLongBits(d));
                        if (this.cellsBusy == 0 && this.casCellsBusy()) {
                            try {
                                int n3;
                                int n4;
                                Cell[] cellArray2 = this.cells;
                                if (this.cells == null || (n4 = cellArray2.length) <= 0 || cellArray2[n3 = n4 - 1 & n] != null) continue;
                                cellArray2[n3] = cell2;
                                return;
                            }
                            finally {
                                this.cellsBusy = 0;
                                continue;
                            }
                        }
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    l = cell.value;
                    if (cell.cas(l, Striped64.apply(doubleBinaryOperator, l, d))) return;
                    if (n2 >= NCPU || this.cells != cellArray) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.cellsBusy == 0 && this.casCellsBusy()) {
                        try {
                            if (this.cells == cellArray) {
                                this.cells = Arrays.copyOf(cellArray, n2 << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = Striped64.advanceProbe(n);
                continue;
            }
            if (this.cellsBusy == 0 && this.cells == cellArray && this.casCellsBusy()) {
                try {
                    if (this.cells != cellArray) continue;
                    Cell[] cellArray3 = new Cell[2];
                    cellArray3[n & 1] = new Cell(Double.doubleToRawLongBits(d));
                    this.cells = cellArray3;
                    return;
                }
                finally {
                    this.cellsBusy = 0;
                    continue;
                }
            }
            l = this.base;
            if (this.casBase(l, Striped64.apply(doubleBinaryOperator, l, d))) return;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> clazz = Unsafe.class;
                        for (Field field : clazz.getDeclaredFields()) {
                            field.setAccessible(true);
                            Object object = field.get(null);
                            if (!clazz.isInstance(object)) continue;
                            return (Unsafe)clazz.cast(object);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
            }
        }
    }

    static {
        try {
            U = Striped64.getUnsafe();
            BASE = U.objectFieldOffset(Striped64.class.getDeclaredField("base"));
            CELLSBUSY = U.objectFieldOffset(Striped64.class.getDeclaredField("cellsBusy"));
            PROBE = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    @Contended
    static final class Cell {
        volatile long value;
        private static final Unsafe U;
        private static final long VALUE;

        Cell(long l) {
            this.value = l;
        }

        final boolean cas(long l, long l2) {
            return U.compareAndSwapLong(this, VALUE, l, l2);
        }

        final void reset() {
            U.putLongVolatile(this, VALUE, 0L);
        }

        final void reset(long l) {
            U.putLongVolatile(this, VALUE, l);
        }

        final long getAndSet(long l) {
            return U.getAndSetLong(this, VALUE, l);
        }

        static {
            try {
                U = Striped64.getUnsafe();
                VALUE = U.objectFieldOffset(Cell.class.getDeclaredField("value"));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new Error(reflectiveOperationException);
            }
        }
    }
}

