/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSource
implements ImportSource {
    private final String location;
    private final boolean tempFile;
    private static final Logger logger = LoggerFactory.getLogger(FileSource.class);

    public FileSource(String location, boolean tempFile) {
        this.location = location;
        this.tempFile = tempFile;
    }

    public FileSource(File archive, boolean tempFile) {
        this.location = archive.getPath();
        this.tempFile = tempFile;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isTempFile() {
        return this.tempFile;
    }

    public File getFile() {
        return new File(this.location);
    }

    public void cleanUp() {
        if (this.isTempFile()) {
            try {
                GuavaFiles.deleteRecursively((File)this.getFile());
            }
            catch (IOException e) {
                logger.error("Could not clean up temporary file {}", (Object)this.location);
            }
        }
    }

    public String toString() {
        return "FileSource[" + this.location + "," + this.tempFile + "]";
    }
}

