/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.python.apache.xerces.impl.ExternalSubsetResolver;
import org.python.apache.xerces.impl.XMLEntityDescription;
import org.python.apache.xerces.xni.XMLResourceIdentifier;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.grammars.XMLDTDDescription;
import org.python.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EntityResolver2Wrapper
implements ExternalSubsetResolver {
    protected EntityResolver2 fEntityResolver;

    public EntityResolver2Wrapper() {
    }

    public EntityResolver2Wrapper(EntityResolver2 entityResolver2) {
        this.setEntityResolver(entityResolver2);
    }

    public void setEntityResolver(EntityResolver2 entityResolver2) {
        this.fEntityResolver = entityResolver2;
    }

    public EntityResolver2 getEntityResolver() {
        return this.fEntityResolver;
    }

    public XMLInputSource getExternalSubset(XMLDTDDescription xMLDTDDescription) throws XNIException, IOException {
        if (this.fEntityResolver != null) {
            String string2 = xMLDTDDescription.getRootName();
            String string3 = xMLDTDDescription.getBaseSystemId();
            try {
                InputSource inputSource = this.fEntityResolver.getExternalSubset(string2, string3);
                return inputSource != null ? this.createXMLInputSource(inputSource, string3) : null;
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception == null) {
                    exception = sAXException;
                }
                throw new XNIException(exception);
            }
        }
        return null;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        if (this.fEntityResolver != null) {
            String string2 = xMLResourceIdentifier.getPublicId();
            String string3 = xMLResourceIdentifier.getLiteralSystemId();
            String string4 = xMLResourceIdentifier.getBaseSystemId();
            String string5 = null;
            if (xMLResourceIdentifier instanceof XMLDTDDescription) {
                string5 = "[dtd]";
            } else if (xMLResourceIdentifier instanceof XMLEntityDescription) {
                string5 = ((XMLEntityDescription)xMLResourceIdentifier).getEntityName();
            }
            if (string2 == null && string3 == null) {
                return null;
            }
            try {
                InputSource inputSource = this.fEntityResolver.resolveEntity(string5, string2, string4, string3);
                return inputSource != null ? this.createXMLInputSource(inputSource, string4) : null;
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception == null) {
                    exception = sAXException;
                }
                throw new XNIException(exception);
            }
        }
        return null;
    }

    private XMLInputSource createXMLInputSource(InputSource inputSource, String string2) {
        String string3 = inputSource.getPublicId();
        String string4 = inputSource.getSystemId();
        String string5 = string2;
        InputStream inputStream = inputSource.getByteStream();
        Reader reader = inputSource.getCharacterStream();
        String string6 = inputSource.getEncoding();
        XMLInputSource xMLInputSource = new XMLInputSource(string3, string4, string5);
        xMLInputSource.setByteStream(inputStream);
        xMLInputSource.setCharacterStream(reader);
        xMLInputSource.setEncoding(string6);
        return xMLInputSource;
    }
}

