/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.legacy;

import com.xebialabs.deployit.engine.api.execution.StepState;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StepInfo {
    private final StepState step;
    private final int stepNr;

    public StepInfo(StepState step, int stepNr) {
        this.step = step;
        this.stepNr = stepNr;
    }

    public static List<StepInfo> asList(List<StepState> steps) {
        ArrayList<StepInfo> result = new ArrayList<StepInfo>(steps.size());
        int i = 1;
        for (StepState step : steps) {
            result.add(new StepInfo(step, i++));
        }
        return result;
    }

    public String getDescription() {
        return this.step.getDescription();
    }

    public String getState() {
        return this.step.getState().toString();
    }

    public Calendar getStartDate() {
        return this.step.getStartDate() != null ? this.step.getStartDate().toGregorianCalendar() : null;
    }

    public Calendar getCompletionDate() {
        return this.step.getCompletionDate() != null ? this.step.getCompletionDate().toGregorianCalendar() : null;
    }

    public String getLog() {
        return this.step.getLog();
    }

    public int getFailureCount() {
        return this.step.getFailureCount();
    }

    public int getNr() {
        return this.stepNr;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("nr", this.stepNr).append("description", (Object)this.getDescription()).append("state", (Object)this.getState()).append("startDate", (Object)this.getStartDate()).append("completionDate", (Object)this.getCompletionDate()).append("log", (Object)this.getLog()).append("failureCount", this.getFailureCount()).toString();
    }
}

