/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class DateTimeOffsetType
extends AbstractDataType {
    public static final int TYPE = -155;
    private static final DateTimeFormatter SQL_SERVER_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.n] xxx");

    public DateTimeOffsetType() {
        super("datetimeoffset", -155, OffsetDateTime.class, false);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        if (value == null || value instanceof OffsetDateTime) {
            return value;
        }
        if (value instanceof TemporalAccessor) {
            try {
                return OffsetDateTime.from((TemporalAccessor)value);
            }
            catch (DateTimeException e) {
                throw new TypeCastException(e);
            }
        }
        String valueAsString = value.toString();
        try {
            return OffsetDateTime.parse(valueAsString);
        }
        catch (DateTimeParseException e) {
            DateTimeParseException isoParseException = e;
            try {
                return OffsetDateTime.parse(valueAsString, SQL_SERVER_FORMAT);
            }
            catch (DateTimeParseException e2) {
                TypeCastException toThrow = new TypeCastException("Could not parse value using ISO 8601 or SQL Server's format", e2);
                toThrow.addSuppressed(isoParseException);
                throw toThrow;
            }
        }
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getObject(column, OffsetDateTime.class);
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.typeCast(value));
    }

    @Override
    public boolean isDateTime() {
        return true;
    }
}

