/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.HashSet;
import java.util.Set;
import org.dbunit.ExpectedDataSetAndVerifyTableDefinitionVerifier;
import org.dbunit.VerifyTableDefinition;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpectedDataSetAndVerifyTableDefinitionVerifier
implements ExpectedDataSetAndVerifyTableDefinitionVerifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void verify(VerifyTableDefinition[] verifyTableDefinitions, IDataSet expectedDataSet, DatabaseConfig config) throws DataSetException {
        String methodName = "verify";
        int verifyTableDefsCount = verifyTableDefinitions.length;
        String[] expectedTableNames = expectedDataSet.getTableNames();
        int expectedTablesCount = expectedTableNames.length;
        this.log.debug("{}: expectedTables count={}, verifyTableDefinitions count={}", new Object[]{"verify", expectedTablesCount, verifyTableDefsCount});
        if (expectedTablesCount > verifyTableDefsCount) {
            this.handleCountMismatch(verifyTableDefinitions, expectedTableNames, config);
        }
    }

    protected void handleCountMismatch(VerifyTableDefinition[] verifyTableDefinitions, String[] expectedTableNames, DatabaseConfig config) throws DataSetException {
        String methodName = "handleCountMismatch";
        int verifyTableDefsCount = verifyTableDefinitions.length;
        int expectedTablesCount = expectedTableNames.length;
        String msg = "{}: Test specified {} expected tables and {} VerifyTableDefinitions; usually these numbers should match as an expected table is not verified without a VerifyTableDefinition";
        this.log.warn("{}: Test specified {} expected tables and {} VerifyTableDefinitions; usually these numbers should match as an expected table is not verified without a VerifyTableDefinition", new Object[]{"handleCountMismatch", expectedTablesCount, verifyTableDefsCount});
        Set<String> mismatchedTableNames = this.makeMismatchedTableNamesList(verifyTableDefinitions, expectedTableNames);
        this.failOnMismatch(config, mismatchedTableNames);
    }

    protected Set<String> makeMismatchedTableNamesList(VerifyTableDefinition[] verifyTableDefinitions, String[] expectedTableNames) {
        HashSet<String> tables = new HashSet<String>();
        String methodName = "makeMismatchedTableNamesList";
        for (String expectedTableName : expectedTableNames) {
            boolean isExpectedTableExist = this.isVerifyTableDefinitionsHasTable(verifyTableDefinitions, expectedTableName);
            if (isExpectedTableExist) continue;
            String msg = "{}: expected table name={} does not have a corresponding VerifyTableDefinition";
            this.log.warn("{}: expected table name={} does not have a corresponding VerifyTableDefinition", (Object)"makeMismatchedTableNamesList", (Object)expectedTableName);
            tables.add(expectedTableName);
        }
        return tables;
    }

    protected boolean isVerifyTableDefinitionsHasTable(VerifyTableDefinition[] verifyTableDefinitions, String expectedTableName) {
        boolean isExpectedTableFound = false;
        for (int j = 0; j < verifyTableDefinitions.length && !isExpectedTableFound; ++j) {
            VerifyTableDefinition verifyTableDefinition = verifyTableDefinitions[j];
            String definitionTableName = verifyTableDefinition.getTableName();
            isExpectedTableFound = expectedTableName.equals(definitionTableName);
        }
        return isExpectedTableFound;
    }

    protected void failOnMismatch(DatabaseConfig config, Set<String> mismatchCountTables) throws DataSetException {
        String methodName = "failOnMismatch";
        boolean allowCountMismatch = (Boolean)config.getProperty("http://www.dbunit.org/properties/allowVerifytabledefinitionExpectedtableCountMismatch");
        String willFailTestWord = allowCountMismatch ? " not" : "";
        this.log.info("{}: Property {} is set to {} so will{} fail test", new Object[]{"failOnMismatch", "http://www.dbunit.org/properties/allowVerifytabledefinitionExpectedtableCountMismatch", allowCountMismatch, willFailTestWord});
        if (!allowCountMismatch) {
            int mismatchCount = mismatchCountTables.size();
            String msg = "The following " + mismatchCount + " expected tables do not have corresponding VerifyTableDefinitions: " + mismatchCountTables + "\nSet property '" + "http://www.dbunit.org/properties/allowVerifytabledefinitionExpectedtableCountMismatch" + "' to true to suppress test fail.";
            throw new DataSetException(msg);
        }
    }
}

