/*
 * Decompiled with CFR 0.152.
 */
package kamon.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;

public class UnifiedMap<K, V>
implements Map<K, V> {
    protected static final Object NULL_KEY = new Object(){

        public boolean equals(Object object) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "UnifiedMap.NULL_KEY";
        }
    };
    protected static final Object CHAINED_KEY = new Object(){

        public boolean equals(Object object) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "UnifiedMap.CHAINED_KEY";
        }
    };
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 1L;
    protected transient Object[] table;
    protected transient int occupied;
    protected float loadFactor = 0.75f;
    protected int maxSize;

    public UnifiedMap() {
        this.allocate(16);
    }

    public UnifiedMap(int n) {
        this(n, 0.75f);
    }

    public UnifiedMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("load factor cannot be less than or equal to 0");
        }
        if ((double)f > 1.0) {
            throw new IllegalArgumentException("load factor cannot be greater than 1");
        }
        this.loadFactor = f;
        this.init(this.fastCeil((float)n / f));
    }

    public UnifiedMap(Map<? extends K, ? extends V> map) {
        this(Math.max(map.size(), 8), 0.75f);
        this.putAll(map);
    }

    public static <K, V> UnifiedMap<K, V> newMap() {
        return new UnifiedMap<K, V>();
    }

    public static <K, V> UnifiedMap<K, V> newMap(int n) {
        return new UnifiedMap<K, V>(n);
    }

    public static <K, V> UnifiedMap<K, V> newMap(int n, float f) {
        return new UnifiedMap<K, V>(n, f);
    }

    public static <K, V> UnifiedMap<K, V> newMap(Map<? extends K, ? extends V> map) {
        return new UnifiedMap<K, V>(map);
    }

    public UnifiedMap<K, V> newEmpty(int n) {
        return new UnifiedMap<K, V>(n, this.loadFactor);
    }

    public static <K, V> UnifiedMap<K, V> newWithKeysValues(K k, V v) {
        return new UnifiedMap<K, V>(2).withKeysValues(k, v);
    }

    public static <K, V> UnifiedMap<K, V> newWithKeysValues(K k, V v, K k2, V v2) {
        return new UnifiedMap<K, V>(2).withKeysValues(k, v, k2, v2);
    }

    public UnifiedMap<K, V> withKeysValues(K k, V v) {
        this.put(k, v);
        return this;
    }

    public UnifiedMap<K, V> withKeysValues(K k, V v, K k2, V v2) {
        this.put(k, v);
        this.put(k2, v2);
        return this;
    }

    private int fastCeil(float f) {
        int n = (int)f;
        if (f - (float)n > 0.0f) {
            ++n;
        }
        return n;
    }

    protected int init(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return this.allocate(n2);
    }

    protected int allocate(int n) {
        this.allocateTable(n << 1);
        this.computeMaxSize(n);
        return n;
    }

    protected void allocateTable(int n) {
        this.table = new Object[n];
    }

    protected void computeMaxSize(int n) {
        this.maxSize = Math.min(n - 1, (int)((float)n * this.loadFactor));
    }

    protected int index(Object object) {
        int n = object == null ? 0 : object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        n ^= n >>> 7 ^ n >>> 4;
        return (n & (this.table.length >> 1) - 1) << 1;
    }

    @Override
    public void clear() {
        if (this.occupied == 0) {
            return;
        }
        this.occupied = 0;
        Object[] objectArray = this.table;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
        }
    }

    @Override
    public V put(K k, V v) {
        int n = this.index(k);
        Object object = this.table[n];
        if (object == null) {
            this.table[n] = UnifiedMap.toSentinelIfNull(k);
            this.table[n + 1] = v;
            if (++this.occupied > this.maxSize) {
                this.rehash(this.table.length);
            }
            return null;
        }
        if (object != CHAINED_KEY && this.nonNullTableObjectEquals(object, k)) {
            Object object2 = this.table[n + 1];
            this.table[n + 1] = v;
            return (V)object2;
        }
        return this.chainedPut(k, n, v);
    }

    private V chainedPut(K k, int n, V v) {
        if (this.table[n] == CHAINED_KEY) {
            Object[] objectArray = (Object[])this.table[n + 1];
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] == null) {
                    objectArray[i] = UnifiedMap.toSentinelIfNull(k);
                    objectArray[i + 1] = v;
                    if (++this.occupied > this.maxSize) {
                        this.rehash(this.table.length);
                    }
                    return null;
                }
                if (!this.nonNullTableObjectEquals(objectArray[i], k)) continue;
                Object object = objectArray[i + 1];
                objectArray[i + 1] = v;
                return (V)object;
            }
            Object[] objectArray2 = new Object[objectArray.length + 4];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            this.table[n + 1] = objectArray2;
            objectArray2[objectArray.length] = UnifiedMap.toSentinelIfNull(k);
            objectArray2[objectArray.length + 1] = v;
            if (++this.occupied > this.maxSize) {
                this.rehash(this.table.length);
            }
            return null;
        }
        Object[] objectArray = new Object[]{this.table[n], this.table[n + 1], UnifiedMap.toSentinelIfNull(k), v};
        this.table[n] = CHAINED_KEY;
        this.table[n + 1] = objectArray;
        if (++this.occupied > this.maxSize) {
            this.rehash(this.table.length);
        }
        return null;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        Object[] objectArray = this.table;
        this.allocate(n);
        this.occupied = 0;
        for (int i = 0; i < n2; i += 2) {
            Object object = objectArray[i];
            if (object == CHAINED_KEY) {
                Object[] objectArray2 = (Object[])objectArray[i + 1];
                for (int j = 0; j < objectArray2.length; j += 2) {
                    if (objectArray2[j] == null) continue;
                    this.put(this.nonSentinel(objectArray2[j]), objectArray2[j + 1]);
                }
                continue;
            }
            if (object == null) continue;
            this.put(this.nonSentinel(object), objectArray[i + 1]);
        }
    }

    @Override
    public V get(Object object) {
        int n = this.index(object);
        Object object2 = this.table[n];
        if (object2 != null) {
            Object object3 = this.table[n + 1];
            if (object2 == CHAINED_KEY) {
                return this.getFromChain((Object[])object3, object);
            }
            if (this.nonNullTableObjectEquals(object2, object)) {
                return (V)object3;
            }
        }
        return null;
    }

    private V getFromChain(Object[] objectArray, K k) {
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return null;
            }
            if (!this.nonNullTableObjectEquals(object, k)) continue;
            return (V)objectArray[i + 1];
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.index(object);
        Object object2 = this.table[n];
        if (object2 == null) {
            return false;
        }
        if (object2 != CHAINED_KEY && this.nonNullTableObjectEquals(object2, object)) {
            return true;
        }
        return object2 == CHAINED_KEY && this.chainContainsKey((Object[])this.table[n + 1], object);
    }

    private boolean chainContainsKey(Object[] objectArray, K k) {
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return false;
            }
            if (!this.nonNullTableObjectEquals(object, k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = 0; i < this.table.length; i += 2) {
            if (!(this.table[i] == CHAINED_KEY ? this.chainedContainsValue((Object[])this.table[i + 1], object) : this.table[i] != null && UnifiedMap.nullSafeEquals(object, this.table[i + 1]))) continue;
            return true;
        }
        return false;
    }

    private boolean chainedContainsValue(Object[] objectArray, V v) {
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] == null) {
                return false;
            }
            if (!UnifiedMap.nullSafeEquals(v, objectArray[i + 1])) continue;
            return true;
        }
        return false;
    }

    public void forEachKeyValue(BiConsumer<? super K, ? super V> biConsumer) {
        for (int i = 0; i < this.table.length; i += 2) {
            Object object = this.table[i];
            if (object == CHAINED_KEY) {
                this.chainedForEachEntry((Object[])this.table[i + 1], biConsumer);
                continue;
            }
            if (object == null) continue;
            biConsumer.accept(this.nonSentinel(object), this.table[i + 1]);
        }
    }

    public V getFirst() {
        for (int i = 0; i < this.table.length; i += 2) {
            Object object = this.table[i];
            if (object == CHAINED_KEY) {
                Object[] objectArray = (Object[])this.table[i + 1];
                return (V)objectArray[1];
            }
            if (object == null) continue;
            return (V)this.table[i + 1];
        }
        return null;
    }

    private void chainedForEachEntry(Object[] objectArray, BiConsumer<? super K, ? super V> biConsumer) {
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return;
            }
            biConsumer.accept(this.nonSentinel(object), objectArray[i + 1]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.occupied == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map instanceof UnifiedMap) {
            this.copyMap((UnifiedMap)map);
        } else {
            for (Map.Entry<K, V> entry : this.getEntrySetFrom(map)) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private Set<? extends Map.Entry<? extends K, ? extends V>> getEntrySetFrom(Map<? extends K, ? extends V> map) {
        Set<Map.Entry<? extends K, ? extends V>> set = map.entrySet();
        if (set != null) {
            return set;
        }
        if (map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        throw new IllegalStateException("Entry set was null and size was non-zero");
    }

    protected void copyMap(UnifiedMap<K, V> unifiedMap) {
        for (int i = 0; i < unifiedMap.table.length; i += 2) {
            Object object = unifiedMap.table[i];
            if (object == CHAINED_KEY) {
                this.copyChain((Object[])unifiedMap.table[i + 1]);
                continue;
            }
            if (object == null) continue;
            this.put(this.nonSentinel(object), unifiedMap.table[i + 1]);
        }
    }

    private void copyChain(Object[] objectArray) {
        Object object;
        for (int i = 0; i < objectArray.length && (object = objectArray[i]) != null; i += 2) {
            this.put(this.nonSentinel(object), objectArray[i + 1]);
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.index(object);
        Object object2 = this.table[n];
        if (object2 != null) {
            Object object3 = this.table[n + 1];
            if (object2 == CHAINED_KEY) {
                return this.removeFromChain((Object[])object3, object, n);
            }
            if (this.nonNullTableObjectEquals(object2, object)) {
                this.table[n] = null;
                this.table[n + 1] = null;
                --this.occupied;
                return (V)object3;
            }
        }
        return null;
    }

    private V removeFromChain(Object[] objectArray, K k, int n) {
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return null;
            }
            if (!this.nonNullTableObjectEquals(object, k)) continue;
            Object object2 = objectArray[i + 1];
            this.overwriteWithLastElementFromChain(objectArray, n, i);
            return (V)object2;
        }
        return null;
    }

    private void overwriteWithLastElementFromChain(Object[] objectArray, int n, int n2) {
        int n3;
        for (n3 = objectArray.length - 2; n3 > n2; n3 -= 2) {
            if (objectArray[n3] == null) continue;
            objectArray[n2] = objectArray[n3];
            objectArray[n2 + 1] = objectArray[n3 + 1];
            break;
        }
        objectArray[n3] = null;
        objectArray[n3 + 1] = null;
        if (n3 == 0) {
            this.table[n] = null;
            this.table[n + 1] = null;
        }
        --this.occupied;
    }

    @Override
    public int size() {
        return this.occupied;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (int i = 0; i < this.table.length; i += 2) {
            Object object2 = this.table[i];
            if (object2 == CHAINED_KEY) {
                if (this.chainedEquals((Object[])this.table[i + 1], map)) continue;
                return false;
            }
            if (object2 == null) continue;
            K k = this.nonSentinel(object2);
            Object object3 = this.table[i + 1];
            Object v = map.get(k);
            if (UnifiedMap.nullSafeEquals(v, object3) && (object3 != null || v != null || map.containsKey(k))) continue;
            return false;
        }
        return true;
    }

    private boolean chainedEquals(Object[] objectArray, Map<?, ?> map) {
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return true;
            }
            K k = this.nonSentinel(object);
            Object object2 = objectArray[i + 1];
            Object obj = map.get(k);
            if (UnifiedMap.nullSafeEquals(obj, object2) && (object2 != null || obj != null || map.containsKey(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.table.length; i += 2) {
            Object object = this.table[i];
            if (object == CHAINED_KEY) {
                n += this.chainedHashCode((Object[])this.table[i + 1]);
                continue;
            }
            if (object == null) continue;
            Object object2 = this.table[i + 1];
            n += (object == NULL_KEY ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    private int chainedHashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) {
                return n;
            }
            Object object2 = objectArray[i + 1];
            n += (object == NULL_KEY ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        this.forEachKeyValue(new BiConsumer<K, V>(){
            private boolean first = true;

            @Override
            public void accept(K k, V v) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((Object)(k == UnifiedMap.this ? "(this Map)" : k));
                stringBuilder.append('=');
                stringBuilder.append((Object)(v == UnifiedMap.this ? "(this Map)" : v));
            }
        });
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static boolean nullSafeEquals(Object object, Object object2) {
        return object == null ? object2 == null : object2 == object || object.equals(object2);
    }

    private K nonSentinel(Object object) {
        return (K)(object == NULL_KEY ? null : object);
    }

    private static Object toSentinelIfNull(Object object) {
        if (object == null) {
            return NULL_KEY;
        }
        return object;
    }

    private boolean nonNullTableObjectEquals(Object object, K k) {
        return object == k || (object == NULL_KEY ? k == null : object.equals(k));
    }

    protected class ValuesIterator
    extends PositionalIterator<V> {
        protected ValuesIterator() {
        }

        protected V nextFromChain() {
            Object[] objectArray = (Object[])UnifiedMap.this.table[this.position + 1];
            Object object = objectArray[this.chainPosition + 1];
            this.chainPosition += 2;
            if (this.chainPosition >= objectArray.length || objectArray[this.chainPosition] == null) {
                this.chainPosition = 0;
                this.position += 2;
            }
            this.lastReturned = true;
            return object;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            Object[] objectArray = UnifiedMap.this.table;
            if (this.chainPosition != 0) {
                return this.nextFromChain();
            }
            while (objectArray[this.position] == null) {
                this.position += 2;
            }
            Object object = objectArray[this.position];
            Object object2 = objectArray[this.position + 1];
            if (object == CHAINED_KEY) {
                return this.nextFromChain();
            }
            this.position += 2;
            this.lastReturned = true;
            return object2;
        }
    }

    protected class ValuesCollection
    implements Collection<V> {
        private static final long serialVersionUID = 1L;

        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            UnifiedMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return UnifiedMap.this.containsValue(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Cannot call containsAll on ValuesCollection");
        }

        @Override
        public boolean isEmpty() {
            return UnifiedMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    iterator.remove();
                    return true;
                }
            } else {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    if (object != v && !v.equals(object)) continue;
                    iterator.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return UnifiedMap.this.size();
        }

        protected void copyValues(Object[] objectArray) {
            int n = 0;
            for (int i = 0; i < UnifiedMap.this.table.length; i += 2) {
                Object object = UnifiedMap.this.table[i];
                if (object == null) continue;
                if (object == CHAINED_KEY) {
                    Object object2;
                    Object[] objectArray2 = (Object[])UnifiedMap.this.table[i + 1];
                    for (int j = 0; j < objectArray2.length && (object2 = objectArray2[j]) != null; j += 2) {
                        objectArray[n++] = objectArray2[j + 1];
                    }
                    continue;
                }
                objectArray[n++] = UnifiedMap.this.table[i + 1];
            }
        }

        @Override
        public Object[] toArray() {
            int n = UnifiedMap.this.size();
            Object[] objectArray = new Object[n];
            this.copyValues(objectArray);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = UnifiedMap.this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            this.copyValues(objectArray);
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }
    }

    protected static class WeakBoundEntry<K, V>
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;
        protected final WeakReference<UnifiedMap<K, V>> holder;

        protected WeakBoundEntry(K k, V v, WeakReference<UnifiedMap<K, V>> weakReference) {
            this.key = k;
            this.value = v;
            this.holder = weakReference;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            this.value = v;
            UnifiedMap unifiedMap = (UnifiedMap)this.holder.get();
            if (unifiedMap != null && unifiedMap.containsKey(this.key)) {
                return unifiedMap.put(this.key, v);
            }
            return null;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return UnifiedMap.nullSafeEquals(this.key, k) && UnifiedMap.nullSafeEquals(this.value, v);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    protected class EntrySetIterator
    extends PositionalIterator<Map.Entry<K, V>> {
        private final WeakReference<UnifiedMap<K, V>> holder;

        protected EntrySetIterator(WeakReference<UnifiedMap<K, V>> weakReference) {
            this.holder = weakReference;
        }

        protected Map.Entry<K, V> nextFromChain() {
            Object[] objectArray = (Object[])UnifiedMap.this.table[this.position + 1];
            Object object = objectArray[this.chainPosition];
            Object object2 = objectArray[this.chainPosition + 1];
            this.chainPosition += 2;
            if (this.chainPosition >= objectArray.length || objectArray[this.chainPosition] == null) {
                this.chainPosition = 0;
                this.position += 2;
            }
            this.lastReturned = true;
            return new WeakBoundEntry<Object, Object>(UnifiedMap.this.nonSentinel(object), object2, this.holder);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            Object[] objectArray = UnifiedMap.this.table;
            if (this.chainPosition != 0) {
                return this.nextFromChain();
            }
            while (objectArray[this.position] == null) {
                this.position += 2;
            }
            Object object = objectArray[this.position];
            Object object2 = objectArray[this.position + 1];
            if (object == CHAINED_KEY) {
                return this.nextFromChain();
            }
            this.position += 2;
            this.lastReturned = true;
            return new WeakBoundEntry<Object, Object>(UnifiedMap.this.nonSentinel(object), object2, this.holder);
        }
    }

    protected class EntrySet
    implements Set<Map.Entry<K, V>> {
        private static final long serialVersionUID = 1L;
        private transient WeakReference<UnifiedMap<K, V>> holder;

        protected EntrySet() {
            this.holder = new WeakReference<UnifiedMap>(UnifiedMap.this);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            UnifiedMap.this.clear();
        }

        public boolean containsEntry(Map.Entry<?, ?> entry) {
            return this.getEntry(entry) != null;
        }

        private Map.Entry<K, V> getEntry(Map.Entry<?, ?> entry) {
            Object obj = entry.getKey();
            Object obj2 = entry.getValue();
            int n = UnifiedMap.this.index(obj);
            Object object = UnifiedMap.this.table[n];
            Object object2 = UnifiedMap.this.table[n + 1];
            if (object == CHAINED_KEY) {
                return this.chainGetEntry((Object[])object2, obj, obj2);
            }
            if (object == null) {
                return null;
            }
            if (UnifiedMap.this.nonNullTableObjectEquals(object, obj) && UnifiedMap.nullSafeEquals(obj2, object2)) {
                return new ImmutableEntry(UnifiedMap.this.nonSentinel(object), object2);
            }
            return null;
        }

        private Map.Entry<K, V> chainGetEntry(Object[] objectArray, K k, V v) {
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object;
                Object object2 = objectArray[i];
                if (object2 == null) {
                    return null;
                }
                if (!UnifiedMap.this.nonNullTableObjectEquals(object2, k) || !UnifiedMap.nullSafeEquals(v, object = objectArray[i + 1])) continue;
                return new ImmutableEntry(UnifiedMap.this.nonSentinel(object2), object);
            }
            return null;
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Map.Entry && this.containsEntry((Map.Entry)object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return UnifiedMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.holder);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            int n = UnifiedMap.this.index(k);
            Object object2 = UnifiedMap.this.table[n];
            if (object2 != null) {
                Object object3 = UnifiedMap.this.table[n + 1];
                if (object2 == CHAINED_KEY) {
                    return this.removeFromChain((Object[])object3, k, v, n);
                }
                if (UnifiedMap.this.nonNullTableObjectEquals(object2, k) && UnifiedMap.nullSafeEquals(v, object3)) {
                    UnifiedMap.this.table[n] = null;
                    UnifiedMap.this.table[n + 1] = null;
                    --UnifiedMap.this.occupied;
                    return true;
                }
            }
            return false;
        }

        private boolean removeFromChain(Object[] objectArray, K k, V v, int n) {
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object;
                Object object2 = objectArray[i];
                if (object2 == null) {
                    return false;
                }
                if (!UnifiedMap.this.nonNullTableObjectEquals(object2, k) || !UnifiedMap.nullSafeEquals(object = objectArray[i + 1], v)) continue;
                UnifiedMap.this.overwriteWithLastElementFromChain(objectArray, n, i);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int n = collection.size();
            UnifiedMap unifiedMap = UnifiedMap.this.newEmpty(n);
            for (Object obj : collection) {
                Map.Entry entry;
                Map.Entry entry2;
                if (!(obj instanceof Map.Entry) || (entry2 = this.getEntry(entry = (Map.Entry)obj)) == null) continue;
                unifiedMap.put(entry2.getKey(), entry2.getValue());
            }
            if (unifiedMap.size() < this.size()) {
                UnifiedMap.this.maxSize = unifiedMap.maxSize;
                UnifiedMap.this.occupied = unifiedMap.occupied;
                UnifiedMap.this.table = unifiedMap.table;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return UnifiedMap.this.size();
        }

        protected void copyEntries(Object[] objectArray) {
            Object[] objectArray2 = UnifiedMap.this.table;
            int n = 0;
            for (int i = 0; i < objectArray2.length; i += 2) {
                Object object = objectArray2[i];
                if (object == null) continue;
                if (object == CHAINED_KEY) {
                    Object object2;
                    Object[] objectArray3 = (Object[])objectArray2[i + 1];
                    for (int j = 0; j < objectArray3.length && (object2 = objectArray3[j]) != null; j += 2) {
                        objectArray[n++] = new WeakBoundEntry<Object, Object>(UnifiedMap.this.nonSentinel(object2), objectArray3[j + 1], this.holder);
                    }
                    continue;
                }
                objectArray[n++] = new WeakBoundEntry<Object, Object>(UnifiedMap.this.nonSentinel(object), objectArray2[i + 1], this.holder);
            }
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[UnifiedMap.this.size()];
            this.copyEntries(objectArray);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = UnifiedMap.this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            this.copyEntries(objectArray);
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean equals(Object object) {
            Set set;
            if (object instanceof Set && (set = (Set)object).size() == this.size()) {
                return this.containsAll(set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return UnifiedMap.this.hashCode();
        }
    }

    protected final class ImmutableEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        ImmutableEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException("Cannot call setValue() on " + this.getClass().getSimpleName());
        }
    }

    protected class KeySetIterator
    extends PositionalIterator<K> {
        protected KeySetIterator() {
        }

        protected K nextFromChain() {
            Object[] objectArray = (Object[])UnifiedMap.this.table[this.position + 1];
            Object object = objectArray[this.chainPosition];
            this.chainPosition += 2;
            if (this.chainPosition >= objectArray.length || objectArray[this.chainPosition] == null) {
                this.chainPosition = 0;
                this.position += 2;
            }
            this.lastReturned = true;
            return UnifiedMap.this.nonSentinel(object);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            Object[] objectArray = UnifiedMap.this.table;
            if (this.chainPosition != 0) {
                return this.nextFromChain();
            }
            while (objectArray[this.position] == null) {
                this.position += 2;
            }
            Object object = objectArray[this.position];
            if (object == CHAINED_KEY) {
                return this.nextFromChain();
            }
            this.position += 2;
            this.lastReturned = true;
            return UnifiedMap.this.nonSentinel(object);
        }
    }

    protected abstract class PositionalIterator<T>
    implements Iterator<T> {
        protected int count;
        protected int position;
        protected int chainPosition;
        protected boolean lastReturned;

        protected PositionalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < UnifiedMap.this.size();
        }

        @Override
        public void remove() {
            if (!this.lastReturned) {
                throw new IllegalStateException("next() must be called as many times as remove()");
            }
            --this.count;
            --UnifiedMap.this.occupied;
            if (this.chainPosition != 0) {
                this.removeFromChain();
                return;
            }
            int n = this.position - 2;
            Object object = UnifiedMap.this.table[n];
            if (object == CHAINED_KEY) {
                this.removeLastFromChain((Object[])UnifiedMap.this.table[n + 1], n);
                return;
            }
            UnifiedMap.this.table[n] = null;
            UnifiedMap.this.table[n + 1] = null;
            this.position = n;
            this.lastReturned = false;
        }

        protected void removeFromChain() {
            int n;
            Object[] objectArray = (Object[])UnifiedMap.this.table[this.position + 1];
            int n2 = this.chainPosition - 2;
            for (n = this.chainPosition; n < objectArray.length - 2 && objectArray[n + 2] != null; n += 2) {
            }
            objectArray[n2] = objectArray[n];
            objectArray[n2 + 1] = objectArray[n + 1];
            objectArray[n] = null;
            objectArray[n + 1] = null;
            this.chainPosition = n2;
            this.lastReturned = false;
        }

        protected void removeLastFromChain(Object[] objectArray, int n) {
            int n2 = objectArray.length - 2;
            while (objectArray[n2] == null) {
                n2 -= 2;
            }
            if (n2 == 0) {
                UnifiedMap.this.table[n] = null;
                UnifiedMap.this.table[n + 1] = null;
            } else {
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
            }
            this.lastReturned = false;
        }
    }

    protected class KeySet
    implements Set<K> {
        private static final long serialVersionUID = 1L;

        protected KeySet() {
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            UnifiedMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return UnifiedMap.this.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (UnifiedMap.this.containsKey(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return UnifiedMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean remove(Object object) {
            int n = UnifiedMap.this.occupied;
            UnifiedMap.this.remove(object);
            return UnifiedMap.this.occupied != n;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int n = UnifiedMap.this.occupied;
            for (Object obj : collection) {
                UnifiedMap.this.remove(obj);
            }
            return n != UnifiedMap.this.occupied;
        }

        public void putIfFound(Object object, Map<K, V> map) {
            int n = UnifiedMap.this.index(object);
            Object object2 = UnifiedMap.this.table[n];
            if (object2 != null) {
                Object object3 = UnifiedMap.this.table[n + 1];
                if (object2 == CHAINED_KEY) {
                    this.putIfFoundFromChain((Object[])object3, object, map);
                    return;
                }
                if (UnifiedMap.this.nonNullTableObjectEquals(object2, object)) {
                    map.put(UnifiedMap.this.nonSentinel(object2), object3);
                }
            }
        }

        private void putIfFoundFromChain(Object[] objectArray, K k, Map<K, V> map) {
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (object == null) {
                    return;
                }
                if (!UnifiedMap.this.nonNullTableObjectEquals(object, k)) continue;
                map.put(UnifiedMap.this.nonSentinel(object), objectArray[i + 1]);
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int n = collection.size();
            UnifiedMap unifiedMap = UnifiedMap.this.newEmpty(n);
            for (Object obj : collection) {
                this.putIfFound(obj, unifiedMap);
            }
            if (unifiedMap.size() < this.size()) {
                UnifiedMap.this.maxSize = unifiedMap.maxSize;
                UnifiedMap.this.occupied = unifiedMap.occupied;
                UnifiedMap.this.table = unifiedMap.table;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return UnifiedMap.this.size();
        }

        protected void copyKeys(Object[] objectArray) {
            Object[] objectArray2 = UnifiedMap.this.table;
            int n = 0;
            for (int i = 0; i < objectArray2.length; i += 2) {
                Object object = objectArray2[i];
                if (object == null) continue;
                if (object == CHAINED_KEY) {
                    Object object2;
                    Object[] objectArray3 = (Object[])objectArray2[i + 1];
                    for (int j = 0; j < objectArray3.length && (object2 = objectArray3[j]) != null; j += 2) {
                        objectArray[n++] = UnifiedMap.this.nonSentinel(object2);
                    }
                    continue;
                }
                objectArray[n++] = UnifiedMap.this.nonSentinel(object);
            }
        }

        @Override
        public boolean equals(Object object) {
            Set set;
            if (object instanceof Set && (set = (Set)object).size() == this.size()) {
                return this.containsAll(set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = 0;
            Object[] objectArray = UnifiedMap.this.table;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (object == null) continue;
                if (object == CHAINED_KEY) {
                    Object object2;
                    Object[] objectArray2 = (Object[])objectArray[i + 1];
                    for (int j = 0; j < objectArray2.length && (object2 = objectArray2[j]) != null; j += 2) {
                        n += object2 == NULL_KEY ? 0 : object2.hashCode();
                    }
                    continue;
                }
                n += object == NULL_KEY ? 0 : object.hashCode();
            }
            return n;
        }

        @Override
        public Object[] toArray() {
            int n = UnifiedMap.this.size();
            Object[] objectArray = new Object[n];
            this.copyKeys(objectArray);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = UnifiedMap.this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            this.copyKeys(objectArray);
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }
    }
}

