/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.nimbusds.jose.jwk.JWK;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002,X\u0001\u0011D\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005i\")!\u0010\u0001C\u0001w\"I\u0011\u0011\u0001\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011\u0011\u0005\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011\u0011\u0007\u0001A\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003g\u0001\u0001\u0019!C\u0001\u0003kA\u0001\"!\u0011\u0001A\u0003&\u0011Q\u0001\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u0007A\u0011\"!\u0012\u0001\u0001\u0004%\t!a\u0012\t\u0011\u0005-\u0003\u0001)Q\u0005\u0003\u000bA\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0001\t\u0013\u0005=\u0003\u00011A\u0005\u0002\u0005E\u0003\u0002CA+\u0001\u0001\u0006K!!\u0002\t\u0013\u0005]\u0003A1A\u0005\u0002\u0005\r\u0001\u0002CA-\u0001\u0001\u0006I!!\u0002\t\u0013\u0005m\u0003A1A\u0005\u0002\u0005\r\u0001\u0002CA/\u0001\u0001\u0006I!!\u0002\t\u0013\u0005}\u0003A1A\u0005\u0002\u0005\r\u0001\u0002CA1\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\r\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA3\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA5\u0001\u0001\u0006I!!\u0002\t\u0013\u0005-\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA7\u0001\u0001\u0006I!!\u0002\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA9\u0001\u0001\u0006I!!\u0002\t\u0013\u0005M\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA;\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA=\u0001\u0001\u0006I!!\u0002\t\u0013\u0005m\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CA?\u0001\u0001\u0006I!!\u0002\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\r\u0001\u0002CAA\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005\r\u0001\u0002CAC\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005\r\u0001\u0002CAE\u0001\u0001\u0006I!!\u0002\t\u0013\u0005-\u0005A1A\u0005\u0002\u0005\r\u0001\u0002CAG\u0001\u0001\u0006I!!\u0002\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005E\u0005\u0002CAX\u0001\u0001\u0006I!a%\t\u0013\u0005E\u0006A1A\u0005\u0002\u0005\r\u0001\u0002CAZ\u0001\u0001\u0006I!!\u0002\t\u0013\u0005U\u0006A1A\u0005\u0002\u0005\r\u0001\u0002CA\\\u0001\u0001\u0006I!!\u0002\t\u0013\u0005e\u0006A1A\u0005\u0002\u0005\r\u0001\u0002CA^\u0001\u0001\u0006I!!\u0002\t\u0013\u0005u\u0006A1A\u0005\u0002\u0005\r\u0001\u0002CA`\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u0005\u0007A1A\u0005\u0002\u0005\r\u0001\u0002CAb\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005\r\u0001\u0002CAd\u0001\u0001\u0006I!!\u0002\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005\r\u0001\u0002CAf\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0007A1A\u0005\u0002\u0005\r\u0001\u0002CAh\u0001\u0001\u0006I!!\u0002\t\u0013\u0005E\u0007\u00011A\u0005\u0002\u0005M\u0007\"CAn\u0001\u0001\u0007I\u0011AAo\u0011!\t\t\u000f\u0001Q!\n\u0005U\u0007bCAr\u0001\u0001\u0007\t\u0019!C\u0001\u0003KD1\"!?\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002|\"Y\u0011q \u0001A\u0002\u0003\u0005\u000b\u0015BAt\u0011%\u0011\t\u0001\u0001a\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\f\u0001\u0001\r\u0011\"\u0001\u0003\u000e!A!\u0011\u0003\u0001!B\u0013\u0011)\u0001C\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003$!9!1\u0006\u0001\u0005\n\t5\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013\u0012!bT5eG\u000e{gNZ5h\u0015\tA\u0016,\u0001\u0003d_:4'B\u0001.\\\u0003\u0011y\u0017\u000eZ2\u000b\u0005qk\u0016AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003=~\u000b\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003A\u0006\f\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\t\f1aY8n\u0007\u0001\u0019\"\u0001A3\u0011\u0005\u0019LW\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOB\u0011Q.]\u0007\u0002]*\u00111n\u001c\u0006\u0003a\u0006\f\u0001\u0002^=qKN\fg-Z\u0005\u0003e:\u0014aaQ8oM&<\u0017aE:feZ,'oQ8oM&<WO]1uS>t\u0007CA;y\u001b\u00051(BA<`\u0003!!W\r\u001d7ps&$\u0018BA=w\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019AP`@\u0011\u0005u\u0004Q\"A,\t\u000b-\u001c\u0001\u0019\u00017\t\u000bM\u001c\u0001\u0019\u0001;\u0002\u001dI,w-[:ue\u0006$\u0018n\u001c8JIV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005E\u0001cAA\u0006O6\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0019\u0017A\u0002\u001fs_>$h(C\u0002\u0002\u0014\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\nO\u0006y!/Z4jgR\u0014\u0018\r^5p]&#\u0007%\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0007dY&,g\u000e^*fGJ,G/A\u0007dY&,g\u000e^*fGJ,G\u000fI\u0001\u0011G2LWM\u001c;BkRDW*\u001a;i_\u0012\f\u0011c\u00197jK:$\u0018)\u001e;i\u001b\u0016$\bn\u001c3!\u0003A\u0019G.[3oi\u0006+H\u000f\u001b&X'\u0006cw-A\tdY&,g\u000e^!vi\"TukU!mO\u0002\n!\u0002^8lK:\\U-_%e\u0003-!xn[3o\u0017\u0016L\u0018\n\u001a\u0011\u0002\u0019-,\u0017p\u0015;pe\u0016\u0004\u0016\r\u001e5\u0002!-,\u0017p\u0015;pe\u0016\u0004\u0016\r\u001e5`I\u0015\fH\u0003BA\u001c\u0003{\u00012AZA\u001d\u0013\r\tYd\u001a\u0002\u0005+:LG\u000fC\u0005\u0002@E\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\u001b-,\u0017p\u0015;pe\u0016\u0004\u0016\r\u001e5!\u0003AYW-_*u_J,\u0007+Y:to>\u0014H-\u0001\u000blKf\u001cFo\u001c:f!\u0006\u001c8o^8sI~#S-\u001d\u000b\u0005\u0003o\tI\u0005C\u0005\u0002@Q\t\t\u00111\u0001\u0002\u0006\u0005\t2.Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\u0002!-,\u0017p\u0015;pe\u0016$\u0016\u0010]3`I\u0015\fH\u0003BA\u001c\u0003'B\u0011\"a\u0010\u0018\u0003\u0003\u0005\r!!\u0002\u0002\u001b-,\u0017p\u0015;pe\u0016$\u0016\u0010]3!\u0003!YW-_!mS\u0006\u001c\u0018!C6fs\u0006c\u0017.Y:!\u0003-YW-\u001f)bgN<xN\u001d3\u0002\u0019-,\u0017\u0010U1tg^|'\u000f\u001a\u0011\u0002'\u0011,g-Y;mi.+\u0017p\u0015;pe\u0016\u0004\u0016\r\u001e5\u0002)\u0011,g-Y;mi.+\u0017p\u0015;pe\u0016\u0004\u0016\r\u001e5!\u0003]!WMZ1vYR\\U-_*u_J,\u0007+Y:to>\u0014H-\u0001\reK\u001a\fW\u000f\u001c;LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0002\na![:tk\u0016\u0014\u0018aB5tgV,'\u000fI\u0001\tU^\\7oX;sS\u0006I!n^6t?V\u0014\u0018\u000eI\u0001\u000fC\u000e\u001cWm]:U_.,g.\u0016:j\u0003=\t7mY3tgR{7.\u001a8Ve&\u0004\u0013\u0001F;tKJ\fU\u000f\u001e5pe&T\u0018\r^5p]V\u0013\u0018.A\u000bvg\u0016\u0014\u0018)\u001e;i_JL'0\u0019;j_:,&/\u001b\u0011\u0002\u00131|wm\\;u+JL\u0017A\u00037pO>,H/\u0016:jA\u0005Y!/\u001a3je\u0016\u001cG/\u0016:j\u00031\u0011X\rZ5sK\u000e$XK]5!\u0003U\u0001xn\u001d;M_\u001e|W\u000f\u001e*fI&\u0014Xm\u0019;Ve&\fa\u0003]8ti2{wm\\;u%\u0016$\u0017N]3diV\u0013\u0018\u000eI\u0001\u000fe>dWm]\"mC&lg*Y7f\u0003=\u0011x\u000e\\3t\u00072\f\u0017.\u001c(b[\u0016\u0004\u0013!E;tKJt\u0015-\\3DY\u0006LWNT1nK\u0006\u0011Ro]3s\u001d\u0006lWm\u00117bS6t\u0015-\\3!\u00035IG\rV8lK:TukU!mO\u0006q\u0011\u000e\u001a+pW\u0016t'jV*BY\u001e\u0004\u0013\u0001F1eI&$\u0018n\u001c8bYB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002\u0014BA\u0011QSAP\u0003\u000b\t\u0019+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011)H/\u001b7\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!!)\u0002\u0018\n\u0019Q*\u00199\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OSA!!+\u0002\u001c\u0006!A.\u00198h\u0013\u0011\ti+a*\u0003\r=\u0013'.Z2u\u0003U\tG\rZ5uS>t\u0017\r\u001c)be\u0006lW\r^3sg\u0002\n\u0011#Y2dKN\u001cHk\\6f]&\u001b8/^3s\u0003I\t7mY3tgR{7.\u001a8JgN,XM\u001d\u0011\u0002'\u0005\u001c7-Z:t)>\\WM\\!vI&,gnY3\u0002)\u0005\u001c7-Z:t)>\\WM\\!vI&,gnY3!\u0003E\t7mY3tgR{7.\u001a8LKf,&/[\u0001\u0013C\u000e\u001cWm]:U_.,gnS3z+JL\u0007%A\tbG\u000e,7o\u001d+pW\u0016t'jV*BY\u001e\f!#Y2dKN\u001cHk\\6f]*;6+\u00117hA\u0005!\u0012mY2fgN$vn[3o'\u0016\u001c'/\u001a;LKf\fQ#Y2dKN\u001cHk\\6f]N+7M]3u\u0017\u0016L\b%\u0001\bfqR,'O\\1m?2|w-\u001b8\u0002\u001f\u0015DH/\u001a:oC2|Fn\\4j]\u0002\na\u0003\\8hS:lU\r\u001e5pI\u0012+7o\u0019:jaRLwN\\\u0001\u0018Y><\u0017N\\'fi\"|G\rR3tGJL\u0007\u000f^5p]\u0002\n\u0011\u0002\u001d:pqfDun\u001d;\u0002\u0015A\u0014x\u000e_=I_N$\b%A\u0005qe>D\u0018\u0010U8siV\u0011\u0011Q\u001b\t\u0005\u0003K\u000b9.\u0003\u0003\u0002Z\u0006\u001d&aB%oi\u0016<WM]\u0001\u000eaJ|\u00070\u001f)peR|F%Z9\u0015\t\u0005]\u0012q\u001c\u0005\n\u0003\u007fA\u0015\u0011!a\u0001\u0003+\f!\u0002\u001d:pqf\u0004vN\u001d;!\u0003\rQwo[\u000b\u0003\u0003O\u0004B!!;\u0002v6\u0011\u00111\u001e\u0006\u0005\u0003G\fiO\u0003\u0003\u0002p\u0006E\u0018\u0001\u00026pg\u0016T1!a=b\u0003!q\u0017.\u001c2vg\u0012\u001c\u0018\u0002BA|\u0003W\u00141AS,L\u0003\u001dQwo[0%KF$B!a\u000e\u0002~\"I\u0011qH&\u0002\u0002\u0003\u0007\u0011q]\u0001\u0005U^\\\u0007%\u0001\u0004tG>\u0004Xm]\u000b\u0003\u0005\u000b\u0001b!!&\u0003\b\u0005\u0015\u0011\u0002\u0002B\u0005\u0003/\u0013A\u0001T5ti\u0006Q1oY8qKN|F%Z9\u0015\t\u0005]\"q\u0002\u0005\n\u0003\u007fq\u0015\u0011!a\u0001\u0005\u000b\tqa]2pa\u0016\u001c\b%A\thKR\u001cFO]5oOB\u0013x\u000e]3sif$\u0002\"!\u0002\u0003\u0018\te!Q\u0004\u0005\u0006WB\u0003\r\u0001\u001c\u0005\b\u00057\u0001\u0006\u0019AA\u0003\u0003\u0011q\u0017-\\3\t\u000f\t}\u0001\u000b1\u0001\u0002\u0006\u0005aA-\u001a4bk2$h+\u00197vK\u0006qq-\u001a;J]R\u0004&o\u001c9feRLH\u0003CAk\u0005K\u00119C!\u000b\t\u000b-\f\u0006\u0019\u00017\t\u000f\tm\u0011\u000b1\u0001\u0002\u0006!9!qD)A\u0002\u0005U\u0017aE4fi\u0016s7m\u001c3fIV\u0013\u0018n\u0015;sS:<G\u0003BA\u0003\u0005_AqA!\rS\u0001\u0004\t)!A\u0002ve&\f1cZ3u\t\u0016\u001cw\u000eZ3e+JL7\u000b\u001e:j]\u001e$BAa\u000e\u0003<A!\u0011Q\u0015B\u001d\u0013\u0011\t9\"a*\t\u000f\tE2\u000b1\u0001\u0002\u0006\u0005)r-\u001a;TiJLgn\u001a'jgR\u0004&o\u001c9feRLH\u0003\u0003B\u0003\u0005\u0003\u0012\u0019E!\u0012\t\u000b-$\u0006\u0019\u00017\t\u000f\tmA\u000b1\u0001\u0002\u0006!9!q\u0004+A\u0002\t\u0015\u0011AD4fi6\u000b\u0007\u000f\u0015:pa\u0016\u0014H/\u001f\u000b\t\u0003'\u0013YE!\u0014\u0003P!)1.\u0016a\u0001Y\"9!1D+A\u0002\u0005\u0015\u0001b\u0002B\u0010+\u0002\u0007\u00111\u0013")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String clientAuthJWSAlg;
    private final String tokenKeyId;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private final String keyAlias;
    private final String keyPassword;
    private final String defaultKeyStorePath;
    private final String defaultKeyStorePassword;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final Map<String, Object> additionalParameters;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private JWK jwk;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String clientAuthJWSAlg() {
        return this.clientAuthJWSAlg;
    }

    public String tokenKeyId() {
        return this.tokenKeyId;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public void keyStorePath_$eq(String x$1) {
        this.keyStorePath = x$1;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public void keyStorePassword_$eq(String x$1) {
        this.keyStorePassword = x$1;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public void keyStoreType_$eq(String x$1) {
        this.keyStoreType = x$1;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String defaultKeyStorePath() {
        return this.defaultKeyStorePath;
    }

    public String defaultKeyStorePassword() {
        return this.defaultKeyStorePassword;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public Map<String, Object> additionalParameters() {
        return this.additionalParameters;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public JWK jwk() {
        return this.jwk;
    }

    public void jwk_$eq(JWK x$1) {
        this.jwk = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    private Map<String, Object> getMapProperty(Config config, String name, Map<String, Object> defaultValue) {
        Map map;
        try {
            map = config.getObject(name).unwrapped();
        }
        catch (ConfigException.Missing missing) {
            map = defaultValue;
        }
        return map;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.clientAuthJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg", MacAlgorithm.HS256.getName());
        this.tokenKeyId = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.tokenKeyId", "");
        this.keyStorePath = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path", "");
        this.keyStorePassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.password", "");
        this.keyStoreType = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.type", "");
        this.keyAlias = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.alias", "");
        this.keyPassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.password", "");
        this.defaultKeyStorePath = serverConfiguration.getKeyStorePath();
        this.defaultKeyStorePassword = serverConfiguration.getKeyStorePassword();
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", new StringBuilder(20).append(serverConfiguration.getServerUrl()).append("login/external-login").toString()));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.additionalParameters = this.getMapProperty(config, "deploy.security.auth.providers.oidc.additionalParameters", new HashMap<String, Object>());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

