/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.configuration;

import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.configuration.FactoryCreator;
import com.github.benmanes.caffeine.jcache.expiry.JCacheExpiryPolicy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypesafeConfigurator {
    static final System.Logger logger = System.getLogger(TypesafeConfigurator.class.getName());
    static FactoryCreator factoryCreator = FactoryBuilder::factoryOf;
    static Supplier<Config> configSource = ConfigFactory::load;

    private TypesafeConfigurator() {
    }

    public static Set<String> cacheNames(Config config) {
        return config.hasPath("caffeine.jcache") ? Collections.unmodifiableSet(config.getObject("caffeine.jcache").keySet()) : Collections.emptySet();
    }

    public static <K, V> CaffeineConfiguration<K, V> defaults(Config config) {
        return new Configurator(config, "default").configure();
    }

    public static <K, V> Optional<CaffeineConfiguration<K, V>> from(Config config, String cacheName) {
        CaffeineConfiguration configuration = null;
        try {
            if (config.hasPath("caffeine.jcache." + cacheName)) {
                configuration = new Configurator(config, cacheName).configure();
            }
        }
        catch (ConfigException.BadPath e) {
            logger.log(System.Logger.Level.WARNING, "Failed to load cache configuration", (Throwable)e);
        }
        return Optional.ofNullable(configuration);
    }

    @Inject
    public static void setFactoryCreator(FactoryCreator factoryCreator) {
        TypesafeConfigurator.factoryCreator = Objects.requireNonNull(factoryCreator);
    }

    public static void setConfigSource(Supplier<Config> configSource) {
        TypesafeConfigurator.configSource = Objects.requireNonNull(configSource);
    }

    public static Supplier<Config> configSource() {
        return configSource;
    }

    private static final class Configurator<K, V> {
        final CaffeineConfiguration<K, V> configuration;
        final Config customized;
        final Config merged;
        final Config root;

        Configurator(Config config, String cacheName) {
            this.root = Objects.requireNonNull(config);
            this.configuration = new CaffeineConfiguration();
            this.customized = this.root.getConfig("caffeine.jcache." + cacheName);
            this.merged = this.customized.withFallback((ConfigMergeable)this.root.getConfig("caffeine.jcache.default"));
        }

        CaffeineConfiguration<K, V> configure() {
            this.addKeyValueTypes();
            this.addStoreByValue();
            this.addExecutor();
            this.addScheduler();
            this.addListeners();
            this.addReadThrough();
            this.addWriteThrough();
            this.addMonitoring();
            this.addLazyExpiration();
            this.addEagerExpiration();
            this.addRefresh();
            this.addMaximum();
            return this.configuration;
        }

        private void addKeyValueTypes() {
            try {
                Class<?> keyType = Class.forName(this.merged.getString("key-type"));
                Class<?> valueType = Class.forName(this.merged.getString("value-type"));
                this.configuration.setTypes(keyType, valueType);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        private void addStoreByValue() {
            this.configuration.setStoreByValue(this.merged.getBoolean("store-by-value.enabled"));
            if (this.isSet("store-by-value.strategy")) {
                this.configuration.setCopierFactory(factoryCreator.factoryOf(this.merged.getString("store-by-value.strategy")));
            }
        }

        public void addExecutor() {
            if (this.isSet("executor")) {
                this.configuration.setExecutorFactory(factoryCreator.factoryOf(this.merged.getString("executor")));
            }
        }

        public void addScheduler() {
            if (this.isSet("scheduler")) {
                this.configuration.setSchedulerFactory(factoryCreator.factoryOf(this.merged.getString("scheduler")));
            }
        }

        private void addListeners() {
            for (String path : this.merged.getStringList("listeners")) {
                Config listener = this.root.getConfig(path);
                Factory listenerFactory = factoryCreator.factoryOf(listener.getString("class"));
                Factory filterFactory = null;
                if (listener.hasPath("filter")) {
                    filterFactory = factoryCreator.factoryOf(listener.getString("filter"));
                }
                boolean oldValueRequired = listener.getBoolean("old-value-required");
                boolean synchronous = listener.getBoolean("synchronous");
                this.configuration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration<K, V>)new MutableCacheEntryListenerConfiguration(listenerFactory, filterFactory, oldValueRequired, synchronous));
            }
        }

        private void addReadThrough() {
            this.configuration.setReadThrough(this.merged.getBoolean("read-through.enabled"));
            if (this.isSet("read-through.loader")) {
                this.configuration.setCacheLoaderFactory(factoryCreator.factoryOf(this.merged.getString("read-through.loader")));
            }
        }

        private void addWriteThrough() {
            this.configuration.setWriteThrough(this.merged.getBoolean("write-through.enabled"));
            if (this.isSet("write-through.writer")) {
                this.configuration.setCacheWriterFactory(factoryCreator.factoryOf(this.merged.getString("write-through.writer")));
            }
        }

        private void addMonitoring() {
            this.configuration.setNativeStatisticsEnabled(this.merged.getBoolean("monitoring.native-statistics"));
            this.configuration.setStatisticsEnabled(this.merged.getBoolean("monitoring.statistics"));
            this.configuration.setManagementEnabled(this.merged.getBoolean("monitoring.management"));
        }

        public void addLazyExpiration() {
            Duration creation = this.getDurationFor("policy.lazy-expiration.creation");
            Duration update = this.getDurationFor("policy.lazy-expiration.update");
            Duration access = this.getDurationFor("policy.lazy-expiration.access");
            Objects.requireNonNull(creation, "policy.lazy-expiration.creation may not be null");
            boolean eternal = Objects.equals(creation, Duration.ETERNAL) && Objects.equals(update, Duration.ETERNAL) && Objects.equals(access, Duration.ETERNAL);
            Factory factory = eternal ? EternalExpiryPolicy.factoryOf() : FactoryBuilder.factoryOf((Serializable)new JCacheExpiryPolicy(creation, update, access));
            this.configuration.setExpiryPolicyFactory((Factory<ExpiryPolicy>)factory);
        }

        private @Nullable Duration getDurationFor(String path) {
            if (!this.isSet(path)) {
                return null;
            }
            if (this.merged.getString(path).equalsIgnoreCase("eternal")) {
                return Duration.ETERNAL;
            }
            long millis = this.merged.getDuration(path, TimeUnit.MILLISECONDS);
            return new Duration(TimeUnit.MILLISECONDS, millis);
        }

        public void addEagerExpiration() {
            long nanos;
            if (this.isSet("policy.eager-expiration.after-write")) {
                nanos = this.merged.getDuration("policy.eager-expiration.after-write", TimeUnit.NANOSECONDS);
                this.configuration.setExpireAfterWrite(OptionalLong.of(nanos));
            }
            if (this.isSet("policy.eager-expiration.after-access")) {
                nanos = this.merged.getDuration("policy.eager-expiration.after-access", TimeUnit.NANOSECONDS);
                this.configuration.setExpireAfterAccess(OptionalLong.of(nanos));
            }
            if (this.isSet("policy.eager-expiration.variable")) {
                this.configuration.setExpiryFactory(Optional.of(FactoryBuilder.factoryOf((String)this.merged.getString("policy.eager-expiration.variable"))));
            }
        }

        public void addRefresh() {
            if (this.isSet("policy.refresh.after-write")) {
                long nanos = this.merged.getDuration("policy.refresh.after-write", TimeUnit.NANOSECONDS);
                this.configuration.setRefreshAfterWrite(OptionalLong.of(nanos));
            }
        }

        private void addMaximum() {
            if (this.isSet("policy.maximum.size")) {
                this.configuration.setMaximumSize(OptionalLong.of(this.merged.getLong("policy.maximum.size")));
            }
            if (this.isSet("policy.maximum.weight")) {
                this.configuration.setMaximumWeight(OptionalLong.of(this.merged.getLong("policy.maximum.weight")));
            }
            if (this.isSet("policy.maximum.weigher")) {
                this.configuration.setWeigherFactory(Optional.of(FactoryBuilder.factoryOf((String)this.merged.getString("policy.maximum.weigher"))));
            }
        }

        private boolean isSet(String path) {
            if (!this.merged.hasPath(path)) {
                return false;
            }
            if (this.customized.hasPathOrNull(path)) {
                return !this.customized.getIsNull(path);
            }
            return true;
        }
    }
}

