/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import com.xebialabs.deployit.util.MustacheRenderer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class DefaultLoginFormFilter
extends UsernamePasswordAuthenticationFilter {
    private static final String DEFAULT_LOGIN_URL = "/login";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private final RequestMatcher requiresAuthenticationRequestMatcher;
    private final MustacheRenderer mustacheRenderer;

    public DefaultLoginFormFilter(Map<String, String> settings) {
        this(DEFAULT_LOGIN_URL, settings);
    }

    public DefaultLoginFormFilter(String loginUrl, Map<String, String> settings) {
        this(loginUrl, (Resource)new ClassPathResource("com/xebialabs/platform/sso/oidc/web/modal-layout.mustache"), (Resource)new ClassPathResource("com/xebialabs/platform/sso/oidc/web/login.mustache"), settings);
    }

    public DefaultLoginFormFilter(String loginUrl, Resource layout, Resource content, Map<String, String> settings) {
        this.requiresAuthenticationRequestMatcher = new AntPathRequestMatcher(loginUrl);
        HashMap<String, Resource> partials = new HashMap<String, Resource>();
        partials.put("content", content);
        HashMap<String, String> context = new HashMap<String, String>(settings);
        context.put("loginUrl", loginUrl);
        this.mustacheRenderer = new MustacheRenderer(layout, partials, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws AuthenticationServiceException, IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresAuthenticationRequestMatcher.matches(request)) {
            if (request.getMethod().equals(GET)) {
                this.mustacheRenderer.render(response);
                return;
            }
            if (!request.getMethod().equals(POST)) throw new AuthenticationServiceException("Authentication method must be a POST or GET got: " + request.getMethod());
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

