/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.xebialabs.deployit.repository.sql.DatabaseInfo;
import com.xebialabs.deployit.repository.sql.DatabaseMetaData;
import java.sql.Connection;
import javax.sql.DataSource;

public final class DatabaseInfo$ {
    public static final DatabaseInfo$ MODULE$ = new DatabaseInfo$();

    public DatabaseInfo apply(DataSource ds) {
        DatabaseInfo databaseInfo;
        try (Connection connection = null;){
            try {
                connection = ds.getConnection();
                java.sql.DatabaseMetaData metadata = connection.getMetaData();
                databaseInfo = this.apply(new DatabaseMetaData(metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion()));
            }
            catch (Throwable t) {
                databaseInfo = this.apply(new DatabaseMetaData("Unknown", "Unknown"));
            }
        }
        return databaseInfo;
    }

    public DatabaseInfo apply(DatabaseMetaData metadata) {
        String string = metadata.dbName().toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.contains("db2")) {
            return new DatabaseInfo.Db2(metadata);
        }
        if (string.contains("derby")) {
            return new DatabaseInfo.Derby(metadata);
        }
        if (string.contains("h2")) {
            return new DatabaseInfo.H2(metadata);
        }
        if (string.contains("sql server")) {
            return new DatabaseInfo.MsSqlServer(metadata);
        }
        if (string.contains("mysql")) {
            return new DatabaseInfo.MySql(metadata);
        }
        if (string.contains("oracle")) {
            return new DatabaseInfo.Oracle(metadata);
        }
        if (string.contains("postgresql")) {
            return new DatabaseInfo.PostgreSql(metadata);
        }
        return new DatabaseInfo.Unknown(metadata);
    }

    private DatabaseInfo$() {
    }
}

