/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.t2bus.event.strategy;

import java.lang.reflect.InvocationTargetException;
import nl.javadude.t2bus.EventHandler;
import nl.javadude.t2bus.event.strategy.BaseEventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlerEventHandlerStrategy
extends BaseEventHandlerStrategy {
    private ExceptionHandler exceptionHandler;
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlerEventHandlerStrategy.class);

    public ExceptionHandlerEventHandlerStrategy(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    protected void handleInvocationTargetException(Object event, EventHandler wrapper, InvocationTargetException e) {
        this.handleException(event, wrapper, e);
        super.handleInvocationTargetException(event, wrapper, e);
    }

    private void handleException(Object event, EventHandler wrapper, InvocationTargetException e) {
        try {
            this.exceptionHandler.handle(e.getCause(), event, wrapper.getTarget(), wrapper.getMethod());
        }
        catch (Exception ex) {
            logger.error("Error occurred when handling exception from [{}] with event [{}]", (Object)wrapper.getMethod(), event);
            logger.error("Exception that was being handled: ", e.getCause());
            logger.error("Exception that occurred: ", (Throwable)ex);
        }
    }
}

