/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$ContentLengthParser$;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.model.parser.HeaderParser$;
import akka.http.impl.util.EnhancedString$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.EmptyHeader$;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class HttpHeaderParser$ {
    public static final HttpHeaderParser$ MODULE$ = new HttpHeaderParser$();
    private static final Seq<String> predefinedHeaders = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Accept: *", "Accept: */*", "Connection: Keep-Alive", "Connection: close", "Connection: keep-alive", "Content-Length: 0", "Cache-Control: max-age=0", "Cache-Control: no-cache", "Expect: 100-continue"}));
    private static final Set<String> alwaysParsedHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"connection", "content-encoding", "content-length", "content-type", "expect", "host", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "transfer-encoding", "upgrade"}));

    private char[] $lessinit$greater$default$4() {
        return new char[512];
    }

    private int $lessinit$greater$default$5() {
        return 0;
    }

    private short[] $lessinit$greater$default$6() {
        return new short[762];
    }

    private int $lessinit$greater$default$7() {
        return 0;
    }

    private Object[] $lessinit$greater$default$8() {
        return new Object[255];
    }

    private int $lessinit$greater$default$9() {
        return 0;
    }

    public boolean akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10() {
        return false;
    }

    private Seq<String> predefinedHeaders() {
        return predefinedHeaders;
    }

    private Set<String> alwaysParsedHeaders() {
        return alwaysParsedHeaders;
    }

    public HttpHeaderParser apply(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return this.prime(this.unprimed(settings, log, this.defaultIllegalHeaderHandler(settings, log)));
    }

    public Function1<ErrorInfo, BoxedUnit> defaultIllegalHeaderHandler(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return settings.illegalHeaderWarnings() ? (Function1 & Serializable)info -> {
            package$.MODULE$.logParsingError(info.withSummaryPrepended("Illegal header"), log, settings.errorLoggingVerbosity(), settings.ignoreIllegalHeaderFor());
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable)x$7 -> {
            HttpHeaderParser$.$anonfun$defaultIllegalHeaderHandler$2(x$7);
            return BoxedUnit.UNIT;
        };
    }

    public HttpHeaderParser unprimed(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpHeaderParser(settings, log, warnOnIllegalHeader, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10());
    }

    public HttpHeaderParser prime(HttpHeaderParser parser) {
        Set<String> headerParserFilter = parser.settings().modeledHeaderParsing() ? x$8 -> BoxesRunTime.boxToBoolean((boolean)HttpHeaderParser$.$anonfun$prime$1(x$8)) : this.alwaysParsedHeaders();
        Seq valueParsers = (Seq)((IterableOnce)HeaderParser$.MODULE$.ruleNames().filter(headerParserFilter)).iterator().map((Function1 & Serializable)name -> new HttpHeaderParser.ModeledHeaderValueParser((String)name, parser.settings().maxHeaderValueLength(), parser.settings().headerValueCacheLimit((String)name), parser.log(), parser.settings())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        Seq x$1 = (Seq)valueParsers.sortBy((Function1 & Serializable)x$9 -> x$9.headerName(), (Ordering)Ordering.String$.MODULE$);
        int x$2 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$1);
        int x$3 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$1);
        this.insertInGoodOrder$1(x$1, x$2, x$3, parser);
        Seq<SpecializedHeaderValueParsers$ContentLengthParser$> x$4 = SpecializedHeaderValueParsers$.MODULE$.specializedHeaderValueParsers();
        int x$5 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$4);
        int x$6 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$4);
        this.insertInGoodOrder$1(x$4, x$5, x$6, parser);
        Seq x$7 = (Seq)this.predefinedHeaders().sorted((Ordering)Ordering.String$.MODULE$);
        int x$82 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$7);
        int x$92 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$7);
        this.insertInGoodOrder$1(x$7, x$82, x$92, parser);
        ByteString x$10 = ByteString$.MODULE$.apply("\r\n");
        EmptyHeader$ x$11 = EmptyHeader$.MODULE$;
        int x$12 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$10, x$11);
        int x$13 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$10, x$11);
        int x$14 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$10, x$11);
        int x$15 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$10, x$11);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$10, x$11, x$12, x$13, x$14, x$15);
        ByteString x$16 = ByteString$.MODULE$.apply("\n");
        EmptyHeader$ x$17 = EmptyHeader$.MODULE$;
        int x$18 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$16, x$17);
        int x$19 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$16, x$17);
        int x$20 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$16, x$17);
        int x$21 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$16, x$17);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$16, x$17, x$18, x$19, x$20, x$21);
        return parser;
    }

    public void insert(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$1 = input;
        Object x$2 = value;
        int x$3 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$1, x$2);
        int x$4 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$1, x$2);
        int x$5 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$1, x$2);
        int x$6 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$1, x$2);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public void insertRemainingCharsAsNewNodes(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$1 = input;
        Object x$2 = value;
        int x$3 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$1, x$2);
        int x$4 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$1, x$2);
        int x$5 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$1, x$2);
        int x$6 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$1, x$2);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tuple2<String, Object> akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode, StringBuilder sb, int ix) {
        block14: while (true) {
            StringBuilder stringBuilder;
            hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().clear();
            if (ix >= limit) throw this.fail(new StringBuilder(61).append("HTTP header value exceeds the configured limit of ").append(limit - start - 2).append(" characters").toString(), StatusCodes$.MODULE$.RequestHeaderFieldsTooLarge());
            char c = package$.MODULE$.byteChar(input, ix);
            switch (c) {
                case '\t': {
                    StringBuilder stringBuilder2 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                    ++ix;
                    sb = stringBuilder2;
                    continue block14;
                }
                case '\r': {
                    if (package$.MODULE$.byteChar(input, ix + 1) != '\n') break;
                    if (CharacterClasses$.MODULE$.WSP().apply(package$.MODULE$.byteChar(input, ix + 2))) {
                        StringBuilder stringBuilder3 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                        ix += 3;
                        sb = stringBuilder3;
                        continue block14;
                    }
                    Tuple2 tuple2 = new Tuple2((Object)(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix)), (Object)BoxesRunTime.boxToInteger((int)(ix + 2)));
                    return tuple2;
                }
                case '\n': {
                    if (CharacterClasses$.MODULE$.WSP().apply(package$.MODULE$.byteChar(input, ix + 1))) {
                        StringBuilder stringBuilder4 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                        ix += 2;
                        sb = stringBuilder4;
                        continue block14;
                    }
                    Tuple2 tuple2 = new Tuple2((Object)(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix)), (Object)BoxesRunTime.boxToInteger((int)(ix + 1)));
                    return tuple2;
                }
            }
            int nix = ix + 1;
            if (' ' <= c && c <= '\u007f') {
                stringBuilder = sb != null ? sb.append(c) : null;
            } else if ((c & 0xE0) == 192) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                nix = ix + 2;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else if ((c & 0xF0) == 224) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                nix = ix + 3;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else if ((c & 0xF8) == 240) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 3));
                nix = ix + 4;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2)).append(package$.MODULE$.byteChar(input, ix + 3));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else {
                StringBuilder stringBuilder5;
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = mode;
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    throw this.fail(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c)).append("' in header value").toString(), this.fail$default$2());
                }
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    log.warning(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c)).append("' in header value").toString());
                    stringBuilder5 = sb;
                } else {
                    if (!ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) throw new MatchError((Object)illegalResponseHeaderValueProcessingMode);
                    stringBuilder5 = sb;
                }
                stringBuilder = stringBuilder5;
            }
            StringBuilder nsb = stringBuilder;
            ix = nix;
            sb = nsb;
        }
    }

    public StringBuilder akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$7(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return null;
    }

    public int akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$8(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return start;
    }

    public Nothing$ fail(String summary, StatusCode status) {
        throw new ParsingException(status, ErrorInfo$.MODULE$.apply(summary, ErrorInfo$.MODULE$.apply$default$2()));
    }

    public StatusCode fail$default$2() {
        return StatusCodes$.MODULE$.BadRequest();
    }

    public static final /* synthetic */ void $anonfun$defaultIllegalHeaderHandler$2(ErrorInfo x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$prime$1(String x$8) {
        return true;
    }

    private final void insertInGoodOrder$1(Seq items, int startIx, int endIx, HttpHeaderParser parser$1) {
        while (endIx - startIx > 0) {
            Integer n;
            int pivot = (startIx + endIx) / 2;
            Object object = items.apply(pivot);
            if (object instanceof HttpHeaderParser.HeaderValueParser) {
                BoxedUnit boxedUnit;
                HttpHeaderParser.HeaderValueParser headerValueParser = (HttpHeaderParser.HeaderValueParser)object;
                String insertName = new StringBuilder(11).append(EnhancedString$.MODULE$.toRootLowerCase$extension(akka.http.impl.util.package$.MODULE$.enhanceString_(headerValueParser.headerName()))).append(':').toString();
                if (parser$1.isEmpty()) {
                    ByteString x$1 = ByteString$.MODULE$.apply(insertName);
                    HttpHeaderParser.HeaderValueParser x$2 = headerValueParser;
                    int x$3 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$1, x$2);
                    int x$4 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$1, x$2);
                    int x$5 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$1, x$2);
                    int x$6 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$1, x$2);
                    parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$1, x$2, x$3, x$4, x$5, x$6);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    ByteString x$7 = ByteString$.MODULE$.apply(insertName);
                    HttpHeaderParser.HeaderValueParser x$8 = headerValueParser;
                    int x$9 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$7, x$8);
                    int x$10 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$7, x$8);
                    int x$11 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$7, x$8);
                    int x$12 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$7, x$8);
                    parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$7, x$8, x$9, x$10, x$11, x$12);
                    boxedUnit = BoxedUnit.UNIT;
                }
                n = boxedUnit;
            } else if (object instanceof String) {
                String string = (String)object;
                ByteString x$13 = ByteString$.MODULE$.apply(new StringBuilder(3).append(string).append("\r\nx").toString());
                int x$14 = parser$1.parseHeaderLine$default$2();
                int x$15 = parser$1.parseHeaderLine$default$3(x$13, x$14);
                int x$16 = parser$1.parseHeaderLine$default$4(x$13, x$14);
                n = BoxesRunTime.boxToInteger((int)parser$1.parseHeaderLine(x$13, x$14, x$15, x$16));
            } else {
                throw new MatchError(object);
            }
            this.insertInGoodOrder$1(items, startIx, pivot, parser$1);
            startIx = pivot + 1;
        }
    }

    private static final int insertInGoodOrder$default$2$1(Seq items) {
        return 0;
    }

    private static final int insertInGoodOrder$default$3$1(Seq items) {
        return items.size();
    }

    private static final StringBuilder appended$1(char c, StringBuilder sb$2, ByteString input$3, int start$1, int ix$1) {
        return (sb$2 != null ? sb$2 : new StringBuilder(package$.MODULE$.asciiString(input$3, start$1, ix$1))).append(c);
    }

    private static final StringBuilder appended2$1(int c, StringBuilder sb$2, ByteString input$3, int start$1, int ix$1) {
        return c >> 16 != 0 ? HttpHeaderParser$.appended$1((char)c, sb$2, input$3, start$1, ix$1).append((char)(c >> 16)) : HttpHeaderParser$.appended$1((char)c, sb$2, input$3, start$1, ix$1);
    }

    private HttpHeaderParser$() {
    }
}

