/*
 * Decompiled with CFR 0.152.
 */
package org.testng.log4testng;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.testng.collections.Maps;

public class Logger {
    private static int i = 0;
    private static final int TRACE = i++;
    private static final int DEBUG = i++;
    private static final int INFO = i++;
    private static final int WARN = i++;
    private static final int ERROR = i++;
    private static final int FATAL = i++;
    private static final int LEVEL_COUNT = i;
    private static final String PREFIX = "log4testng.";
    private static final String LOGGER_PREFIX = "log4testng.logger.";
    private static final String ROOT_LOGGER = "log4testng.rootLogger";
    private static final String DEBUG_PROPERTY = "log4testng.debug";
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;
    private static final String[] levelNames = new String[LEVEL_COUNT];
    private static final Map<String, Integer> levelMap;
    private static boolean initialized;
    private static final Map<String, Integer> loggerLevels;
    private static final Map<Class, Logger> loggers;
    private static int rootLoggerLevel;
    private static boolean debug;
    private final int level;
    private final Class klass;
    private final String m_className;

    public static synchronized Logger getLogger(Class clazz) {
        Logger.initialize();
        Logger logger = loggers.get(clazz);
        if (logger != null) {
            return logger;
        }
        int n = Logger.getLevel(clazz);
        logger = new Logger(clazz, n);
        loggers.put(clazz, logger);
        return logger;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(TRACE);
    }

    public void trace(Object object) {
        this.log(TRACE, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(TRACE, object, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(DEBUG);
    }

    public void debug(Object object) {
        this.log(DEBUG, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(DEBUG, object, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(INFO);
    }

    public void info(Object object) {
        this.log(INFO, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(INFO, object, throwable);
    }

    public void warn(Object object) {
        this.log(WARN, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(WARN, object, throwable);
    }

    public void error(Object object) {
        this.log(ERROR, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.log(FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(FATAL, object, throwable);
    }

    private Logger(Class clazz, int n) {
        this.level = n;
        this.klass = clazz;
        this.m_className = clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("log4testng.properties");
        if (inputStream == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Logger.checkProperties(properties);
    }

    private static void checkProperties(Properties properties) {
        Object object = properties.getProperty(DEBUG_PROPERTY);
        if (object != null) {
            if (((String)object).equalsIgnoreCase("true")) {
                debug = true;
            } else if (((String)object).equalsIgnoreCase("false")) {
                debug = false;
            } else {
                throw new IllegalArgumentException("Unknown log4testng.debug value " + (String)object);
            }
        }
        Logger.loglog4testng("log4testng.debug set to " + debug);
        object = properties.getProperty(ROOT_LOGGER);
        if (object != null) {
            Integer object2 = levelMap.get(((String)object).toUpperCase());
            if (object2 == null) {
                throw new IllegalArgumentException("Unknown level for log4testng.rootLogger " + (String)object + " in log4testng.properties");
            }
            rootLoggerLevel = object2;
            Logger.loglog4testng("Root level logger set to " + (String)object + " level.");
        }
        for (Map.Entry entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!string.startsWith(PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + string);
            }
            if (string.equals(DEBUG_PROPERTY) || string.equals(ROOT_LOGGER)) continue;
            if (!string.startsWith(LOGGER_PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + string);
            }
            Integer n = levelMap.get(string2.toUpperCase());
            if (n == null) {
                throw new IllegalArgumentException("Unknown level " + string2 + " for logger " + string + " in log4testng.properties");
            }
            loggerLevels.put(string.substring(LOGGER_PREFIX.length()), n);
            Logger.loglog4testng("logger " + string + " set to " + n + " level.");
        }
    }

    private static int getLevel(Class clazz) {
        String string = clazz.getName();
        Logger.loglog4testng("Getting level for logger " + string);
        while (true) {
            Integer n;
            if ((n = loggerLevels.get(string)) != null) {
                Logger.loglog4testng("Found level " + n + " for logger " + string);
                return n;
            }
            int n2 = string.lastIndexOf(46);
            if (n2 == -1) {
                Logger.loglog4testng("Found level " + rootLoggerLevel + " for root logger");
                return rootLoggerLevel;
            }
            string = string.substring(0, n2);
        }
    }

    private boolean isLevelEnabled(int n) {
        return this.level <= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int n, Object object, Throwable throwable) {
        if (this.isLevelEnabled(n)) {
            PrintStream printStream;
            PrintStream printStream2 = printStream = n >= ERROR ? err : out;
            if (null != throwable) {
                PrintStream printStream3 = printStream;
                synchronized (printStream3) {
                    printStream.println("[" + this.m_className + "] [" + levelNames[n] + "] " + object);
                    throwable.printStackTrace(printStream);
                }
            } else {
                printStream.println("[" + this.m_className + "] [" + levelNames[n] + "] " + object);
            }
        }
    }

    private static void loglog4testng(String string) {
        if (debug) {
            out.println("[log4testng] [debug] " + string);
        }
    }

    private static synchronized void testInitialize(Properties properties, PrintStream printStream, PrintStream printStream2) {
        initialized = true;
        loggers.clear();
        rootLoggerLevel = WARN;
        debug = false;
        out = printStream;
        err = printStream2;
        Logger.checkProperties(properties);
    }

    private static void testDebugDefault() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(properties, printStream, printStream2);
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    private static void testDebugOn() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(DEBUG_PROPERTY, "true");
        properties.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(properties, printStream, printStream2);
        Assert.assertTrue(byteArrayOutputStream.toString().startsWith("[log4testng][debug]"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    private static void testDebugOff() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(DEBUG_PROPERTY, "false");
        properties.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(properties, printStream, printStream2);
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    private static void testDebugError() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(DEBUG_PROPERTY, "unknown");
        properties.put(ROOT_LOGGER, "WARN");
        try {
            Logger.testInitialize(properties, printStream, printStream2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertEquals(byteArrayOutputStream.toString(), "");
            Assert.assertEquals(byteArrayOutputStream2.toString(), "");
            return;
        }
    }

    private static void testRootLoggerDefault() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        Logger.testInitialize(properties, printStream, printStream2);
        Logger logger = Logger.getLogger(String.class);
        logger.trace("trace should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.debug("debug should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.info("info should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.warn("warn should appear");
        int n = byteArrayOutputStream.toString().length();
        Assert.assertTrue(byteArrayOutputStream.toString().startsWith("[java.lang.String] [WARN] warn should appear"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.error("error should appear");
        Assert.assertEquals(byteArrayOutputStream.toString().length(), n);
        Assert.assertTrue(byteArrayOutputStream2.toString().startsWith("[java.lang.String] [ERROR] error should appear"));
        logger.fatal("fatal should appear");
        Assert.assertEquals(byteArrayOutputStream.toString().length(), n);
        Assert.assertTrue(byteArrayOutputStream2.toString().contains("[java.lang.String] [FATAL] fatal should appear"));
    }

    private static void testRootLoggerSet() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(ROOT_LOGGER, "DEBUG");
        Logger.testInitialize(properties, printStream, printStream2);
        Logger logger = Logger.getLogger(String.class);
        logger.trace("trace should appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.debug("debug should appear");
        Assert.assertTrue(byteArrayOutputStream.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    private static void testRootLoggerSetError() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put(ROOT_LOGGER, "unknown");
        try {
            Logger.testInitialize(properties, printStream, printStream2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertEquals(byteArrayOutputStream.toString(), "");
            Assert.assertEquals(byteArrayOutputStream2.toString(), "");
            return;
        }
    }

    private static void testUserLoggerSet() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put("log4testng.logger.java.lang.String", "DEBUG");
        Logger.testInitialize(properties, printStream, printStream2);
        Logger logger = Logger.getLogger(String.class);
        logger.trace("trace should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.debug("debug should appear");
        int n = byteArrayOutputStream.toString().length();
        Assert.assertTrue(byteArrayOutputStream.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        Logger logger2 = Logger.getLogger(Class.class);
        logger2.debug("debug should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString().length(), n);
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger2.warn("warn should appear");
        Assert.assertTrue(byteArrayOutputStream.toString().contains("[java.lang.Class] [WARN] warn should appear"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    private static void testUserLoggerSetError() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put("log4testng.logger.java.lang.String", "unknown");
        try {
            Logger.testInitialize(properties, printStream, printStream2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertEquals(byteArrayOutputStream.toString(), "");
            Assert.assertEquals(byteArrayOutputStream2.toString(), "");
            return;
        }
    }

    private static void testUserLoggerSetHierarchy() {
        Properties properties = new Properties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        properties.put("log4testng.logger.java.lang", "DEBUG");
        Logger.testInitialize(properties, printStream, printStream2);
        Logger logger = Logger.getLogger(String.class);
        logger.trace("trace should not appear");
        Assert.assertEquals(byteArrayOutputStream.toString(), "");
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
        logger.debug("debug should appear");
        Assert.assertTrue(byteArrayOutputStream.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(byteArrayOutputStream2.toString(), "");
    }

    public static void main(String[] stringArray) {
        Logger.testDebugDefault();
        Logger.testDebugOn();
        Logger.testDebugOff();
        Logger.testDebugError();
        Logger.testRootLoggerDefault();
        Logger.testRootLoggerSet();
        Logger.testRootLoggerSetError();
        Logger.testUserLoggerSet();
        Logger.testUserLoggerSetError();
        Logger.testUserLoggerSetHierarchy();
    }

    static {
        Logger.levelNames[Logger.TRACE] = "TRACE";
        Logger.levelNames[Logger.DEBUG] = "DEBUG";
        Logger.levelNames[Logger.INFO] = "INFO";
        Logger.levelNames[Logger.WARN] = "WARN";
        Logger.levelNames[Logger.ERROR] = "ERROR";
        Logger.levelNames[Logger.FATAL] = "FATAL";
        levelMap = Maps.newHashMap();
        for (i = 0; i < LEVEL_COUNT; ++i) {
            levelMap.put(levelNames[i], i);
        }
        loggerLevels = Maps.newHashMap();
        loggers = Maps.newHashMap();
        rootLoggerLevel = WARN;
        debug = false;
    }
}

