/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import io.altoo.akka.serialization.kryo.Transformer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!Aq\u0004\u0001EC\u0002\u0013%\u0001\u0005C\u0003,\u0001\u0011\u0005C\u0006C\u00036\u0001\u0011\u0005cGA\tM5RZ%/_8D_6\u0004(/Z:t_JT!a\u0002\u0005\u0002\t-\u0014\u0018p\u001c\u0006\u0003\u0013)\tQb]3sS\u0006d\u0017N_1uS>t'BA\u0006\r\u0003\u0011\t7n[1\u000b\u00055q\u0011!B1mi>|'\"A\b\u0002\u0005%|7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\ta!\u0003\u0002\u001c\r\tYAK]1og\u001a|'/\\3s\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u001a\u0001\u0005QAN\u001f\u001bgC\u000e$xN]=\u0016\u0003\u0005\u0002\"AI\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\u00071THG\u0003\u0002'O\u00059!\u000e]8v]RT(\"\u0001\u0015\u0002\u00079,G/\u0003\u0002+G\tQAJ\u0017\u001bGC\u000e$xN]=\u0002\u0011Q|')\u001b8bef$\"!L\u001a\u0011\u0007Mq\u0003'\u0003\u00020)\t)\u0011I\u001d:bsB\u00111#M\u0005\u0003eQ\u0011AAQ=uK\")Ag\u0001a\u0001[\u0005I\u0011N\u001c9vi\n+hMZ\u0001\u000bMJ|WNQ5oCJLHCA\u00178\u0011\u0015!D\u00011\u0001.\u0001")
public class LZ4KryoCompressor
implements Transformer {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    private LZ4Factory lz4factory() {
        if (!this.bitmap$0) {
            return this.lz4factory$lzycompute();
        }
        return this.lz4factory;
    }

    @Override
    public byte[] toBinary(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(outputBuff), outputSize + 4);
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        int size = inputBuff[0] & 0xFF | (inputBuff[1] & 0xFF) << 8 | (inputBuff[2] & 0xFF) << 16 | (inputBuff[3] & 0xFF) << 24;
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, 4, outputBuff, 0, size);
        return outputBuff;
    }
}

