/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import org.dbunit.assertion.FailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAssert {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAssert.class);
    private FailureHandler failureHandler;

    public SimpleAssert(FailureHandler failureHandler) {
        if (failureHandler == null) {
            throw new NullPointerException("The parameter 'failureHandler' must not be null");
        }
        this.failureHandler = failureHandler;
    }

    protected void assertNotNullNorEmpty(String propertyName, String property) {
        logger.debug("assertNotNullNorEmpty(propertyName={}, property={}) - start", (Object)propertyName, (Object)property);
        this.assertTrue(propertyName + " is null", property != null);
        this.assertTrue("Invalid " + propertyName, property.trim().length() > 0);
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(null, condition);
    }

    public void assertTrue(String message, boolean condition) {
        if (!condition) {
            this.fail(message);
        }
    }

    public void assertNotNull(Object object) {
        this.assertTrue(null, object != null);
    }

    public void assertNotNull(String message, Object object) {
        this.assertTrue(message, object != null);
    }

    public void fail(String message) {
        throw this.failureHandler.createFailure(message);
    }
}

