/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import kamon.metric.Instrument;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005uaa\u0002\r\u001a!\u0003\r\nA\b\u0005\u0006k\u00011\tA\u000e\u0005\u0006k\u00011\ta\u000e\u0005\u0006{\u00011\tA\u000e\u0005\u0006{\u00011\tA\u0010\u0005\u0006\u0001\u00021\t!Q\u0004\u0006\tfA\t!\u0012\u0004\u00061eA\tA\u0012\u0005\u0006\u000f\u001e!\t\u0001\u0013\u0004\u0005\u0013\u001e\u0001!\n\u0003\u0005\u001b\u0013\t\u0015\r\u0011\"\u0001^\u0011!\t\u0017B!A!\u0002\u0013q\u0006\u0002\u00032\n\u0005\u000b\u0007I\u0011A2\t\u0011)L!\u0011!Q\u0001\n\u0011DQaR\u0005\u0005\u0002-Dq\u0001]\u0005C\u0002\u0013%\u0011\u000f\u0003\u0004\u007f\u0013\u0001\u0006IA\u001d\u0005\u0006k%!\tE\u000e\u0005\u0006k%!\te \u0005\u0006{%!\tE\u000e\u0005\u0007{%!\t%a\u0001\t\r\u0001KA\u0011IA\u0004\u0011\u001d\ti!\u0003C!\u0003\u001fAa!a\u0007\n\t\u0003j&!B$bk\u001e,'B\u0001\u000e\u001c\u0003\u0019iW\r\u001e:jG*\tA$A\u0003lC6|gn\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0005M\u001dJ#&D\u0001\u001a\u0013\tA\u0013D\u0001\u0006J]N$(/^7f]R\u0004\"A\n\u0001\u0011\u0005-\u0012dB\u0001\u00170\u001d\t1S&\u0003\u0002/3\u00051Q*\u001a;sS\u000eL!\u0001M\u0019\u0002\u0011M+G\u000f^5oONT!AL\r\n\u0005M\"$A\u0005$peZ\u000bG.^3J]N$(/^7f]RT!\u0001M\u0019\u0002\u0013%t7M]3nK:$H#A\u0015\u0015\u0005%B\u0004\"B\u001d\u0003\u0001\u0004Q\u0014!\u0002;j[\u0016\u001c\bC\u0001\u0011<\u0013\ta\u0014E\u0001\u0004E_V\u0014G.Z\u0001\nI\u0016\u001c'/Z7f]R$\"!K \t\u000be\"\u0001\u0019\u0001\u001e\u0002\rU\u0004H-\u0019;f)\tI#\tC\u0003D\u000b\u0001\u0007!(A\u0003wC2,X-A\u0003HCV<W\r\u0005\u0002'\u000fM\u0011qaH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0013\u0001BV8mCRLG.Z\n\u0006\u0013}I3J\u0015\t\u0004\u0019>SdB\u0001\u0014N\u0013\tq\u0015$\u0001\u0006J]N$(/^7f]RL!\u0001U)\u0003\u0019Ms\u0017\r]:i_R$\u0018N\\4\u000b\u00059K\u0002#B*\\S)RdB\u0001+.\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y;\u00051AH]8pizJ\u0011\u0001H\u0005\u00035mI!\u0001X\u0019\u0003)\t\u000b7/Z'fiJL7-Q;u_V\u0003H-\u0019;f+\u0005q\u0006#B*`S)R\u0014B\u000112\u0005)\u0011\u0015m]3NKR\u0014\u0018nY\u0001\b[\u0016$(/[2!\u0003\u0011!\u0018mZ:\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!aZ\u000e\u0002\u0007Q\fw-\u0003\u0002jM\n1A+Y4TKR\fQ\u0001^1hg\u0002\"2\u0001\u001c8p!\ti\u0017\"D\u0001\b\u0011\u0015Qb\u00021\u0001_\u0011\u0015\u0011g\u00021\u0001e\u00035y6-\u001e:sK:$h+\u00197vKV\t!\u000f\u0005\u0002ty6\tAO\u0003\u0002vm\u00061\u0011\r^8nS\u000eT!a\u001e=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! ;\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\b`GV\u0014(/\u001a8u-\u0006dW/\u001a\u0011\u0015\u0007%\n\t\u0001C\u0003:%\u0001\u0007!\bF\u0002*\u0003\u000bAQ!\u000f\u000bA\u0002i\"2!KA\u0005\u0011\u0019\tY!\u0006a\u0001u\u0005Aa.Z<WC2,X-\u0001\u0005t]\u0006\u00048\u000f[8u)\rQ\u0014\u0011\u0003\u0005\b\u0003'1\u0002\u0019AA\u000b\u0003)\u0011Xm]3u'R\fG/\u001a\t\u0004A\u0005]\u0011bAA\rC\t9!i\\8mK\u0006t\u0017A\u00032bg\u0016lU\r\u001e:jG\u0002")
public interface Gauge
extends Instrument<Gauge, Metric.Settings.ForValueInstrument> {
    public Gauge increment();

    public Gauge increment(double var1);

    public Gauge decrement();

    public Gauge decrement(double var1);

    public Gauge update(double var1);

    public static class Volatile
    implements Gauge,
    Instrument.Snapshotting<Object>,
    Metric.BaseMetricAutoUpdate<Gauge, Metric.Settings.ForValueInstrument, Object> {
        private final Metric.BaseMetric<Gauge, Metric.Settings.ForValueInstrument, Object> metric;
        private final TagSet tags;
        private final AtomicLong _currentValue;

        @Override
        public void defaultSchedule() {
            Metric.BaseMetricAutoUpdate.defaultSchedule$(this);
        }

        @Override
        public Instrument autoUpdate(Function1 consumer, Duration interval) {
            return Metric.BaseMetricAutoUpdate.autoUpdate$(this, consumer, interval);
        }

        @Override
        public boolean remove() {
            return Instrument.remove$(this);
        }

        @Override
        public Instrument withTag(String key, String value) {
            return Instrument.withTag$((Instrument)this, key, value);
        }

        @Override
        public Instrument withTag(String key, boolean value) {
            return Instrument.withTag$((Instrument)this, key, value);
        }

        @Override
        public Instrument withTag(String key, long value) {
            return Instrument.withTag$((Instrument)this, key, value);
        }

        @Override
        public Instrument withTags(TagSet tags) {
            return Instrument.withTags$(this, tags);
        }

        @Override
        public Instrument autoUpdate(Consumer consumer) {
            return Instrument.autoUpdate$((Instrument)this, consumer);
        }

        @Override
        public Instrument autoUpdate(Consumer consumer, Duration interval) {
            return Instrument.autoUpdate$(this, consumer, interval);
        }

        @Override
        public Instrument autoUpdate(Function1 consumer) {
            return Instrument.autoUpdate$((Instrument)this, consumer);
        }

        public Metric.BaseMetric<Gauge, Metric.Settings.ForValueInstrument, Object> metric() {
            return this.metric;
        }

        @Override
        public TagSet tags() {
            return this.tags;
        }

        private AtomicLong _currentValue() {
            return this._currentValue;
        }

        @Override
        public Gauge increment() {
            return this.increment(1.0);
        }

        @Override
        public Gauge increment(double times) {
            this._currentValue().updateAndGet(new LongUnaryOperator(null, times){
                private final double times$1;

                public LongUnaryOperator compose(LongUnaryOperator x$1) {
                    return LongUnaryOperator.super.compose(x$1);
                }

                public LongUnaryOperator andThen(LongUnaryOperator x$1) {
                    return LongUnaryOperator.super.andThen(x$1);
                }

                public long applyAsLong(long v) {
                    double newValue = Double.longBitsToDouble(v) + this.times$1;
                    return newValue < 0.0 ? v : Double.doubleToLongBits(newValue);
                }
                {
                    this.times$1 = times$1;
                }
            });
            return this;
        }

        @Override
        public Gauge decrement() {
            return this.decrement(1.0);
        }

        @Override
        public Gauge decrement(double times) {
            this._currentValue().updateAndGet(new LongUnaryOperator(null, times){
                private final double times$2;

                public LongUnaryOperator compose(LongUnaryOperator x$1) {
                    return LongUnaryOperator.super.compose(x$1);
                }

                public LongUnaryOperator andThen(LongUnaryOperator x$1) {
                    return LongUnaryOperator.super.andThen(x$1);
                }

                public long applyAsLong(long v) {
                    double newValue = Double.longBitsToDouble(v) - this.times$2;
                    return newValue < 0.0 ? v : Double.doubleToLongBits(newValue);
                }
                {
                    this.times$2 = times$2;
                }
            });
            return this;
        }

        @Override
        public Gauge update(double newValue) {
            block0: {
                if (!(newValue >= 0.0)) break block0;
                this._currentValue().set(Double.doubleToLongBits(newValue));
            }
            return this;
        }

        @Override
        public double snapshot(boolean resetState) {
            return Double.longBitsToDouble(this._currentValue().get());
        }

        @Override
        public Metric.BaseMetric<Gauge, Metric.Settings.ForValueInstrument, Object> baseMetric() {
            return this.metric();
        }

        public Volatile(Metric.BaseMetric<Gauge, Metric.Settings.ForValueInstrument, Object> metric, TagSet tags) {
            this.metric = metric;
            this.tags = tags;
            Instrument.$init$(this);
            Metric.BaseMetricAutoUpdate.$init$(this);
            this._currentValue = new AtomicLong(0L);
        }
    }
}

