/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment.setter;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.deployment.setter.AbstractPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPropertySetter
extends AbstractPropertySetter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertySetter.class);

    @Autowired
    public DefaultPropertySetter(RepositoryService repository) {
        super(repository);
    }

    private boolean isPropertyValueEmptyOrNull(ConfigurationItem ci, String propertyName) {
        if (ci == null || !ci.hasProperty(propertyName)) {
            return true;
        }
        Object value = ci.getProperty(propertyName);
        PropertyDescriptor propertyDescriptor = ci.getType().getDescriptor().getPropertyDescriptor(propertyName);
        return this.isNullOrEmpty(value, propertyDescriptor);
    }

    private void setValidationMessages(ConfigurationItem target, PropertyDescriptor targetPropertyDescriptor, String propertyName, String message) {
        logger.error("Could not resolve dictionary keys for property " + targetPropertyDescriptor + " on " + target + ".");
        target.get$validationMessages().add(ValidationMessage.warn((String)target.getId(), (String)propertyName, (String)String.format("Could not resolve the property value(s) %s using the dictionary", message)));
    }

    private void resolveSourceValueFromDictionary(ConfigurationItem target, Object sourceValue, ConsolidatedDictionary dictionary, PropertyDescriptor sourcePropertyDescriptor, PropertyDescriptor targetPropertyDescriptor) {
        String propertyName = targetPropertyDescriptor.getName();
        try {
            HashSet missingPlaceholdersAggregator = new HashSet();
            Object targetValue = dictionary.resolve(sourceValue, sourcePropertyDescriptor, missingPlaceholdersAggregator);
            if (targetValue instanceof EncryptedStringValue && !targetPropertyDescriptor.isPassword()) {
                logger.warn("The source value [{}] resolved to an encrypted value, but property [{}] is not a password field.", sourceValue, (Object)targetPropertyDescriptor.getFqn());
                ValidationMessage validationMessage = ValidationMessage.warn((String)target.getId(), (String)propertyName, (String)"The deployable value resolved to an encrypted value, but this field is not a password");
                target.get$validationMessages().add(validationMessage);
                return;
            }
            this.setSilently(target, targetPropertyDescriptor, this.convertIfNeeded(targetValue, sourcePropertyDescriptor, targetPropertyDescriptor));
            if (!missingPlaceholdersAggregator.isEmpty()) {
                this.setValidationMessages(target, targetPropertyDescriptor, propertyName, missingPlaceholdersAggregator.stream().collect(Collectors.joining("}}\", \"{{", "\"{{", "}}\"")));
            }
        }
        catch (DictionaryValueException e) {
            this.setValidationMessages(target, targetPropertyDescriptor, propertyName, Optional.ofNullable(sourceValue).map(s -> String.format("\"%s\"", s)).orElse(null));
        }
    }

    private void resolveFromSource(ConfigurationItem source, ConfigurationItem target, PropertyDescriptor sourcePropertyDescriptor, PropertyDescriptor targetPropertyDescriptor, ConsolidatedDictionary dictionary) {
        logger.trace("Resolving property {} from source {} with type {}", new Object[]{targetPropertyDescriptor.getFqn(), source.getId(), source.getType()});
        Object deployableValue = sourcePropertyDescriptor.get(source);
        if (this.isNullOrEmpty(deployableValue, sourcePropertyDescriptor)) {
            logger.trace("Checking whether {} occurs in dictionary", (Object)targetPropertyDescriptor.getFqn());
            this.setDeployedFromDictionary(target, dictionary, targetPropertyDescriptor, sourcePropertyDescriptor);
            return;
        }
        this.resolveSourceValueFromDictionary(target, deployableValue, dictionary, sourcePropertyDescriptor, targetPropertyDescriptor);
    }

    private void resolveFromDictionary(ConfigurationItem currentDeployed, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc, PropertyDescriptor deployablePropDesc) {
        Object value = dictionary.get(deployedPropDesc.getFqn());
        value = this.convertIfNeeded(value, deployablePropDesc, deployedPropDesc);
        deployedPropDesc.set(currentDeployed, value);
    }

    private boolean isPropertyOnPreviousAndCurrentDeployableEmptyOrNull(ConfigurationItem currentDeployable, ConfigurationItem previousDeployable, String propertyName) {
        return this.isPropertyValueEmptyOrNull(currentDeployable, propertyName) && this.isPropertyValueEmptyOrNull(previousDeployable, propertyName);
    }

    private void copyFromPreviousDeployed(ConfigurationItem currentDeployed, ConfigurationItem previousDeployed, String propertyName) {
        Object propertyValue = this.getValueIfExists(previousDeployed, propertyName);
        currentDeployed.setProperty(propertyName, propertyValue);
    }

    @Override
    public void setProperty(ConfigurationItem currentTarget, ConfigurationItem previousTarget, ConfigurationItem currentSource, ConfigurationItem previousSource, ConsolidatedDictionary dictionary, PropertyDescriptor targetPropertyDescriptor, PropertyDescriptor sourcePropertyDescriptor) {
        String propertyName = targetPropertyDescriptor.getName();
        if (sourcePropertyDescriptor != null && !this.isPropertyValueEmptyOrNull(currentSource, propertyName)) {
            logger.trace("Resolving '{}' value from currentSource and setting the value on the current currentTarget", (Object)propertyName);
            this.resolveFromSource(currentSource, currentTarget, sourcePropertyDescriptor, targetPropertyDescriptor, dictionary);
        } else if (dictionary.containsKey(targetPropertyDescriptor.getFqn())) {
            logger.trace("Resolving {} from dictionary as dictionary contains a type default for the property of the currentTarget", (Object)propertyName);
            this.resolveFromDictionary(currentTarget, dictionary, targetPropertyDescriptor, sourcePropertyDescriptor);
        } else if (!this.isPropertyValueEmptyOrNull(currentTarget, propertyName)) {
            logger.trace("Using type system default as currentTarget '{}' has non-empty default value", (Object)propertyName);
        } else if (sourcePropertyDescriptor == null || this.isPropertyOnPreviousAndCurrentDeployableEmptyOrNull(currentSource, previousSource, propertyName)) {
            logger.trace("Copy previousTarget '{}' value to current currentTarget value", (Object)propertyName);
            this.copyFromPreviousDeployed(currentTarget, previousTarget, propertyName);
        } else {
            logger.trace("Leave currentTarget '{}' empty", (Object)propertyName);
        }
    }
}

