/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DDUtils;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;

public class CreateConstraintConstantAction
extends ConstraintConstantAction {
    private final boolean forCreateTable;
    private String[] columnNames;
    private String constraintText;
    private ConstraintInfo otherConstraintInfo;
    private ClassFactory cf;
    private boolean enabled;
    private boolean[] characteristics;
    private ProviderInfo[] providerInfo;

    CreateConstraintConstantAction(String string, int n, boolean[] blArray, boolean bl, String string2, UUID uUID, String string3, String[] stringArray, IndexConstantAction indexConstantAction, String string4, ConstraintInfo constraintInfo, ProviderInfo[] providerInfoArray) {
        super(string, n, string2, uUID, string3, indexConstantAction);
        this.forCreateTable = bl;
        this.columnNames = stringArray;
        this.constraintText = string4;
        this.characteristics = (boolean[])blArray.clone();
        this.otherConstraintInfo = constraintInfo;
        this.providerInfo = providerInfoArray;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor = null;
        ConglomerateDescriptor[] conglomerateDescriptorArray = null;
        ConstraintDescriptor constraintDescriptor = null;
        TableDescriptor tableDescriptor = null;
        UUID uUID = null;
        if (this.constraintType == 1) {
            return;
        }
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.cf = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor, transactionController);
            if (tableDescriptor == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            activation.setDDLTableDescriptor(tableDescriptor);
        }
        UUIDFactory uUIDFactory = dataDictionary.getUUIDFactory();
        UUID uUID2 = uUIDFactory.createUUID();
        if (this.indexAction != null) {
            String string;
            if (this.indexAction.getIndexName() == null) {
                string = uUIDFactory.createUUID().toString();
                this.indexAction.setIndexName(string);
            } else {
                string = this.indexAction.getIndexName();
            }
            this.indexAction.setConstraintID(uUID2);
            this.indexAction.executeConstantAction(activation);
            conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; !(i >= conglomerateDescriptorArray.length || (conglomerateDescriptor = conglomerateDescriptorArray[i]).isIndex() && string.equals(conglomerateDescriptor.getConglomerateName())); ++i) {
            }
            uUID = conglomerateDescriptor.getUUID();
        }
        boolean[] blArray = new boolean[]{false, false, true};
        for (int i = 0; i < this.characteristics.length; ++i) {
            if (this.characteristics[i] == blArray[i]) continue;
            dataDictionary.checkVersion(230, "DEFERRED CONSTRAINTS");
            if (this.constraintType != 1 && this.characteristics[2] || PropertyUtil.getSystemProperty("derby.constraintsTesting", "false").equals("true")) continue;
            throw StandardException.newException("0A000.S", "non-default constraint characteristics");
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        switch (this.constraintType) {
            case 2: {
                constraintDescriptor = dataDescriptorGenerator.newPrimaryKeyConstraintDescriptor(tableDescriptor, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, this.characteristics[2], 0);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                break;
            }
            case 3: {
                constraintDescriptor = dataDescriptorGenerator.newUniqueConstraintDescriptor(tableDescriptor, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, this.characteristics[2], 0);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                constraintDescriptor = dataDescriptorGenerator.newCheckConstraintDescriptor(tableDescriptor, this.constraintName, this.characteristics[0], this.characteristics[1], uUID2, this.constraintText, new ReferencedColumnsDescriptorImpl(this.genColumnPositions(tableDescriptor, false)), schemaDescriptor, this.characteristics[2]);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                this.storeConstraintDependenciesOnPrivileges(activation, constraintDescriptor, null, this.providerInfo);
                break;
            }
            case 6: {
                ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = DDUtils.locateReferencedConstraint(dataDictionary, tableDescriptor, this.constraintName, this.columnNames, this.otherConstraintInfo);
                DDUtils.validateReferentialActions(dataDictionary, tableDescriptor, this.constraintName, this.otherConstraintInfo, this.columnNames);
                constraintDescriptor = dataDescriptorGenerator.newForeignKeyConstraintDescriptor(tableDescriptor, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, referencedKeyConstraintDescriptor, this.characteristics[2], this.otherConstraintInfo.getReferentialActionDeleteRule(), this.otherConstraintInfo.getReferentialActionUpdateRule());
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                if (!this.forCreateTable && dataDictionary.activeConstraint(constraintDescriptor)) {
                    CreateConstraintConstantAction.validateFKConstraint(activation, transactionController, dataDictionary, (ForeignKeyConstraintDescriptor)constraintDescriptor, referencedKeyConstraintDescriptor, ((CreateIndexConstantAction)this.indexAction).getIndexTemplateRow());
                }
                dependencyManager.addDependency(constraintDescriptor, referencedKeyConstraintDescriptor, languageConnectionContext.getContextManager());
                this.storeConstraintDependenciesOnPrivileges(activation, constraintDescriptor, referencedKeyConstraintDescriptor.getTableId(), this.providerInfo);
                break;
            }
            case 7: {
                throw StandardException.newException("0A000.S", "ALTER CONSTRAINT");
            }
        }
        if (this.providerInfo != null) {
            for (int i = 0; i < this.providerInfo.length; ++i) {
                Provider provider = null;
                provider = (Provider)this.providerInfo[i].getDependableFinder().getDependable(dataDictionary, this.providerInfo[i].getObjectId());
                dependencyManager.addDependency(constraintDescriptor, provider, languageConnectionContext.getContextManager());
            }
        }
        if (!this.forCreateTable) {
            dependencyManager.invalidateFor(tableDescriptor, 22, languageConnectionContext);
        }
        if (this.constraintType == 6) {
            dependencyManager.invalidateFor(((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraint().getTableDescriptor(), 22, languageConnectionContext);
        }
        this.constraintId = uUID2;
    }

    boolean isForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    boolean isInitiallyDeferred() {
        return this.characteristics[1];
    }

    private int[] genColumnPositions(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        int[] nArray = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[i], this.tableName);
            }
            if (bl && !columnDescriptor.getType().getTypeId().orderable(this.cf)) {
                throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
            }
            nArray[i] = columnDescriptor.getPosition();
        }
        return nArray;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE CONSTRAINT " + this.constraintName);
        stringBuffer.append("\n=========================\n");
        if (this.columnNames == null) {
            stringBuffer.append("columnNames == null\n");
        } else {
            for (int i = 0; i < this.columnNames.length; ++i) {
                stringBuffer.append("\n\tcol[" + i + "]" + this.columnNames[i].toString());
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.constraintText);
        stringBuffer.append("\n");
        if (this.otherConstraintInfo != null) {
            stringBuffer.append(this.otherConstraintInfo.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

