/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;

public class SchemeBasedRoutePlanner
extends DefaultRoutePlanner {
    private final ProxyHostProperties httpsProxy;
    private final ProxyHostProperties httpProxy;

    public SchemeBasedRoutePlanner(ProxyHostProperties httpsProxy, ProxyHostProperties httpProxy) {
        super(null);
        this.httpsProxy = httpsProxy;
        this.httpProxy = httpProxy;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
        return "https".equals(target.getSchemeName()) ? this.determineProxy(this.httpsProxy, "https") : this.determineProxy(this.httpProxy, "http");
    }

    private HttpHost determineProxy(ProxyHostProperties properties, String scheme) {
        if (properties == null) {
            return null;
        }
        return new HttpHost(properties.getHost(), properties.getPort(), scheme);
    }
}

