/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.SQLException;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticPreparedBatchStatement
implements IPreparedBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(AutomaticPreparedBatchStatement.class);
    private final IPreparedBatchStatement _statement;
    private int _batchCount = 0;
    private int _threshold;
    private int _result = 0;

    public AutomaticPreparedBatchStatement(IPreparedBatchStatement statement, int threshold) {
        this._statement = statement;
        this._threshold = threshold;
    }

    @Override
    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        logger.debug("addValue(value={}, dataType={}) - start", value, (Object)dataType);
        this._statement.addValue(value, dataType);
    }

    @Override
    public void addBatch() throws SQLException {
        logger.debug("addBatch() - start");
        this._statement.addBatch();
        ++this._batchCount;
        if (this._batchCount % this._threshold == 0) {
            this._result += this._statement.executeBatch();
        }
    }

    @Override
    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        this._result += this._statement.executeBatch();
        return this._result;
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._statement.clearBatch();
        this._batchCount = 0;
    }

    @Override
    public void close() throws SQLException {
        logger.debug("close() - start");
        this._statement.close();
    }
}

