/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import io.netty.incubator.codec.quic.QuicSslEngine;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.incubator.quic.QuicClient;
import reactor.netty.incubator.quic.QuicConnection;
import reactor.netty.incubator.quic.QuicInitialSettingsSpec;
import reactor.netty.incubator.quic.QuicTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.annotation.Nullable;

public final class QuicClientConfig
extends QuicTransportConfig<QuicClientConfig> {
    public static final String QUIC_CLIENT_PREFIX = "reactor.netty.quic.client";
    Consumer<? super QuicClientConfig> doOnConnect;
    Consumer<? super QuicConnection> doOnConnected;
    Consumer<? super QuicConnection> doOnDisconnected;
    Supplier<? extends SocketAddress> remoteAddress;
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(QuicClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    QuicClientConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> streamOptions, Supplier<? extends SocketAddress> bindAddress, Supplier<? extends SocketAddress> remoteAddress) {
        super(options, streamOptions, bindAddress);
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
    }

    QuicClientConfig(QuicClientConfig parent) {
        super(parent);
        this.doOnConnect = parent.doOnConnect;
        this.doOnConnected = parent.doOnConnected;
        this.doOnDisconnected = parent.doOnDisconnected;
        this.remoteAddress = parent.remoteAddress;
    }

    @Nullable
    public Consumer<? super QuicClientConfig> doOnConnect() {
        return this.doOnConnect;
    }

    @Nullable
    public Consumer<? super QuicConnection> doOnConnected() {
        return this.doOnConnected;
    }

    @Nullable
    public Consumer<? super QuicConnection> doOnDisconnected() {
        return this.doOnDisconnected;
    }

    public Supplier<? extends SocketAddress> remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnConnected() == null && this.doOnDisconnected() == null) {
            return super.defaultConnectionObserver();
        }
        return super.defaultConnectionObserver().then((ConnectionObserver)new QuicClientDoOn(this.channelGroup(), this.doOnConnected(), this.doOnDisconnected()));
    }

    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerQuicClientMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelInitializer<Channel> parentChannelInitializer() {
        return new ParentChannelInitializer(this);
    }

    static final class QuicClientDoOn
    implements ConnectionObserver {
        final ChannelGroup channelGroup;
        final Consumer<? super QuicConnection> doOnConnected;
        final Consumer<? super QuicConnection> doOnDisconnected;

        QuicClientDoOn(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super QuicConnection> doOnConnected, @Nullable Consumer<? super QuicConnection> doOnDisconnected) {
            this.channelGroup = channelGroup;
            this.doOnConnected = doOnConnected;
            this.doOnDisconnected = doOnDisconnected;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add((Object)connection.channel());
                return;
            }
            if (this.doOnConnected != null && newState == ConnectionObserver.State.CONFIGURED) {
                this.doOnConnected.accept((QuicConnection)connection);
                return;
            }
            if (this.doOnDisconnected != null) {
                if (newState == ConnectionObserver.State.DISCONNECTING) {
                    connection.onDispose(() -> this.doOnDisconnected.accept((QuicConnection)connection));
                } else if (newState == ConnectionObserver.State.RELEASED) {
                    this.doOnDisconnected.accept((QuicConnection)connection);
                }
            }
        }
    }

    static final class ParentChannelInitializer
    extends ChannelInitializer<Channel> {
        final long ackDelayExponent;
        final boolean activeMigration;
        final QuicCongestionControlAlgorithm congestionControlAlgorithm;
        final boolean grease;
        final boolean hystart;
        final Duration idleTimeout;
        final QuicInitialSettingsSpec initialSettings;
        final int localConnectionIdLength;
        final ChannelHandler loggingHandler;
        final Duration maxAckDelay;
        final long maxRecvUdpPayloadSize;
        final long maxSendUdpPayloadSize;
        final int recvQueueLen;
        final int sendQueueLen;
        final Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider;

        ParentChannelInitializer(QuicClientConfig config) {
            this.ackDelayExponent = config.ackDelayExponent;
            this.activeMigration = config.activeMigration;
            this.congestionControlAlgorithm = config.congestionControlAlgorithm;
            this.grease = config.grease;
            this.hystart = config.hystart;
            this.idleTimeout = config.idleTimeout;
            this.initialSettings = config.initialSettings;
            this.localConnectionIdLength = config.localConnectionIdLength;
            this.loggingHandler = config.loggingHandler();
            this.maxAckDelay = config.maxAckDelay;
            this.maxRecvUdpPayloadSize = config.maxRecvUdpPayloadSize;
            this.maxSendUdpPayloadSize = config.maxSendUdpPayloadSize;
            this.recvQueueLen = config.recvQueueLen;
            this.sendQueueLen = config.sendQueueLen;
            this.sslEngineProvider = config.sslEngineProvider;
        }

        protected void initChannel(Channel channel) {
            QuicClientCodecBuilder quicClientCodecBuilder = new QuicClientCodecBuilder();
            ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)quicClientCodecBuilder.ackDelayExponent(this.ackDelayExponent)).activeMigration(this.activeMigration)).congestionControlAlgorithm(this.congestionControlAlgorithm)).grease(this.grease)).hystart(this.hystart)).initialMaxData(this.initialSettings.maxData)).initialMaxStreamDataBidirectionalLocal(this.initialSettings.maxStreamDataBidirectionalLocal)).initialMaxStreamDataBidirectionalRemote(this.initialSettings.maxStreamDataBidirectionalRemote)).initialMaxStreamDataUnidirectional(this.initialSettings.maxStreamDataUnidirectional)).initialMaxStreamsBidirectional(this.initialSettings.maxStreamsBidirectional)).initialMaxStreamsUnidirectional(this.initialSettings.maxStreamsUnidirectional)).localConnectionIdLength(this.localConnectionIdLength)).maxAckDelay(this.maxAckDelay.toMillis(), TimeUnit.MILLISECONDS)).maxRecvUdpPayloadSize(this.maxRecvUdpPayloadSize)).maxSendUdpPayloadSize(this.maxSendUdpPayloadSize)).sslEngineProvider(this.sslEngineProvider);
            if (this.recvQueueLen > 0 && this.sendQueueLen > 0) {
                quicClientCodecBuilder.datagram(this.recvQueueLen, this.sendQueueLen);
            }
            if (this.idleTimeout != null) {
                quicClientCodecBuilder.maxIdleTimeout(this.idleTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            if (this.loggingHandler != null) {
                channel.pipeline().addLast(new ChannelHandler[]{this.loggingHandler});
            }
            channel.pipeline().addLast(new ChannelHandler[]{quicClientCodecBuilder.build()});
        }
    }

    static final class MicrometerQuicClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerQuicClientMetricsRecorder INSTANCE = new MicrometerQuicClientMetricsRecorder();

        MicrometerQuicClientMetricsRecorder() {
            super(QuicClientConfig.QUIC_CLIENT_PREFIX, "quic");
        }
    }
}

