/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.prevayler.foundation.Chunking;
import org.prevayler.foundation.Guided;
import org.prevayler.foundation.Turn;
import org.prevayler.implementation.TransactionTimestamp;

public class TransactionGuide
extends Guided {
    private final TransactionTimestamp _transactionTimestamp;

    public TransactionGuide(TransactionTimestamp transactionTimestamp, Turn pipelineTurn) {
        super(pipelineTurn);
        this._transactionTimestamp = transactionTimestamp;
    }

    public TransactionTimestamp timestamp() {
        return this._transactionTimestamp;
    }

    public void checkSystemVersion(long expectedSystemVersion) {
        if (this._transactionTimestamp.systemVersion() != expectedSystemVersion) {
            throw new IllegalStateException("Attempted to process " + this._transactionTimestamp.systemVersion() + " when ready for " + expectedSystemVersion);
        }
    }

    public Date executionTime() {
        return this._transactionTimestamp.executionTime();
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        Chunking.writeChunk(stream, this._transactionTimestamp.toChunk());
    }
}

