/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.alter;

import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSessionOperation;

public class AlterSession
implements Statement {
    private AlterSessionOperation operation;
    private List<String> parameters;

    public AlterSession(AlterSessionOperation alterSessionOperation, List<String> list) {
        this.operation = alterSessionOperation;
        this.parameters = list;
    }

    public AlterSessionOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterSessionOperation alterSessionOperation) {
        this.operation = alterSessionOperation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> list) {
        this.parameters = list;
    }

    private static void appendParamaters(StringBuilder stringBuilder, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuilder.append(" ").append(string);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER SESSION ");
        switch (this.operation) {
            case ADVISE_COMMIT: {
                stringBuilder.append("ADVISE COMMIT");
                break;
            }
            case ADVISE_ROLLBACK: {
                stringBuilder.append("ADVISE ROLLBACK");
                break;
            }
            case ADVISE_NOTHING: {
                stringBuilder.append("ADVISE NOTHING");
                break;
            }
            case CLOSE_DATABASE_LINK: {
                stringBuilder.append("CLOSE DATABASE LINK ");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case ENABLE_COMMIT_IN_PROCEDURE: {
                stringBuilder.append("ENABLE COMMIT IN PROCEDURE");
                break;
            }
            case DISABLE_COMMIT_IN_PROCEDURE: {
                stringBuilder.append("DISABLE COMMIT IN PROCEDURE");
                break;
            }
            case ENABLE_GUARD: {
                stringBuilder.append("ENABLE GUARD");
                break;
            }
            case DISABLE_GUARD: {
                stringBuilder.append("DISABLE GUARD");
                break;
            }
            case ENABLE_PARALLEL_DML: {
                stringBuilder.append("ENABLE PARALLEL DML");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DML: {
                stringBuilder.append("DISABLE PARALLEL DML");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case FORCE_PARALLEL_DML: {
                stringBuilder.append("FORCE PARALLEL DML");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_DDL: {
                stringBuilder.append("ENABLE PARALLEL DDL");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DDL: {
                stringBuilder.append("DISABLE PARALLEL DDL");
                break;
            }
            case FORCE_PARALLEL_DDL: {
                stringBuilder.append("FORCE PARALLEL DDL");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_QUERY: {
                stringBuilder.append("ENABLE PARALLEL QUERY");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_QUERY: {
                stringBuilder.append("DISABLE PARALLEL QUERY");
                break;
            }
            case FORCE_PARALLEL_QUERY: {
                stringBuilder.append("FORCE PARALLEL QUERY");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case ENABLE_RESUMABLE: {
                stringBuilder.append("ENABLE RESUMABLE");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
                break;
            }
            case DISABLE_RESUMABLE: {
                stringBuilder.append("DISABLE RESUMABLE");
                break;
            }
            case SET: {
                stringBuilder.append("SET");
                AlterSession.appendParamaters(stringBuilder, this.parameters);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

