/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.CLOB;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleClobDataType
extends ClobDataType {
    private static final Logger logger = LoggerFactory.getLogger(OracleClobDataType.class);

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        return this.typeCast(resultSet.getClob(column));
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }

    protected Object getClob(Object value, Connection connection) throws TypeCastException {
        logger.debug("getClob(value={}, connection={}) - start", value, (Object)connection);
        CLOB tempClob = null;
        try {
            tempClob = oracle.sql.CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            tempClob.open(1);
            Writer tempClobWriter = tempClob.getCharacterOutputStream();
            tempClobWriter.write((String)this.typeCast(value));
            tempClobWriter.flush();
            tempClobWriter.close();
            tempClob.close();
        }
        catch (IOException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (SQLException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        return tempClob;
    }

    protected void freeTemporaryClob(CLOB tempClob) throws TypeCastException {
        logger.debug("freeTemporaryClob(tempClob={}) - start", (Object)tempClob);
        if (tempClob == null) {
            return;
        }
        try {
            tempClob.freeTemporary();
        }
        catch (SQLException e) {
            throw new TypeCastException("error freeing Oracle CLOB", e);
        }
    }
}

