/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;

public class TableColumnCountWarning
extends AbstractLiquibaseDynamicForecastRule {
    public TableColumnCountWarning() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Check Table Column Count";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "TableColumnLimit";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean internalEvaluate(ChangeSet object, DynamicRule dynamicRule) {
        for (Change change : ((ChangeSet)((Object)object)).getChanges()) {
            void var3_7;
            Integer n2;
            if (!(change instanceof CreateTableChange) || !this.doTableColumnCountCheck((CreateTableChange)change, n2 = (Integer)dynamicRule.getParameters().get(0).getValue())) continue;
            String string = "columns";
            if (n2 == 1) {
                String string2 = "column";
            }
            TableColumnCountWarning tableColumnCountWarning = this;
            tableColumnCountWarning.addFailureRuleIteration(tableColumnCountWarning.generateErrorMessage(String.format("must not have more than %d %s.", n2, var3_7)), dynamicRule);
        }
        return this.returnAtEndOfRule(dynamicRule);
    }

    private boolean doTableColumnCountCheck(CreateTableChange createTableChange, int n2) {
        return createTableChange.getColumns().size() > n2;
    }

    @Override
    public String getDescription() {
        return "Ensures that no table has more than a threshold number of columns.";
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.MAX_COLUMNS));
    }
}

